/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.log.ui.internal.wizards;

import java.util.*;

import org.eclipse.core.runtime.*;
import org.eclipse.hyades.logging.parsers.Parser;
import org.eclipse.jface.resource.*;

public class LogParserItem {
    private String _id = "";
    private String _name = "";
    private String _uiName = "_unknown";
    private String _desc = "";
    private ImageDescriptor _imgDesc;
    private String _class = "";
    private String _uiType = "text_field";    
    private ArrayList _parserFields = new ArrayList();
    private IConfigurationElement _config;

	/**
	 * Stores the widgets of this page
	 * Key = Widget ; Value = Listener
	 */
	private Hashtable _widgets;
	
	/**
	 * Keeps tracks of the listeners that _widgets have been sent to.
	 * Stores the hashCode() of the listener object.
	 */
	private Vector _listenersServed;
	
	
    public LogParserItem(String id, String name, String uiName, String desc) {
        if (id != null)
            _id = id;
        if (name != null)
            _name = name;
        if (uiName != null)
            _uiName = uiName;

        if (desc != null)
            _desc = desc;
    }

    public void setImageDescriptor(ImageDescriptor imgDesc) {
        _imgDesc = imgDesc;
    }

    public void setClass(String cls) {
        if (cls != null)
            _class = cls;
    }

    public void setUIType(String type) {
        if (type != null)
            _uiType = type;
    }

    public void addEntry(ParserField field) {
        _parserFields.add(field);
    }

    public String getName() {
        return _name;
    }

    public String getUIType() {
        return _uiType;
    }

    public String getUIName() {
        return _uiName;
    }

    public String getDescription() {
        return _desc;
    }

    public ImageDescriptor getImageDescriptor() {
        return _imgDesc;
    }

    public ArrayList getFields() {
        return _parserFields;
    }

    public String getId() {
        return _id;
    }

    public String getParserClass() {
        return _class;
    }

    public Parser getParserInstance() {
        try {

            if (_config == null)
                return null;

            Object elem = _config.createExecutableExtension("class");
            if (elem instanceof Parser) {

                return (Parser) elem;

            }
            else {
                System.err.println("LogParser should extend LogParser interface ! ");
            }
        }
        catch (CoreException exc) {
            return null;
        }

        return null;

    }

    public void setConfigurationElement(IConfigurationElement elem) {
        _config = elem;
    }
    
	/**
	 * Sets the widgets of this page
	 * 
	 * @param widgets - The widgets of the Location wizard page
	 */
	public void setWidgets (Hashtable widgets)
	{
		_widgets = widgets;
	}
	
	
	/**
	 * Retunrs the widgets of this page
	 *
	 * @return The widgets of 'Location' wizard page 
	 */
	public Hashtable getWidgets ()
	{
		return _widgets;
	}
	
	
	/**
	 * Sets the listeners that widgets of this page have been sent to.
	 * 
	 * @param listenersServed - The listeners that have received the widgets of the Location wizard page 
	 */
	public void setListenersServed(Vector listenersServed)
	{
		_listenersServed = listenersServed;
	}
	
	
	/**
	 * Return the listeners that widgets of this page have been sent to.
	 * 
	 * @return The listeners that the widgets of this page have been sent to
	 */
	public Vector getListenersServed()
	{
		return _listenersServed;
	}
}
