/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.actions.internal;

import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Status;

import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;

import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

import org.eclipse.hyades.trace.views.adapter.internal.CoverageViewer;

/**
 * Implements the "Open With -> Coverage" action (see the contextual
 * menu of the "Profiling monitor view")
 *  @author hind.hasnaoui@fr.ibm.com  --
 */
public class OpenCoverageViewAction extends OpenTraceViewAction {

	/**
	 * OpenReferencePatternView constructor comment.
	 * @param label java.lang.String
	 */
	public OpenCoverageViewAction() {
		super("");
	}
	/**
	 * OpenReferencePatternView constructor comment.
	 * @param label java.lang.String
	 */
	public OpenCoverageViewAction(String label) {
		super(label);
	}
	/**
	 * OpenReferencePatternView constructor comment.
	 * @param label java.lang.String
	 * @param image com.ibm.jface.parts.IImage
	 */
	public OpenCoverageViewAction(String label, ImageDescriptor image) {
		super(label, image);
	}

	/**
	 * 
	 */
	public boolean isVisibleForType(Object mofObject) {
		return true;
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run() {
		IWorkbenchWindow window =
			UIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();

		try {
			IWorkbenchPage persp = UIPlugin.getActivePage();
			CoverageViewer view =
				(CoverageViewer) persp.showView(
					"org.eclipse.hyades.trace.views.adapter.internal.CoverageViewer");

		} catch (Exception e) {
			String msg =
				TraceUIPlugin.getString("STR_OPEN_CLASS_STATISTIC_ERROR_");
			Status err =
				new Status(
					Status.WARNING,
					ResourcesPlugin.PI_RESOURCES,
					IResourceStatus.INTERNAL_ERROR,
					e.toString(),
					null);

			ErrorDialog.openError(window.getShell(), msg, "",
			// no special message
			err);

			e.printStackTrace();
		}

	}

	/*
	 * 
	 */
	public void run(IAction action) {
		run();
	}

}
