/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.internal;

import org.eclipse.hyades.models.trace.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.views.adapter.internal.InvocationTablePage;
import org.eclipse.hyades.trace.views.adapter.internal.TraceConstants;
import org.eclipse.hyades.trace.views.util.internal.*;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.*;

public class MethodInvocationStatistic extends StatisticView
                                implements ITimeChangedListener

{
	protected String tmpString;

	/**
	 * 
	 *
	 */
	public class ExecutionStatisticFilter extends StatisticFilter {

		public ExecutionStatisticFilter() {
			super();
		}

		public boolean select(Viewer viewer, Object parent, Object element) {
			
			boolean flag = true;
			
			if(!(element instanceof TRCMethodInvocation))
			  return true;
			  
			String compareText = "";
		   compareText = ((TRCMethodInvocation)element).getMethod().getName();
		   if(compareText.equals(""))
			 compareText = TraceUIPlugin.getString("DEFAULT_PACKAGE");
			
			if (_noPattern)
				return true;
			
			if (!_caseSensitive) {
				compareText = compareText.toLowerCase();
			}
			if (_exactMatch) {
				return compareText.compareTo(_prefix) == 0;
			}
			if (_prefix != "") {
				flag = compareText.startsWith(_prefix);
			}
			if (flag && _suffix != "") {
				flag = compareText.endsWith(_suffix);
			}
			if (flag) {
				for (int k = 0; k < _textList.size(); k++) {
					String str1 = (String) _textList.get(k);

					int index = compareText.lastIndexOf(str1);
					if (index == -1) {
						flag = false;
						break;
					}

					compareText = compareText.substring(index + str1.length());
				}
			}
			return flag;
		}
		
	}
	
	public class MethodStatisticSorter extends StatisticSorter {

		public MethodStatisticSorter() {
			super();
		}

		public int compare(Viewer viewer, Object e1, Object e2) {
			
			    double d = 0;
				switch(_pos)
				{
					case 0://method name
					   return (int) _sortSequence * (int) ((TRCMethodInvocation)e1).getMethod().getName().compareToIgnoreCase(((TRCMethodInvocation)e2).getMethod().getName());
					  			
					case 1: //instances
					{
						TRCClass tmpClass = PerftraceUtil.getClass((TRCMethodInvocation)e1);
						TRCObject tmpObject = ((TRCMethodInvocation)e1).getOwningObject();
						tmpString = tmpClass.getName() + "." + tmpObject.getId();
	
						tmpObject = ((TRCMethodInvocation)e2).getOwningObject();
						tmpClass = PerftraceUtil.getClass((TRCMethodInvocation)e2);
						
					   return (int) _sortSequence * (int) tmpString.compareToIgnoreCase( tmpClass.getName() + "." + tmpObject.getId());
					}
					  					  					  
					case 2: //base time
					
					  if(e1 instanceof TRCFullMethodInvocation && e2 instanceof TRCFullMethodInvocation)
					  {
						d = ((TRCFullMethodInvocation)e1).getEntryTime() - ((TRCFullMethodInvocation)e2).getEntryTime();					  	
					  }
					  
					  if(d < 0)
					     return  -1 * _sortSequence;
					  if(d > 0) 
					    return _sortSequence;
					    
					  return 0;    
					  
					case 3: //cumulative time
					
					    if(!(e1 instanceof TRCFullMethodInvocation) || !(e2 instanceof TRCFullMethodInvocation))
					      return 0;
					
						TRCFullMethodInvocation tmpInv = (TRCFullMethodInvocation)e1;
						double start = tmpInv.getEntryTime();
						double end = tmpInv.getExitTime();
						if(end == 0)
						{
							end = tmpInv.getOwningObject().getProcess().getLastEventTime();
						}
						d = end-start;
						
						tmpInv = (TRCFullMethodInvocation)e2;
						start = tmpInv.getEntryTime();
						end = tmpInv.getExitTime();
						if(end == 0)
						{
							end = tmpInv.getOwningObject().getProcess().getLastEventTime();
							
						}
						
						  d = d - (end -start);
						  
						  if(d < 0)
						     return  -1 * _sortSequence;
						  if(d > 0) 
						    return _sortSequence;
						    
						  return 0;    
					  
					case 10: //calls
					  //return (int) _sortSequence * (((TRCMethod)e1).getCalls() - ((TRCMethod)e2).getCalls());
					  
				}				  				  				 				   				  
				
			
			return 0;
		}
		
	}

    /**
     * 
     */
	public class MethodStatisticContentProvider implements ITreeContentProvider {
		
		public void dispose() {
		}
		
		public Object getParent(Object element) {
			return null;
		}
		
		public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
		}
		
		public Object[] getElements(Object inputElement)
		{
			tmpList.clear();
			ITraceSelection selModel = UIPlugin.getDefault().getSelectionModel(_page.getMOFObject());
			
			if(selModel.size() > 0)
			{
				Object obj = selModel.getFirstElement();
				
				if(obj instanceof TRCMethod)
				{
					return ((TRCMethod)obj).getInvocations().toArray();
				} 
				
				if(obj instanceof TRCMethodInvocation)
				{
					return ((TRCMethodInvocation)obj).getMethod().getInvocations().toArray();
				} 
				  
			}
			
			return tmpList.toArray();			
		}
				
		public Object[] getChildren(Object element)
		{
			tmpList.clear();			
			Object[] segments = ((TRCMethodInvocation)element).getInvokes().toArray();
			for(int idx=0; idx<segments.length; idx++)
			{
				tmpList.add(((TRCMethodInvocation)segments[idx]));
			}
			
			return tmpList.toArray(); 	
		}
	
		public boolean hasChildren(Object element) {
			return ((TRCMethodInvocation)element).getInvokes().size() > 0;
		}
	}

    /**
     * 
     */
	public class MethodStatisticLabelProvider extends LabelProvider implements ITableLabelProvider
	{
		protected StatisticView _viewer;
		
		public MethodStatisticLabelProvider(StatisticView viewer) {
			super();
			_viewer = viewer;
		}
		
		public Image getColumnImage(Object obj, int col) {
				return null;
		}

		public String getColumnText(Object obj, int col) {
			
            int pos = StatisticTableColumnInfo.getStatisticTableColumnInfo(_viewer.getTable().getColumn(col)).getColumnData().getInitalPos();			
			
            //TRCMethodInvocation
				switch(pos)
				{
					case 0://method name
					   return ((TRCMethodInvocation)obj).getMethod().getName();
					  
					case 1://instance name  
					{
						TRCClass tmpClass = PerftraceUtil.getClass((TRCMethodInvocation)obj);
						return tmpClass.getName() + "." + ((TRCMethodInvocation)obj).getOwningObject().getId();
					}
					
					case 2://base time
					{
						 if(obj instanceof TRCFullMethodInvocation)
						 	return PerftraceUtil.formatTimeValue(((TRCFullMethodInvocation)obj).getEntryTime());
						 
						 return "";	
					}
	
					case 3: //cumulative time 
					{
						if(obj instanceof TRCFullMethodInvocation)
						{						
							TRCFullMethodInvocation inv = (TRCFullMethodInvocation)obj;
							double start = inv.getEntryTime();
							double end = inv.getExitTime();
							if(end == 0)
							{
								end = inv.getOwningObject().getProcess().getLastEventTime();
							}
							return PerftraceUtil.formatTimeValue(end-start);
							
						}
					}
				}
				
            							
			return "";
		}
	}
	
	private int _drawMode = TraceUIPlugin.getDefault().getPreferenceStore().getInt(TraceConstants.TIME_OPTION);

	class ExecutionTreeViewer extends TableTreeViewer {
		public ExecutionTreeViewer(Composite parent) {
			super(parent);
		}

		public ExecutionTreeViewer(TableTree table) {
			super(table);
		}

		public void expandItem(TableTreeItem item) {
			item.setExpanded(true);
			createChildren(item);

		}

	}
	protected Composite createTable(Composite parent, int options) {
		return new TableTree(parent, options);
	}

	public MethodInvocationStatistic(Composite parent, TraceViewerPage page) {
		super(parent, page);
		_viewerFilter = new StatisticFilter();				
		
		TraceUIPlugin.getDefault().addTimeChangedEventListener(this);
		_viewerFilter = new ExecutionStatisticFilter();		

		
	}

	/**
	 * getClassColumnsPerferencesKey returns the string key used to find the
	 * column preferences information in the preferences store.
	 * @return java.lang.String key name
	 */
	public String getColumnsPreferencesKey() {
		// Note this string is not to be translated and must be changed whenever the 
		// default columns template is changed by adding, removing or renaming columns.
		// Changing the version will result in the default preferences being used.
		return "MInv51"; 
		
	}
	
	public String getDefaultColumnsTemplate() {
				
		//Class Columns Data
		String executionColumn =
			    TraceUIPlugin.getString("STR_INVOCATION_COL")			+ ":0:"
				+ String.valueOf(ColumnData.NONDELETABLE | ColumnData.IS_VISIBLE | ColumnData.NONMOVABLE) + ":left:200,"
			    + TraceUIPlugin.getString("STR_ST_INSTANCE_INDEX") + ":1:"
			  	+ String.valueOf(ColumnData.IS_VISIBLE) + ":left:200,"					 	
				+ TraceUIPlugin.getString("TITLE_START_TIME") + ":2:" 
				+ String.valueOf(ColumnData.IS_VISIBLE) + ":right:100,"
				+ TraceUIPlugin.getString("TITLE_TIME_ON_STACK")	+ ":3:"
				+ String.valueOf(ColumnData.IS_VISIBLE) + ":right:100";
				
		return executionColumn;
	}

	protected IContentProvider getContentProvider() {
		return new MethodStatisticContentProvider();
	}
	
	public LabelProvider getTableLabelProvider()
	{
		return new MethodStatisticLabelProvider(this);
	}
	

	public Table getTable() {
		return ((TableTree) getTableViewer().getControl()).getTable();
	}

	protected StructuredViewer createTableViewer(Composite table) {
		ExecutionTreeViewer tv = new ExecutionTreeViewer((TableTree) table);
		return (StructuredViewer) tv;
	}

	protected void handleSelectionEvent() {

		Control table = ((TableTree) getTableViewer().getControl()).getTable();	
		if(table != null && !table.isDisposed() && !table.isFocusControl())
		{
			update();			
		}		
		
	}

	/**
	 * Called when the context menu is about to open.
	 * @see IFillMenuTarget#fillContextMenu
	 */
	public void menuAboutToShow(IMenuManager menu) {
		menu.add(fSeparator);

		menu.add(getUpdateAction());
		
		menu.add(fSeparator);
		menu.add(getChooseColumnsAction(getColumnDataList(), getColumnsPreferencesKey()));
	}

	public void updateButtons() {
		
		((InvocationTablePage) getTraceViewerPage()).percentMode().setChecked(isShowPercent());		
	}

	protected void updateDetailsPane() {
		int selIndex = getTable().getSelectionIndex();
		if (selIndex < 0) {
			return;
		}

		Item item = getTable().getItem(selIndex);
		Object itemData = item.getData();

		if (itemData == null) {
			return;
		}
		if (itemData != null && itemData instanceof TableTreeItem) {
			itemData = ((TableTreeItem) itemData).getData();
		}
	}

	public void updateModelSelection() {
		ISelection selection = getTableViewer().getSelection();
		if(selection != null && !selection.isEmpty())
		{
			Object sel = ((IStructuredSelection)selection).getFirstElement();
			
			UIPlugin.getDefault().getSelectionModel(
				_page.getMOFObject()).add(
				sel);
	
			ViewSelectionChangedEvent event = UIPlugin.getDefault().getViewSelectionChangedEvent();
			event.setSource(_page.getMOFObject());
			UIPlugin.getDefault().notifyViewSelectionChangedListener(event);			
		}
	}
	
	public void dispose() {
		
		super.dispose();
	    TraceUIPlugin.getDefault().removeTimeChangedEventListener(this);
		
	}

  public void handleTimeChangedEvent()
  {		
  	    Action base = ((InvocationTablePage)getTraceViewerPage()).baseTime();
  	    Action raw = ((InvocationTablePage)getTraceViewerPage()).rawTime();
	    _drawMode = TraceUIPlugin.getDefault().getPreferenceStore().getInt(TraceConstants.TIME_OPTION);
	    if(base != null)
	      base.setChecked(_drawMode == TraceConstants.COMPENSATED_TIME);
	    if(raw != null)
	      raw.setChecked(_drawMode == TraceConstants.RAW_TIME);
	
	    String oldName = TraceUIPlugin.getString("TITLE_RAW_TIME_ON_STACK");
		String newName = TraceUIPlugin.getString("TITLE_TIME_ON_STACK");
		if(_drawMode == TraceConstants.RAW_TIME)
		{
		   newName = TraceUIPlugin.getString("TITLE_RAW_TIME_ON_STACK");
		   oldName = TraceUIPlugin.getString("TITLE_TIME_ON_STACK");		   
		}
	
		Table table = getTable();	
		for (int idx = table.getColumnCount(); idx > 0; idx--)
		{
			TableColumn col = table.getColumn(table.getColumnCount() - 1);
			StatisticTableColumnInfo staticTblColInfo = (StatisticTableColumnInfo)(col.getData());
			String columnName = staticTblColInfo.getColumnData().name();	
			if(columnName.equals(oldName) )
			{
			   staticTblColInfo.getColumnData().name(newName);
			   if(staticTblColInfo.isSortColumn())
			   {
			   	   newName = col.getText().substring(0, 1) + newName; 
			   }			   	
 			   col.setText(newName);
			}
		}
	
		getTableViewer().refresh();
  }

	public void update() {
		if (_firstTime) {
			getTableViewer().addFilter(getViewerFilter());
			_firstTime = false;
			Table table = getTable();
			TableColumn firstColumn = table.getColumn(0);
			
			_viewerSorter = new MethodStatisticSorter();

			getViewerSorter().setSortedColumn(firstColumn);
			getTableViewer().setSorter(getViewerSorter());
			
		}
		// set the input of the viewer
		
		getTableViewer().setInput(_page.getMOFObject());

        getTable().setRedraw(false);
		getTableViewer().refresh();
        getTable().setRedraw(true);
		
	}

	public void handleViewSelectionChangedEvent(ViewSelectionChangedEvent event)
	{
		if(!getTraceViewerPage().getTraceViewer().isProcessRefreshEvents()		
		|| getTable().isFocusControl())
		  return;
		  
		handleSelectionEvent();  
	}
	
}