/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.util.internal;
import org.eclipse.hyades.models.trace.*;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.trace.ui.HyadesConstants;
import java.util.ArrayList;

import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.internal.ui.*;
import org.eclipse.hyades.trace.ui.internal.core.*;
import org.eclipse.hyades.trace.ui.internal.util.*;

/**
 * 
 * @author hind.hasnaoui@fr.ibm.com /
 *
 * This class compute the method coverage 
 * 
 */
public class CoverageAnalysis {

	private Coverage _coverage = null;

	public CoverageAnalysis(EObject object) {
		//Search for TRCProcess
		TRCProcess proc = searchTrcProcess(object);

		if (proc != null) {
			//Filter the list of packages
			EList listPack = proc.getPackages();
			EList filteredListPack = filterPackages(listPack);

			//Compute method coverage
			if (filteredListPack != null)
				setCoverage(compute(filteredListPack, proc));
		}

	}

	/**
	 * This method search for the reference of the TRCProcess 
	 * selected in the profiling monitor view
	 */
	protected TRCProcess searchTrcProcess(EObject object) {
		TRCAgent agent = null;

		if (object instanceof TRCAgentProxy
			&& ((TRCAgentProxy) object).getType().equals(
				HyadesConstants.PROFILE_AGENT_TYPE)) {
			agent = ((TRCAgentProxy) object).getAgent();
		} else if (object instanceof TRCProcessProxy) {
			EList agents = ((TRCProcessProxy) object).getAgentProxies();
			for (int idx = 0; idx < agents.size(); idx++) {
				TRCAgentProxy agentProxy = (TRCAgentProxy) agents.get(idx);
				if (agentProxy == null || agentProxy.eIsProxy())
					continue;
				if (agentProxy
					.getType()
					.equals(HyadesConstants.PROFILE_AGENT_TYPE)) {
					agent = agentProxy.getAgent();
					break;
				}
			}
		}
		if (agent != null) {
			AbstractTRCProcess process = agent.getProcess();
			if (process instanceof TRCProcess)
				return (TRCProcess) process;
			else
				return null;
		} else // No agent
			return null;
	}

	/**
	 * This method filter the packages list 
	 * based on the active filter 
	 * the empty packages are also removed
	 */
	protected EList filterPackages(EList list) {
		if (list == null)
			return null;

		ArrayList listFilter = filters();

		for (int j = 0; j < list.size(); ++j) {
			TRCPackage pac = (TRCPackage) list.get(j);

			if (remove(pac, listFilter)) {
				list.remove(pac);
				j--;
			}
		}

		return list;

	}

	/**
	 * This method compute the method coverage
	 * @param listPack: filtered packages list
	 * @return the coverage object
	 */
	protected Coverage compute(EList listPack, TRCProcess proc) {
		Coverage cov = new Coverage(proc);
		cov.cover(listPack);
		return cov;
	}

	/**
	 * @return the coverage element
	 */
	public Coverage getCoverage() {
		return _coverage;
	}

	/**
	 * @param coverage element
	 */
	protected void setCoverage(Coverage coverage) {
		_coverage = coverage;
	}

	/**
	 * Compute the class level tree
	 * @return
	 */
	public Coverage getClassLevel() {
		// Root
		Coverage classLevel = duplicate(_coverage);

		ArrayList classList = new ArrayList();
		classList.clear();

		ArrayList packList = _coverage.getCoverageList();

		for (int i = 0; i < packList.size(); i++) {
			Coverage covPack = (Coverage) packList.get(i);
			ArrayList list = covPack.getCoverageList();
			for (int j = 0; j < list.size(); j++) {
				classList.add(list.get(j));
			}

		}

		classLevel.setCoverageList(classList);

		return classLevel;
	}

	/**
	 * Compute the method level tree
	 * @return
	 */
	public Coverage getMethodLevel() {
		int i, j;
		ArrayList list = new ArrayList();
		;
		ArrayList classList = new ArrayList();
		ArrayList methodList = new ArrayList();
		ArrayList methodListF = new ArrayList();

		//	Root
		Coverage methodLevel = duplicate(_coverage);

		ArrayList packList = _coverage.getCoverageList();

		for (i = 0; i < packList.size(); i++) {
			Coverage covPack = (Coverage) packList.get(i);
			list = covPack.getCoverageList();
			for (j = 0; j < list.size(); j++) {
				classList.add(list.get(j));
			}

		}

		for (i = 0; i < classList.size(); i++) {
			Coverage covClass = (Coverage) classList.get(i);
			list = covClass.getCoverageList();
			for (j = 0; j < list.size(); j++) {
				methodList.add(list.get(j));
			}

		}

		// filter sub classes
		for (i = 0; i < methodList.size(); i++) {
			Coverage covElement = (Coverage) methodList.get(i);
			// if sub class
			if ((covElement.getTraceObj()) instanceof TRCClass) {
				list = covElement.getCoverageList();
				for (j = 0; j < list.size(); j++) {
					methodListF.add(list.get(j));
				}

			} else
				methodListF.add(covElement);
		}

		methodLevel.setCoverageList(methodListF);

		return methodLevel;
	}

	/**
	 * Duplicate the coverage root object
	 * @param covArg
	 * @return
	 */
	protected Coverage duplicate(Coverage covArg) {
		Coverage cov = new Coverage(null);
		cov.setCalls(covArg.getCalls());
		cov.setMethods(covArg.getMethods());
		cov.setMethodsHit(covArg.getMethodsHit());
		cov.setCovPercentage(covArg.getCovPercentage());
		cov.setTraceObj(covArg.getTraceObj());

		return cov;

	}

	/**
	 * @return the list of the active filter
	 */
	protected ArrayList filters() {
		ArrayList listFilters = new ArrayList();

		String filters =
			UIPlugin.getDefault().getPreferenceStore().getString(
				TraceConstants.FILTERS_SET_KEY);

		if (filters != null) {
			ArrayList listFilterSetElement =
				TraceProfileUI.getFiltersSet(filters);
			FilterSetElement filterElemt = null;
			boolean active = false;

			// retrieve the active filter
			for (int i = 0; i < listFilterSetElement.size(); i++) {
				filterElemt = (FilterSetElement) listFilterSetElement.get(i);

				if (filterElemt.getEnabled()) {
					active = true;
					break;
				}
			}
			if ((filterElemt != null) && (active)) {
				ArrayList children = filterElemt.getChildren();

				if (children.size() != 0) {
					for (int j = 0; j < children.size(); j++) {
						FilterTableElement filterTableEl =
							(FilterTableElement) children.get(j);
						if (filterTableEl
							.getVisibility()
							.equals(
								UIPlugin.getResourceString("STR_EXCLUDE"))) {
							String text = filterTableEl.getText();
							if (text.indexOf("*") != -1)
								text = text.substring(0, text.indexOf("*"));

							listFilters.add(text);
						}
					}

				}
			}

		}
		return listFilters;
	}

	/**
	 * The empty packages are removed and
	 * those listed in the active filter
	 * @param pac
	 * @return
	 */
	protected boolean remove(TRCPackage pac, ArrayList list) {
		if (pac.getClasses().size() == 0) //if empty package
			return true;

		else if (list.size() != 0) {
			String pacName = pac.getName();

			for (int k = 0; k < list.size(); ++k) {
				if (pacName.startsWith((String) list.get(k)))
					return true;
			}
			return false;
		}

		return false;
	}

}