/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.views.util.internal;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.hyades.internal.execution.local.common.Options;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.models.trace.*;
import org.eclipse.hyades.trace.ui.HyadesConstants;
import org.eclipse.hyades.trace.views.internal.TraceUIPlugin;

import java.text.NumberFormat;

import java.util.ArrayList;
import java.util.Iterator;


public class PerftraceUtil {
    //~ Static fields/initializers -----------------------------------------------------------------

    private static NumberFormat _decimalFormat = null;
    private static NumberFormat _percentFormat = null;
    private static ArrayList tmpList = new ArrayList();

    //~ Methods ------------------------------------------------------------------------------------

    /**
     *
     */
    public static int getActiveInstances(EObject mofObject) {
        int inst = 0;

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                if (((TRCAgentProxy) mofObject).getAgent() != null) {
                    TRCProcess proces = (TRCProcess) ((TRCAgentProxy) mofObject).getAgent().getProcess();

                    if (proces != null) {
                        inst = (proces.getTotalInstances() - proces.getCollectedInstances());
                    }
                }
            } else if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    if (((TRCAgentProxy) agents[idx]).getAgent() != null) {
                        TRCProcess proces = (TRCProcess) ((TRCAgentProxy) agents[idx]).getAgent().getProcess();

                        if (proces != null) {
                            inst += (proces.getTotalInstances() - proces.getCollectedInstances());
                        }
                    }
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                            TRCProcess proces = (TRCProcess) ((TRCAgentProxy) agents[i]).getAgent().getProcess();

                            if (proces != null) {
                                inst += (proces.getTotalInstances() - proces.getCollectedInstances());
                            }
                        }
                    }
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                                TRCProcess proces = (TRCProcess) ((TRCAgentProxy) agents[i]).getAgent().getProcess();

                                if (proces != null) {
                                    inst += (proces.getTotalInstances() - proces.getCollectedInstances());
                                }
                            }
                        }
                    }
                }
            }
        }

        if (inst == 0) {
            inst = 1;
        }

        return inst;
    }

    /**
     *
     */
    public static long getActiveSize(EObject mofObject) {
        long size = 0;

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                if (((TRCAgentProxy) mofObject).getAgent() != null) {
                    TRCProcess proces = (TRCProcess) ((TRCAgentProxy) mofObject).getAgent().getProcess();

                    if (proces != null) {
                        size = proces.getTotalSize() - proces.getCollectedSize();
                    }
                }
            } else if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    if (((TRCAgentProxy) agents[idx]).getAgent() != null) {
                        TRCProcess proces = (TRCProcess) ((TRCAgentProxy) agents[idx]).getAgent().getProcess();

                        if (proces != null) {
                            size += (proces.getTotalSize() - proces.getCollectedSize());
                        }
                    }
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                            TRCProcess proces = (TRCProcess) ((TRCAgentProxy) agents[i]).getAgent().getProcess();

                            if (proces != null) {
                                size += (proces.getTotalSize() - proces.getCollectedSize());
                            }
                        }
                    }
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                                TRCProcess proces = (TRCProcess) ((TRCAgentProxy) agents[i]).getAgent().getProcess();

                                if (proces != null) {
                                    size += (proces.getTotalSize() - proces.getCollectedSize());
                                }
                            }
                        }
                    }
                }
            }
        }

        if (size == 0) {
            size = 1;
        }

        return size;
    }

    /**
     *
     */
    public static Object[] getAllClasses(EObject mofObject) {
        tmpList.clear();

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                getAgentClasses((TRCAgentProxy) mofObject, tmpList);

                return getObjectArray();
            }

            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    getAgentClasses((TRCAgentProxy) agents[idx], tmpList);
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        getAgentClasses((TRCAgentProxy) agents[i], tmpList);
                    }
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            getAgentClasses((TRCAgentProxy) agents[i], tmpList);
                        }
                    }
                }

                return getObjectArray();
            }
        }

        return getObjectArray();
    }

    /**
     *
     */
    public static Object[] getAllGc(EObject mofObject) {
        tmpList.clear();

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                getAgentGc((TRCAgentProxy) mofObject, tmpList);

                return getObjectArray();
            }

            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    getAgentGc((TRCAgentProxy) agents[idx], tmpList);
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        getAgentGc((TRCAgentProxy) agents[i], tmpList);
                    }
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            getAgentGc((TRCAgentProxy) agents[i], tmpList);
                        }
                    }
                }

                return getObjectArray();
            }
        }

        return getObjectArray();
    }

    public static Object[] getAllHeapDump(EObject mofObject) {
        tmpList.clear();

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                getAgentHeapDump((TRCAgentProxy) mofObject, tmpList);

                return getObjectArray();
            }

            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    getAgentHeapDump((TRCAgentProxy) agents[idx], tmpList);
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        getAgentHeapDump((TRCAgentProxy) agents[i], tmpList);
                    }
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            getAgentHeapDump((TRCAgentProxy) agents[i], tmpList);
                        }
                    }
                }

                return getObjectArray();
            }
        }

        return getObjectArray();
    }

    /**
     *
     */
    public static Object[] getAllPackages(EObject mofObject) {
        tmpList.clear();

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                getAgentPackages((TRCAgentProxy) mofObject, tmpList);

                return getObjectArray();
            }

            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    getAgentPackages((TRCAgentProxy) agents[idx], tmpList);
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        getAgentPackages((TRCAgentProxy) agents[i], tmpList);
                    }
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            getAgentPackages((TRCAgentProxy) agents[i], tmpList);
                        }
                    }
                }

                return getObjectArray();
            }
        }

        return getObjectArray();
    }

    /**
     *
     */
    public static Object[] getAllReferences(EObject mofObject) {
        tmpList.clear();

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                getAgentObjReferences((TRCAgentProxy) mofObject, tmpList);

                return getObjectArray();
            }

            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    getAgentObjReferences((TRCAgentProxy) agents[idx], tmpList);
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        getAgentObjReferences((TRCAgentProxy) agents[i], tmpList);
                    }
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            getAgentObjReferences((TRCAgentProxy) agents[i], tmpList);
                        }
                    }
                }

                return getObjectArray();
            }
        }

        return getObjectArray();
    }

    public static Object[] getAllThreads(EObject mofObject) {
        tmpList.clear();

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                getAgentThreads((TRCAgentProxy) mofObject, tmpList);

                return getObjectArray();
            }

            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    getAgentThreads((TRCAgentProxy) agents[idx], tmpList);
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        getAgentThreads((TRCAgentProxy) agents[i], tmpList);
                    }
                }

                return getObjectArray();
            }

            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            getAgentThreads((TRCAgentProxy) agents[i], tmpList);
                        }
                    }
                }

                return getObjectArray();
            }
        }

        return getObjectArray();
    }

    public static TRCClass getClass(TRCMethodInvocation invocation) {
        TRCObject o = invocation.getOwningObject();

        if (o.getIsA() != invocation.getProcess().getClassClass()) {
            return o.getIsA();
        } else {
            return invocation.getMethod().getDefiningClass();
        }
    }

    /**
     *
     * @param object
     * @return the class for the object
     */
    public static TRCClass getClass(TRCObject object) {
        TRCClass clas = object.getIsA();

        if (clas == object.getProcess().getClassClass()) { //is a class object, try to get the class name associated with it

            TRCPackage[] packages = (TRCPackage[]) object.getProcess().getPackages().toArray();

            for (int i = 0; i < packages.length; i++) {
                TRCClass[] classes = (TRCClass[]) packages[i].getClasses().toArray();

                for (int j = 0; j < classes.length; j++) {
                    Object[] objects = classes[j].getClassObjects().toArray();

                    for (int k = 0; k < objects.length; k++) {
                        if (objects[k] == object) {
                            return classes[j];
                        }
                    }
                }
            }
        }

        return clas;
    }

    /**
     *
     */
    public static double getMaximumTime(EObject mofObject) {
        double time = 0;

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                if (((TRCAgentProxy) mofObject).getAgent() != null) {
                    TRCProcess proces = (TRCProcess) ((TRCAgentProxy) mofObject).getAgent().getProcess();

                    if (proces != null) {
                        time = proces.getLastEventTime();
                    }
                }
            } else if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    if (((TRCAgentProxy) agents[idx]).getAgent() != null) {
                        TRCProcess proces = (TRCProcess) ((TRCAgentProxy) agents[idx]).getAgent().getProcess();

                        if (proces != null) {
                            double tmp = proces.getLastEventTime();

                            if (tmp > time) {
                                time = tmp;
                            }
                        }
                    }
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                            TRCProcess proces = (TRCProcess) ((TRCAgentProxy) agents[i]).getAgent().getProcess();

                            if (proces != null) {
                                double tmp = proces.getLastEventTime();

                                if (tmp > time) {
                                    time = tmp;
                                }
                            }
                        }
                    }
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                                TRCProcess proces = (TRCProcess) ((TRCAgentProxy) agents[i]).getAgent().getProcess();

                                if (proces != null) {
                                    double tmp = proces.getLastEventTime();

                                    if (tmp > time) {
                                        time = tmp;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        if (time == 0) {
            time = 1;
        }

        return time;
    }

    /**
     *
     */
    public static String getPackageName(TRCPackage pack, Object mofObject) {
        StringBuffer buff = new StringBuffer(pack.getName());

        if (buff.length() == 0) {
            buff.append(TraceUIPlugin.getString("DEFAULT_PACKAGE"));
        }

        if (mofObject instanceof TRCAgentProxy || mofObject instanceof TRCProcessProxy) {
            return buff.toString();
        }

        return buff.append(" [").append(pack.getProcess().getPid()).append("]").toString();
    }

    public static TRCProcess getProcess(TRCAgent agent) {
        if (agent.getProcess() instanceof TRCProcess) {
            return (TRCProcess) agent.getProcess();
        }

        return null;
    }

    /**
     *
     */
    public static String getThreadName(TRCThread thread) {
        StringBuffer tmpBuffer = new StringBuffer(thread.getName());

        return tmpBuffer.append("[").append(thread.getProcess().getPid()).append("]").toString();
    }

    /**
     *
     */
    public static long getTime(double etime) {
        return (long) (etime * 1000000);
    }

    /**
     *
     */
    public static int getTotalCalls(EObject mofObject) {
        int calls = 0;

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                if (((TRCAgentProxy) mofObject).getAgent() != null) {
                    TRCProcess proces = (TRCProcess) ((TRCAgentProxy) mofObject).getAgent().getProcess();

                    if (proces != null) {
                        calls = proces.getCalls();
                    }
                }
            } else if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    if (((TRCAgentProxy) agents[idx]).getAgent() != null) {
                        TRCProcess proces = (TRCProcess) ((TRCAgentProxy) agents[idx]).getAgent().getProcess();

                        if (proces != null) {
                            calls += proces.getCalls();
                        }
                    }
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                            TRCProcess proces = (TRCProcess) ((TRCAgentProxy) agents[i]).getAgent().getProcess();

                            if (proces != null) {
                                calls += proces.getCalls();
                            }
                        }
                    }
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                                TRCProcess proces = (TRCProcess) ((TRCAgentProxy) agents[i]).getAgent().getProcess();

                                if (proces != null) {
                                    calls += proces.getCalls();
                                }
                            }
                        }
                    }
                }
            }
        }

        if (calls == 0) {
            calls = 1;
        }

        return calls;
    }

    /**
     *
     */
    public static int getTotalInstances(EObject mofObject) {
        int inst = 0;

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                if (((TRCAgentProxy) mofObject).getAgent() != null) {
                    TRCProcess proces = (TRCProcess) ((TRCAgentProxy) mofObject).getAgent().getProcess();

                    if (proces != null) {
                        inst = proces.getTotalInstances();
                    }
                }
            } else if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    if (((TRCAgentProxy) agents[idx]).getAgent() != null) {
                        TRCProcess proces = (TRCProcess) ((TRCAgentProxy) agents[idx]).getAgent().getProcess();

                        if (proces != null) {
                            inst += proces.getTotalInstances();
                        }
                    }
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                            TRCProcess proces = (TRCProcess) ((TRCAgentProxy) agents[i]).getAgent().getProcess();

                            if (proces != null) {
                                inst += proces.getTotalInstances();
                            }
                        }
                    }
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                                TRCProcess proces = (TRCProcess) ((TRCAgentProxy) agents[i]).getAgent().getProcess();

                                if (proces != null) {
                                    inst += proces.getTotalInstances();
                                }
                            }
                        }
                    }
                }
            }
        }

        if (inst == 0) {
            inst = 1;
        }

        return inst;
    }

    /**
     *
     */
    public static long getTotalSize(EObject mofObject) {
        long size = 0;

        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                if (((TRCAgentProxy) mofObject).getAgent() != null) {
                    TRCProcess proces = (TRCProcess) ((TRCAgentProxy) mofObject).getAgent().getProcess();

                    if (proces != null) {
                        size = proces.getTotalSize();
                    }
                }
            } else if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    if (((TRCAgentProxy) agents[idx]).getAgent() != null) {
                        TRCProcess proces = (TRCProcess) ((TRCAgentProxy) agents[idx]).getAgent().getProcess();

                        if (proces != null) {
                            size += proces.getTotalSize();
                        }
                    }
                }
            } else if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                            TRCProcess proces = (TRCProcess) ((TRCAgentProxy) agents[i]).getAgent().getProcess();

                            if (proces != null) {
                                size += proces.getTotalSize();
                            }
                        }
                    }
                }
            } else if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            if (((TRCAgentProxy) agents[i]).getAgent() != null) {
                                TRCProcess proces = (TRCProcess) ((TRCAgentProxy) agents[i]).getAgent().getProcess();

                                if (proces != null) {
                                    size += proces.getTotalSize();
                                }
                            }
                        }
                    }
                }
            }
        }

        if (size == 0) {
            size = 1;
        }

        return size;
    }

    public static boolean collectInstanceInformation(TRCAgentProxy agent) {
        if (agent.getName().equals(HyadesConstants.J2EE_AGENT_NAME)) {
            return true;
        }

        TRCCollectionMode type = agent.getCollectionMode();

        if ((type == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL) || (type == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL) || (type == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL)) {
            return false;
        }

        Iterator configs = agent.getConfigurations().iterator();

        if (configs.hasNext()) {
            TRCConfiguration config = (TRCConfiguration) configs.next();
            EList options = config.getOptions();

            if (options != null) {
                Iterator i = options.iterator();

                while (i.hasNext()) {
                    TRCOption option = (TRCOption) i.next();

                    if (option.getKey().equals(Options.OPTION_TRACE_MODE)) {
                        if (option.getValue().equals(Options.OPTION_VALUE_NOOBJECTCORRELATION)) {
                            return false;
                        }
                    }
                }
            }
        }

        return true;
    }

    /**
     *
     */
    public static boolean collectStatisticInfo(EObject mofObject) {
        if (mofObject != null) {
            if (mofObject instanceof TRCAgentProxy) {
                TRCAgentProxy agent = (TRCAgentProxy) mofObject;

                return (agent.getCollectionMode() == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL) || (agent.getCollectionMode() == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL) || (agent.getCollectionMode() == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL);
            }

            if (mofObject instanceof TRCProcessProxy) {
                Object[] agents = ((TRCProcessProxy) mofObject).getAgentProxies().toArray();

                for (int idx = 0; idx < agents.length; idx++) {
                    boolean collectStatistic = (((TRCAgentProxy) agents[idx]).getCollectionMode() == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL) || (((TRCAgentProxy) agents[idx]).getCollectionMode() == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL) || (((TRCAgentProxy) agents[idx]).getCollectionMode() == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL);

                    if (!collectStatistic) {
                        return false;
                    }
                }
            }

            if (mofObject instanceof TRCNode) {
                Object[] processes = ((TRCNode) mofObject).getProcessProxies().toArray();

                for (int idx = 0; idx < processes.length; idx++) {
                    Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                    for (int i = 0; i < agents.length; i++) {
                        boolean collectStatistic = (((TRCAgentProxy) agents[i]).getCollectionMode() == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL) || (((TRCAgentProxy) agents[i]).getCollectionMode() == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL) || (((TRCAgentProxy) agents[i]).getCollectionMode() == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL);

                        if (!collectStatistic) {
                            return false;
                        }
                    }
                }
            }

            if (mofObject instanceof TRCMonitor) {
                Object[] nodes = ((TRCMonitor) mofObject).getNodes().toArray();

                for (int k = 0; k < nodes.length; k++) {
                    Object[] processes = ((TRCNode) nodes[k]).getProcessProxies().toArray();

                    for (int idx = 0; idx < processes.length; idx++) {
                        Object[] agents = ((TRCProcessProxy) processes[idx]).getAgentProxies().toArray();

                        for (int i = 0; i < agents.length; i++) {
                            boolean collectStatistic = (((TRCAgentProxy) agents[i]).getCollectionMode() == TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL) || (((TRCAgentProxy) agents[i]).getCollectionMode() == TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL) || (((TRCAgentProxy) agents[i]).getCollectionMode() == TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL);

                            if (!collectStatistic) {
                                return false;
                            }
                        }
                    }
                }
            }
        }

        return true;
    }

    public static String formatAsPercentage(double d) {
        if (_percentFormat == null) {
            _percentFormat = NumberFormat.getPercentInstance();
            _percentFormat.setMaximumIntegerDigits(3);
            _percentFormat.setMaximumFractionDigits(2);
            _percentFormat.setMinimumFractionDigits(2);
        }

        return _percentFormat.format(d);
    }

    public static String formatTimeValue(double d) {
        if (_decimalFormat == null) {
            _decimalFormat = NumberFormat.getNumberInstance();
            _decimalFormat.setMaximumFractionDigits(6);
            _decimalFormat.setMinimumFractionDigits(6);
        }

        return _decimalFormat.format(d);
    }

    private static void getAgentClasses(TRCAgentProxy agent, ArrayList list) {
        if (!agent.getType().equals(HyadesConstants.PROFILE_AGENT_TYPE) || (agent.getAgent() == null) || (getProcess(agent.getAgent()) == null)) {
            return;
        }

        Object[] packages = getProcess(agent.getAgent()).getPackages().toArray();

        for (int idx = 0; idx < packages.length; idx++) {
            list.addAll(((TRCPackage) packages[idx]).getClasses());
        }
    }

    private static void getAgentGc(TRCAgentProxy agent, ArrayList list) {
        if (!agent.getType().equals(HyadesConstants.PROFILE_AGENT_TYPE) || (agent.getAgent() == null) || (getProcess(agent.getAgent()) == null)) {
            return;
        }

        //list.addAll(getProcess(agent).getGarbageCollector());  
    }

    private static void getAgentHeapDump(TRCAgentProxy agent, ArrayList list) {
        if (!agent.getType().equals(HyadesConstants.PROFILE_AGENT_TYPE) || (agent.getAgent().getProcess() == null)) {
            return;
        }

        list.addAll(((TRCProcess) agent.getAgent().getProcess()).getHeapDumps());
    }

    private static void getAgentObjReferences(TRCAgentProxy agent, ArrayList list) {
        if (!agent.getType().equals(HyadesConstants.PROFILE_AGENT_TYPE) || (agent.getAgent() == null) || (getProcess(agent.getAgent()) == null)) {
            return;
        }

        /*
           Object[] heapdump = agent.getProcess().getHeapDump().toArray();
           if(heapdump.length > 0)
           {
                   TRCHeapDumpEvent heapEvent = (TRCHeapDumpEvent)heapdump[heapdump.length-1];
                   list.addAll(heapEvent.getReference());
           }
         */
    }

    private static void getAgentPackages(TRCAgentProxy agent, ArrayList list) {
        if (!agent.getType().equals(HyadesConstants.PROFILE_AGENT_TYPE) || (agent.getAgent() == null) || (getProcess(agent.getAgent()) == null)) {
            return;
        }

        list.addAll(getProcess(agent.getAgent()).getPackages());
    }

    private static void getAgentThreads(TRCAgentProxy agent, ArrayList list) {
        if (!agent.getType().equals(HyadesConstants.PROFILE_AGENT_TYPE) || (agent.getAgent().getProcess() == null)) {
            return;
        }

        Object[] threads = ((TRCProcess) agent.getAgent().getProcess()).getThreads().toArray();

        for (int idx = 0; idx < threads.length; idx++) {
            TRCThread thread = (TRCThread) threads[idx];

            if (thread.getInitialInvocations().size() > 0) {
                if (thread.getName() == null) {
                    thread.setName(String.valueOf(idx + 1));
                }

                list.add(thread);
            }
        }
    }

    /**
     * @return
     */
    private static Object[] getObjectArray() {
        Object[] ret = tmpList.toArray();

        tmpList.clear();

        return ret;
    }
}
