/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.common.internal.editor.action;

import java.util.List;

import org.eclipse.hyades.models.common.facades.behavioral.ILoop;
import org.eclipse.hyades.models.common.facades.behavioral.impl.HyadesFactory;
import org.eclipse.hyades.test.common.TestCommonImages;
import org.eclipse.hyades.test.common.internal.util.IITestSuiteProvider;
import org.eclipse.hyades.test.common.internal.util.TestCommonUtil;

/**
 * Adds a test case to the test suite and a test invocation to the block.
 * @author marcelop
 * @since 0.3.0
 */
public class AddLoop 
extends AddBlockChildAction
{
	/**
	 * Constructor for AddTestMethod
	 */
	public AddLoop(IITestSuiteProvider testSuiteProvider, String text, String baseName)
	{
		super(testSuiteProvider, text, baseName);
		setImageDescriptor(TestCommonImages.INSTANCE.getImageDescriptor(TestCommonImages.IMG_LOOP));
	}
	
	/**
	 * @see org.eclipse.jface.action.IAction#run()
	 */
	public void run()
	{
		ILoop loop = HyadesFactory.INSTANCE.createLoop();
		List actions = getBlock().getActions();
		loop.setName(TestCommonUtil.getUniqueName(getBaseName(), actions, ILoop.class));
		loop.getCondition().setConstraint("1");
		actions.add(loop);
	}
}
