/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.java.internal.junit.editor;

import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

import org.eclipse.hyades.test.common.TestCommon;
import org.eclipse.hyades.test.common.internal.editor.TestCasesForm;
import org.eclipse.hyades.test.common.internal.editor.action.AddTestCase;
import org.eclipse.hyades.test.java.TestJavaPlugin;
import org.eclipse.hyades.test.java.internal.util.ContextIds;
import org.eclipse.hyades.test.ui.internal.editor.form.util.WidgetFactory;

/**
 * @author marcelop
 * @since 0.2.0
 */
public class JUnitTestCasesForm
extends TestCasesForm
{
	/**
	 * Constructor for JUnitTestCasesForm
	 * @param junitEditorExtension
	 * @param widgetFactory
	 */
	public JUnitTestCasesForm(JUnitEditorExtension junitEditorExtension, WidgetFactory widgetFactory)
	{
		super(junitEditorExtension, widgetFactory);
		setHeadingText(TestJavaPlugin.getString("EDT_JUNIT_TTL"));
	}
	
	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.editor.TestCasesForm#getAddTestCaseAction()
	 */
	protected IAction getAddTestCaseAction()
	{
		return new AddTestCase(this, TestCommon.JUNIT_TEST_CASE_TYPE, TestJavaPlugin.getString("W_TEST").toLowerCase());
	}

	/**
	 * @see org.eclipse.hyades.test.java.internal.junit.editor.TestCasesForm#getTestCasesSectionHeaderText()
	 */
	protected String getTestCasesSectionHeaderText()
	{
		return TestJavaPlugin.getString("W_TST_METHS");
	}

	/**
	 * @see org.eclipse.hyades.test.common.internal.editor.TestCasesForm#registerHelp(int, java.lang.Object)
	 */
	protected void registerHelp(int flag, Object object)
	{
		switch(flag)
		{
			case HELP_NAMED_ELEMENT_CONTROL:
				WorkbenchHelp.setHelp((Control)object, TestJavaPlugin.getID() + ContextIds.TEST_METH_SECTION_NAME);
				break;
				
			case HELP_TEST_CASES_SECTION_CONTROL:
				WorkbenchHelp.setHelp((Control)object, TestJavaPlugin.getID() + ContextIds.TEST_METH_SECTION);
				break;
				
			case HELP_TEST_CASES_SECTION_TREE_CONTROL:
				WorkbenchHelp.setHelp((Control)object, TestJavaPlugin.getID() + ContextIds.TEST_METH_SECTION_TREE);
				break;
		}
	}
}
