/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.java.internal.junit.wizard;

import org.eclipse.jface.dialogs.IDialogSettings;

import org.eclipse.hyades.test.common.TestCommon;
import org.eclipse.hyades.test.common.internal.wizard.TestSuiteNewWizard;
import org.eclipse.hyades.test.java.TestJavaImages;
import org.eclipse.hyades.test.java.TestJavaPlugin;

/**
 * Extends the HyadesNewWizard to create the JUnit Test Suite.
 * 
 * @author marcelop
 * @since 0.0.1
 */
public class JUnitTestSuiteNewWizard 
extends TestSuiteNewWizard
{
	/**
	 * Constructor for TestSuiteNewWizard
	 */
	public JUnitTestSuiteNewWizard()
	{
		super();
		setWindowTitle(TestJavaPlugin.getString("WIZ_JUNIT_TST_SUITE_TTL"));
		setDefaultPageImageDescriptor(TestJavaImages.INSTANCE.getImageDescriptor(TestJavaImages.IMG_WIZBAN_NEW_JUNIT_TESTSUITE));

		IDialogSettings dialogSettings = TestJavaPlugin.getInstance().getDialogSettings();
		IDialogSettings settings = dialogSettings.getSection("JUnitTestSuiteNewWizard");
		if(settings == null)
			settings = dialogSettings.addNewSection("JUnitTestSuiteNewWizard");
		setDialogSettings(settings);
	}

	/**
	 * Returns the type for the test suite created by this wizard.
	 * @return String
	 */
	protected String getType()
	{
		return TestCommon.JUNIT_TEST_SUITE_TYPE;
	}
	
	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		getLocationPage().setTitle(TestJavaPlugin.getString("WIZ_NEW_JUNIT_TST_SUITE_PG_TTL"));
		getLocationPage().setDescription(TestJavaPlugin.getString("WIZ_TST_SUITE_GEN_PG_LOC_DSC"));
		
		getAttributeWizardPage().setTitle(TestJavaPlugin.getString("WIZ_NEW_JUNIT_TST_SUITE_PG_TTL"));
		getAttributeWizardPage().setDescription(TestJavaPlugin.getString("WIZ_NEW_JUNIT_TST_SUITE_PG_ATT_DSC"));
		
		super.addPages();
	}
}
