/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.common;

import org.eclipse.hyades.loaders.util.HierarchyContext;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdict;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictEvent;
import org.eclipse.hyades.models.common.testprofile.TPFVerdictReason;
import org.eclipse.hyades.models.common.testprofile.impl.Common_TestprofileFactoryImpl;

/**
 * @author amathur
 *
 * This is a verdict event loader
 */
public class XMLverdictEventLoader extends XMLexecutionEventLoader {
	// Static variables
	protected final static String EVENT_VERDICT_VERDICT = "verdict";
	protected final static String EVENT_VERDICT_REASON = "reason";
	
	// Attribute variables
	protected TPFVerdict verdict = null;
	protected TPFVerdictReason verdictReason = null;

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#initialize(org.eclipse.hyades.loaders.util.HierarchyContext, java.lang.String)
	 */
	public void initialize(HierarchyContext context, String name) {
		super.initialize(context, name);
		verdict = null;
		verdictReason = null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addAttribute(java.lang.String, java.lang.String)
	 */
	public void addAttribute(String name, String value) {
		printAttribute(name, value);
		switch (LoadersUtils.getHashCode(name)) {
		case ExecutionConstants.EVENT_VERDICT_VERDICT_int :
			verdict = TPFVerdict.get(Integer.parseInt(value));
			break;
			
		case ExecutionConstants.EVENT_VERDICT_REASON_int :
			verdictReason = TPFVerdictReason.get(Integer.parseInt(value));
			break;

		default:
			super.addAttribute(name, value);
			break;
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.XMLFragmentLoader#addYourselfInContext()
	 */
	public void addYourselfInContext() {
		// Create the event
		TPFVerdictEvent typedEvent = Common_TestprofileFactoryImpl.eINSTANCE.createTPFVerdictEvent();
		
		// Now populate the specialized attributes
		typedEvent.setVerdict(verdict);
		typedEvent.setReason(verdictReason);
		
		// populate the event with the base event attributes
		event = (TPFExecutionEvent) typedEvent;
		super.addYourselfInContext();
	}
}
