/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.configuration.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.common.impl.CMNNamedElementImpl;
import org.eclipse.hyades.models.common.configuration.CFGArtifact;
import org.eclipse.hyades.models.common.configuration.CFGClass;
import org.eclipse.hyades.models.common.configuration.CFGDeploymentSpec;
import org.eclipse.hyades.models.common.configuration.CFGLocation;
import org.eclipse.hyades.models.common.configuration.Common_ConfigurationPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>CFG Artifact</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGArtifactImpl#getDeployableInstances <em>Deployable Instances</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGArtifactImpl#getDeploymentSpec <em>Deployment Spec</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.configuration.impl.CFGArtifactImpl#getLocation <em>Location</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CFGArtifactImpl extends CMNNamedElementImpl implements CFGArtifact
{
	/**
	 * The cached value of the '{@link #getDeployableInstances() <em>Deployable Instances</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeployableInstances()
	 * @generated
	 * @ordered
	 */
	protected EList deployableInstances = null;

	/**
	 * The cached value of the '{@link #getDeploymentSpec() <em>Deployment Spec</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeploymentSpec()
	 * @generated
	 * @ordered
	 */
	protected CFGDeploymentSpec deploymentSpec = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CFGArtifactImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return Common_ConfigurationPackage.eINSTANCE.getCFGArtifact();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getDeployableInstances() {
		if (deployableInstances == null) {
			deployableInstances = new EObjectWithInverseResolvingEList.ManyInverse(CFGClass.class, this, Common_ConfigurationPackage.CFG_ARTIFACT__DEPLOYABLE_INSTANCES, Common_ConfigurationPackage.CFG_CLASS__ARTIFACTS);
		}
		return deployableInstances;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CFGDeploymentSpec getDeploymentSpec() {
		if (deploymentSpec != null && deploymentSpec.eIsProxy()) {
			CFGDeploymentSpec oldDeploymentSpec = deploymentSpec;
			deploymentSpec = (CFGDeploymentSpec)EcoreUtil.resolve(deploymentSpec, this);
			if (deploymentSpec != oldDeploymentSpec) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, Common_ConfigurationPackage.CFG_ARTIFACT__DEPLOYMENT_SPEC, oldDeploymentSpec, deploymentSpec));
			}
		}
		return deploymentSpec;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CFGDeploymentSpec basicGetDeploymentSpec() {
		return deploymentSpec;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDeploymentSpec(CFGDeploymentSpec newDeploymentSpec, NotificationChain msgs) {
		CFGDeploymentSpec oldDeploymentSpec = deploymentSpec;
		deploymentSpec = newDeploymentSpec;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_ARTIFACT__DEPLOYMENT_SPEC, oldDeploymentSpec, newDeploymentSpec);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDeploymentSpec(CFGDeploymentSpec newDeploymentSpec) {
		if (newDeploymentSpec != deploymentSpec) {
			NotificationChain msgs = null;
			if (deploymentSpec != null)
				msgs = ((InternalEObject)deploymentSpec).eInverseRemove(this, Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__ARTIFACT, CFGDeploymentSpec.class, msgs);
			if (newDeploymentSpec != null)
				msgs = ((InternalEObject)newDeploymentSpec).eInverseAdd(this, Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__ARTIFACT, CFGDeploymentSpec.class, msgs);
			msgs = basicSetDeploymentSpec(newDeploymentSpec, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_ARTIFACT__DEPLOYMENT_SPEC, newDeploymentSpec, newDeploymentSpec));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CFGLocation getLocation() {
		if (eContainerFeatureID != Common_ConfigurationPackage.CFG_ARTIFACT__LOCATION) return null;
		return (CFGLocation)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLocation(CFGLocation newLocation) {
		if (newLocation != eContainer || (eContainerFeatureID != Common_ConfigurationPackage.CFG_ARTIFACT__LOCATION && newLocation != null)) {
			if (EcoreUtil.isAncestor(this, newLocation))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newLocation != null)
				msgs = ((InternalEObject)newLocation).eInverseAdd(this, Common_ConfigurationPackage.CFG_LOCATION__ARTIFACTS, CFGLocation.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newLocation, Common_ConfigurationPackage.CFG_ARTIFACT__LOCATION, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_ConfigurationPackage.CFG_ARTIFACT__LOCATION, newLocation, newLocation));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_ConfigurationPackage.CFG_ARTIFACT__DEPLOYABLE_INSTANCES:
					return ((InternalEList)getDeployableInstances()).basicAdd(otherEnd, msgs);
				case Common_ConfigurationPackage.CFG_ARTIFACT__DEPLOYMENT_SPEC:
					if (deploymentSpec != null)
						msgs = ((InternalEObject)deploymentSpec).eInverseRemove(this, Common_ConfigurationPackage.CFG_DEPLOYMENT_SPEC__ARTIFACT, CFGDeploymentSpec.class, msgs);
					return basicSetDeploymentSpec((CFGDeploymentSpec)otherEnd, msgs);
				case Common_ConfigurationPackage.CFG_ARTIFACT__LOCATION:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, Common_ConfigurationPackage.CFG_ARTIFACT__LOCATION, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_ConfigurationPackage.CFG_ARTIFACT__DEPLOYABLE_INSTANCES:
					return ((InternalEList)getDeployableInstances()).basicRemove(otherEnd, msgs);
				case Common_ConfigurationPackage.CFG_ARTIFACT__DEPLOYMENT_SPEC:
					return basicSetDeploymentSpec(null, msgs);
				case Common_ConfigurationPackage.CFG_ARTIFACT__LOCATION:
					return eBasicSetContainer(null, Common_ConfigurationPackage.CFG_ARTIFACT__LOCATION, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case Common_ConfigurationPackage.CFG_ARTIFACT__LOCATION:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_ConfigurationPackage.CFG_LOCATION__ARTIFACTS, CFGLocation.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_ARTIFACT__ID:
				return getId();
			case Common_ConfigurationPackage.CFG_ARTIFACT__NAME:
				return getName();
			case Common_ConfigurationPackage.CFG_ARTIFACT__DESCRIPTION:
				return getDescription();
			case Common_ConfigurationPackage.CFG_ARTIFACT__DEPLOYABLE_INSTANCES:
				return getDeployableInstances();
			case Common_ConfigurationPackage.CFG_ARTIFACT__DEPLOYMENT_SPEC:
				if (resolve) return getDeploymentSpec();
				return basicGetDeploymentSpec();
			case Common_ConfigurationPackage.CFG_ARTIFACT__LOCATION:
				return getLocation();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_ARTIFACT__ID:
				setId((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_ARTIFACT__NAME:
				setName((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_ARTIFACT__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case Common_ConfigurationPackage.CFG_ARTIFACT__DEPLOYABLE_INSTANCES:
				getDeployableInstances().clear();
				getDeployableInstances().addAll((Collection)newValue);
				return;
			case Common_ConfigurationPackage.CFG_ARTIFACT__DEPLOYMENT_SPEC:
				setDeploymentSpec((CFGDeploymentSpec)newValue);
				return;
			case Common_ConfigurationPackage.CFG_ARTIFACT__LOCATION:
				setLocation((CFGLocation)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_ARTIFACT__ID:
				setId(ID_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_ARTIFACT__NAME:
				setName(NAME_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_ARTIFACT__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case Common_ConfigurationPackage.CFG_ARTIFACT__DEPLOYABLE_INSTANCES:
				getDeployableInstances().clear();
				return;
			case Common_ConfigurationPackage.CFG_ARTIFACT__DEPLOYMENT_SPEC:
				setDeploymentSpec((CFGDeploymentSpec)null);
				return;
			case Common_ConfigurationPackage.CFG_ARTIFACT__LOCATION:
				setLocation((CFGLocation)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_ConfigurationPackage.CFG_ARTIFACT__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case Common_ConfigurationPackage.CFG_ARTIFACT__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case Common_ConfigurationPackage.CFG_ARTIFACT__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case Common_ConfigurationPackage.CFG_ARTIFACT__DEPLOYABLE_INSTANCES:
				return deployableInstances != null && !deployableInstances.isEmpty();
			case Common_ConfigurationPackage.CFG_ARTIFACT__DEPLOYMENT_SPEC:
				return deploymentSpec != null;
			case Common_ConfigurationPackage.CFG_ARTIFACT__LOCATION:
				return getLocation() != null;
		}
		return eDynamicIsSet(eFeature);
	}

} //CFGArtifactImpl
