/*******************************************************************************
 * Copyright (c) 2003 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.models.common.facades.behavioral.impl;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;

/**
 * @author jtoomey
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class FacadeResourceImpl extends XMIResourceImpl {

	/**
	 * 
	 */
	public FacadeResourceImpl() {
		super();
	}

	/**
	 * @param arg0
	 */
	public FacadeResourceImpl(URI arg0) {
		super(arg0);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.ecore.resource.impl.ResourceImpl#attached(org.eclipse.emf.ecore.EObject)
	 */
	public void attached(EObject arg0) {
		super.attached(arg0);
				
		if(arg0.eClass().equals(Common_TestprofilePackage.eINSTANCE.getTPFTestSuite()))
		{
			HyadesCommon_TestprofileAdapterFactory adaptorFactory = new HyadesCommon_TestprofileAdapterFactory();
			adaptorFactory.adapt(arg0, Common_TestprofilePackage.eINSTANCE.getTPFTestSuite()); 
		}
		if(arg0.eClass().equals(Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteraction()))
		{
			HyadesCommon_Behavior_FragmentsAdapterFactory adaptorFactory = new HyadesCommon_Behavior_FragmentsAdapterFactory();
			adaptorFactory.adapt(arg0, Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteraction()); 
		}
		if(arg0.eClass().equals(Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteractionOperand()))
		{
			HyadesCommon_Behavior_FragmentsAdapterFactory adaptorFactory = new HyadesCommon_Behavior_FragmentsAdapterFactory();
			adaptorFactory.adapt(arg0, Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteractionOperand()); 
		}		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.ecore.resource.impl.ResourceImpl#detached(org.eclipse.emf.ecore.EObject)
	 */
	public void detached(EObject arg0) {
		super.detached(arg0);
		arg0.eAdapters().clear();		
	}

}
