/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.fragments.impl;

import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.hyades.models.common.facades.behavioral.IBlock;
import org.eclipse.hyades.models.common.fragments.BVRGate;
import org.eclipse.hyades.models.common.fragments.BVRInteraction;
import org.eclipse.hyades.models.common.fragments.Common_Behavior_FragmentsPackage;
import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.interactions.BVRLifeline;
import org.eclipse.hyades.models.common.interactions.Common_Behavior_InteractionsPackage;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>BVR Interaction</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl#getLifelines <em>Lifelines</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl#getInteractionFragments <em>Interaction Fragments</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl#getFormalGates <em>Formal Gates</em>}</li>
 *   <li>{@link org.eclipse.hyades.models.common.fragments.impl.BVRInteractionImpl#getBehavior <em>Behavior</em>}</li>
 * </ul>
 * </p>
 * 
 * @extends IBlock
 * @generated NOT
 */
public class BVRInteractionImpl extends EObjectImpl implements BVRInteraction, IBlock
{
	/**
	 * The cached value of the '{@link #getLifelines() <em>Lifelines</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLifelines()
	 * @generated
	 * @ordered
	 */
	protected EList lifelines = null;

	/**
	 * The cached value of the '{@link #getInteractionFragments() <em>Interaction Fragments</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInteractionFragments()
	 * @generated
	 * @ordered
	 */
	protected EList interactionFragments = null;

	/**
	 * The cached value of the '{@link #getFormalGates() <em>Formal Gates</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFormalGates()
	 * @generated
	 * @ordered
	 */
	protected EList formalGates = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BVRInteractionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return Common_Behavior_FragmentsPackage.eINSTANCE.getBVRInteraction();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getLifelines() {
		if (lifelines == null) {
			lifelines = new EObjectContainmentWithInverseEList(BVRLifeline.class, this, Common_Behavior_FragmentsPackage.BVR_INTERACTION__LIFELINES, Common_Behavior_InteractionsPackage.BVR_LIFELINE__INTERACTION);
		}
		return lifelines;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getInteractionFragments() {
		if (interactionFragments == null) {
			interactionFragments = new EObjectContainmentWithInverseEList(BVRInteractionFragment.class, this, Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS, Common_Behavior_InteractionsPackage.BVR_INTERACTION_FRAGMENT__INTERACTION);
		}
		return interactionFragments;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getFormalGates() {
		if (formalGates == null) {
			formalGates = new EObjectContainmentEList(BVRGate.class, this, Common_Behavior_FragmentsPackage.BVR_INTERACTION__FORMAL_GATES);
		}
		return formalGates;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFBehavior getBehavior() {
		if (eContainerFeatureID != Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR) return null;
		return (TPFBehavior)eContainer;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBehavior(TPFBehavior newBehavior) {
		if (newBehavior != eContainer || (eContainerFeatureID != Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR && newBehavior != null)) {
			if (EcoreUtil.isAncestor(this, newBehavior))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eContainer != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newBehavior != null)
				msgs = ((InternalEObject)newBehavior).eInverseAdd(this, Common_TestprofilePackage.TPF_BEHAVIOR__INTERACTION, TPFBehavior.class, msgs);
			msgs = eBasicSetContainer((InternalEObject)newBehavior, Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR, newBehavior, newBehavior));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION__LIFELINES:
					return ((InternalEList)getLifelines()).basicAdd(otherEnd, msgs);
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS:
					return ((InternalEList)getInteractionFragments()).basicAdd(otherEnd, msgs);
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION__LIFELINES:
					return ((InternalEList)getLifelines()).basicRemove(otherEnd, msgs);
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS:
					return ((InternalEList)getInteractionFragments()).basicRemove(otherEnd, msgs);
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION__FORMAL_GATES:
					return ((InternalEList)getFormalGates()).basicRemove(otherEnd, msgs);
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR:
					return eBasicSetContainer(null, Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_TestprofilePackage.TPF_BEHAVIOR__INTERACTION, TPFBehavior.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__LIFELINES:
				return getLifelines();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS:
				return getInteractionFragments();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__FORMAL_GATES:
				return getFormalGates();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR:
				return getBehavior();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__LIFELINES:
				getLifelines().clear();
				getLifelines().addAll((Collection)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS:
				getInteractionFragments().clear();
				getInteractionFragments().addAll((Collection)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__FORMAL_GATES:
				getFormalGates().clear();
				getFormalGates().addAll((Collection)newValue);
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR:
				setBehavior((TPFBehavior)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__LIFELINES:
				getLifelines().clear();
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS:
				getInteractionFragments().clear();
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__FORMAL_GATES:
				getFormalGates().clear();
				return;
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR:
				setBehavior((TPFBehavior)null);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__LIFELINES:
				return lifelines != null && !lifelines.isEmpty();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__INTERACTION_FRAGMENTS:
				return interactionFragments != null && !interactionFragments.isEmpty();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__FORMAL_GATES:
				return formalGates != null && !formalGates.isEmpty();
			case Common_Behavior_FragmentsPackage.BVR_INTERACTION__BEHAVIOR:
				return getBehavior() != null;
		}
		return eDynamicIsSet(eFeature);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.IBlock#getActions()
	 */
	public List getActions() {
		return getInteractionFragments();
	}
	
	private String name;
	private String description;
	private String id;
	
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.INamedElement#getDescription()
	 */
	public String getDescription() {
		return description;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.INamedElement#getName()
	 */
	public String getName() {
		return name;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.INamedElement#setDescription(java.lang.String)
	 */
	public void setDescription(String description) {
		this.description = description;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.INamedElement#setName(java.lang.String)
	 */
	public void setName(String name) {
		this.name = name;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.INamedElement#getId()
	 */
	public String getId() {
		return id;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.hyades.models.common.facades.behavioral.INamedElement#setId(java.lang.String)
	 */
	public void setId(String id) {
		this.id = id;
	}

} //BVRInteractionImpl
