/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.common.testprofile.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.hyades.models.common.interactions.BVRInteractionFragment;
import org.eclipse.hyades.models.common.testprofile.Common_TestprofilePackage;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent;
import org.eclipse.hyades.models.common.testprofile.TPFExecutionHistory;
import org.eclipse.hyades.models.common.testprofile.TPFMessageEvent;
import org.eclipse.hyades.models.common.testprofile.TPFSeverity;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>TPF Message Event</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.hyades.models.common.testprofile.impl.TPFMessageEventImpl#getSeverity <em>Severity</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TPFMessageEventImpl extends TPFExecutionEventImpl implements TPFMessageEvent
{
	/**
	 * The default value of the '{@link #getSeverity() <em>Severity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSeverity()
	 * @generated
	 * @ordered
	 */
	protected static final TPFSeverity SEVERITY_EDEFAULT = TPFSeverity.INFO_LITERAL;

	/**
	 * The cached value of the '{@link #getSeverity() <em>Severity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSeverity()
	 * @generated
	 * @ordered
	 */
	protected TPFSeverity severity = SEVERITY_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TPFMessageEventImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return Common_TestprofilePackage.eINSTANCE.getTPFMessageEvent();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TPFSeverity getSeverity() {
		return severity;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSeverity(TPFSeverity newSeverity) {
		TPFSeverity oldSeverity = severity;
		severity = newSeverity == null ? SEVERITY_EDEFAULT : newSeverity;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, Common_TestprofilePackage.TPF_MESSAGE_EVENT__SEVERITY, oldSeverity, severity));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_TestprofilePackage.TPF_MESSAGE_EVENT__EXECUTION_HISTORY:
					if (eContainer != null)
						msgs = eBasicRemoveFromContainer(msgs);
					return eBasicSetContainer(otherEnd, Common_TestprofilePackage.TPF_MESSAGE_EVENT__EXECUTION_HISTORY, msgs);
				case Common_TestprofilePackage.TPF_MESSAGE_EVENT__CHILDREN:
					return ((InternalEList)getChildren()).basicAdd(otherEnd, msgs);
				case Common_TestprofilePackage.TPF_MESSAGE_EVENT__PARENT:
					if (parent != null)
						msgs = ((InternalEObject)parent).eInverseRemove(this, Common_TestprofilePackage.TPF_EXECUTION_EVENT__CHILDREN, TPFExecutionEvent.class, msgs);
					return basicSetParent((TPFExecutionEvent)otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case Common_TestprofilePackage.TPF_MESSAGE_EVENT__EXECUTION_HISTORY:
					return eBasicSetContainer(null, Common_TestprofilePackage.TPF_MESSAGE_EVENT__EXECUTION_HISTORY, msgs);
				case Common_TestprofilePackage.TPF_MESSAGE_EVENT__CHILDREN:
					return ((InternalEList)getChildren()).basicRemove(otherEnd, msgs);
				case Common_TestprofilePackage.TPF_MESSAGE_EVENT__PARENT:
					return basicSetParent(null, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
		if (eContainerFeatureID >= 0) {
			switch (eContainerFeatureID) {
				case Common_TestprofilePackage.TPF_MESSAGE_EVENT__EXECUTION_HISTORY:
					return ((InternalEObject)eContainer).eInverseRemove(this, Common_TestprofilePackage.TPF_EXECUTION_HISTORY__EXECUTION_EVENTS, TPFExecutionHistory.class, msgs);
				default:
					return eDynamicBasicRemoveFromContainer(msgs);
			}
		}
		return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__ID:
				return getId();
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__OWNER_ID:
				return getOwnerId();
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__TIMESTAMP:
				return new Long(getTimestamp());
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__TEXT:
				return getText();
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__EXECUTION_HISTORY:
				return getExecutionHistory();
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__INTERACTION_FRAGMENT:
				if (resolve) return getInteractionFragment();
				return basicGetInteractionFragment();
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__CHILDREN:
				return getChildren();
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__PARENT:
				if (resolve) return getParent();
				return basicGetParent();
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__SEVERITY:
				return getSeverity();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__ID:
				setId((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__OWNER_ID:
				setOwnerId((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__TIMESTAMP:
				setTimestamp(((Long)newValue).longValue());
				return;
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__TEXT:
				setText((String)newValue);
				return;
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__EXECUTION_HISTORY:
				setExecutionHistory((TPFExecutionHistory)newValue);
				return;
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__INTERACTION_FRAGMENT:
				setInteractionFragment((BVRInteractionFragment)newValue);
				return;
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__CHILDREN:
				getChildren().clear();
				getChildren().addAll((Collection)newValue);
				return;
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__PARENT:
				setParent((TPFExecutionEvent)newValue);
				return;
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__SEVERITY:
				setSeverity((TPFSeverity)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__ID:
				setId(ID_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__OWNER_ID:
				setOwnerId(OWNER_ID_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__TIMESTAMP:
				setTimestamp(TIMESTAMP_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__TEXT:
				setText(TEXT_EDEFAULT);
				return;
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__EXECUTION_HISTORY:
				setExecutionHistory((TPFExecutionHistory)null);
				return;
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__INTERACTION_FRAGMENT:
				setInteractionFragment((BVRInteractionFragment)null);
				return;
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__CHILDREN:
				getChildren().clear();
				return;
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__PARENT:
				setParent((TPFExecutionEvent)null);
				return;
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__SEVERITY:
				setSeverity(SEVERITY_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__ID:
				return ID_EDEFAULT == null ? id != null : !ID_EDEFAULT.equals(id);
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__OWNER_ID:
				return OWNER_ID_EDEFAULT == null ? ownerId != null : !OWNER_ID_EDEFAULT.equals(ownerId);
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__TIMESTAMP:
				return timestamp != TIMESTAMP_EDEFAULT;
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__TEXT:
				return TEXT_EDEFAULT == null ? text != null : !TEXT_EDEFAULT.equals(text);
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__EXECUTION_HISTORY:
				return getExecutionHistory() != null;
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__INTERACTION_FRAGMENT:
				return interactionFragment != null;
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__CHILDREN:
				return children != null && !children.isEmpty();
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__PARENT:
				return parent != null;
			case Common_TestprofilePackage.TPF_MESSAGE_EVENT__SEVERITY:
				return severity != SEVERITY_EDEFAULT;
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (severity: ");
		result.append(severity);
		result.append(')');
		return result.toString();
	}

} //TPFMessageEventImpl
