package org.eclipse.hyades.internal.config.generator;

import com.ibm.etools.xmlschema.beans.ComplexType;

/**
* This class represents the complex type <AgentControllerConfiguration>
*/
public class AgentControllerConfiguration extends ComplexType
{
  public AgentControllerConfiguration()
  {
  }
  
  public void setSecurity(int index, Security Security)
  {
    setElementValue(index, "Security", Security);
  }
  
  public Security getSecurity(int index)
  {
    return (Security) getElementValue("Security", "Security", index);
  }
  
  public boolean removeSecurity()
  {
    return removeElement("Security");
  }

  public int getSecurityCount()
  {
	return sizeOfElement("Security");
  }
  
  public boolean removeSecurity(int index)
  {
	return removeElement(index, "Security");
  }

  public void setAgentControllerEnvironment(AgentControllerEnvironment AgentControllerEnvironment)
  {
    setElementValue("AgentControllerEnvironment", AgentControllerEnvironment);
  }
  
  public AgentControllerEnvironment getAgentControllerEnvironment()
  {
    return (AgentControllerEnvironment) getElementValue("AgentControllerEnvironment", "AgentControllerEnvironment");
  }
  
  public boolean removeAgentControllerEnvironment()
  {
    return removeElement("AgentControllerEnvironment");
  }
  
  public void setApplication(int index, Application Application)
  {
    setElementValue(index, "Application", Application);
  }
  
  public Application getApplication(int index)
  {
    return (Application) getElementValue("Application", "Application", index);
  }
  
  public int getApplicationCount()
  {
    return sizeOfElement("Application");
  }
  
  public boolean removeApplication(int index)
  {
    return removeElement(index, "Application");
  }
  
  public void setHosts(int index, Hosts Hosts)
  {
    setElementValue(index, "Hosts", Hosts);
  }
  
  public Hosts getHosts(int index)
  {
    return (Hosts) getElementValue("Hosts", "Hosts", index);
  }
  
  public int getHostsCount()
  {
    return sizeOfElement("Hosts");
  }
  
  public boolean removeHosts(int index)
  {
    return removeElement(index, "Hosts");
  }
  
  public void setService(int index, Service Service)
  {
    setElementValue(index, "Service", Service);
  }
  
  public Service getService(int index)
  {
    return (Service) getElementValue("Service", "Service", index);
  }
  
  public int getServiceCount()
  {
    return sizeOfElement("Service");
  }
  
  public boolean removeService(int index)
  {
    return removeElement(index, "Service");
  }
  
  public void setAgent(int index, Agent Agent)
  {
    setElementValue(index, "Agent", Agent);
  }
  
  public Agent getAgent(int index)
  {
    return (Agent) getElementValue("Agent", "Agent", index);
  }
  
  public int getAgentCount()
  {
    return sizeOfElement("Agent");
  }
  
  public boolean removeAgent(int index)
  {
    return removeElement(index, "Agent");
  }
  
  public void setActiveConfiguration(String activeConfiguration)
  {
    setAttributeValue("activeConfiguration", activeConfiguration);
  }
  
  public String getActiveConfiguration()
  {
    return getAttributeValue("activeConfiguration");
  }
  
  public boolean removeActiveConfiguration()
  {
    return removeAttribute("activeConfiguration");
  }
  
  public void setVersion(String version)
  {
    setAttributeValue("version", version);
  }
  
  public String getVersion()
  {
    return getAttributeValue("version");
  }
  
  public boolean removeVersion()
  {
    return removeAttribute("version");
  }
  
  public void setPort(String port)
  {
    setAttributeValue("port", port);
  }
  
  public String getPort()
  {
    return getAttributeValue("port");
  }
  
  public boolean removePort()
  {
    return removeAttribute("port");
  }
  
  public void setSecurePort(String securePort)
  {
    setAttributeValue("securePort", securePort);
  }
  
  public String getSecurePort()
  {
    return getAttributeValue("securePort");
  }
  
  public boolean removeSecurePort()
  {
    return removeAttribute("securePort");
  }
  
  public void setLoggingLevel(String loggingLevel)
  {
    setAttributeValue("loggingLevel", loggingLevel);
  }
  
  public String getLoggingLevel()
  {
    return getAttributeValue("loggingLevel");
  }
  
  public boolean removeLoggingLevel()
  {
    return removeAttribute("loggingLevel");
  }
  
  public void setLoggingDetail(String loggingDetail)
  {
    setAttributeValue("loggingDetail", loggingDetail);
  }
  
  public String getLoggingDetail()
  {
    return getAttributeValue("loggingDetail");
  }
  
  public boolean removeLoggingDetail()
  {
    return removeAttribute("loggingDetail");
  }
  
  public void setLoggingDirectory(String loggingDirectory)
  {
    setAttributeValue("loggingDirectory", loggingDirectory);
  }
  
  public String getLoggingDirectory()
  {
    return getAttributeValue("loggingDirectory");
  }
  
  public boolean removeLoggingDirectory()
  {
    return removeAttribute("loggingDirectory");
  }

  public void setJvm(String jvm)
  {
	setAttributeValue("jvm", jvm);
  }
  
  public String getJvm()
  {
	return getAttributeValue("jvm");
  }
  
  public boolean removeJvm()
  {
	return removeAttribute("jvm");
  }
  
}

