/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.trace.internal.loader;

import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.sd.ui.internal.loader.*;
import org.eclipse.hyades.sd.ui.internal.model.*;

public class TRCMonitorLoader extends TRCModelLoaderUtility implements IModelLoader
{
  private TRCMonitor trcMonitor = null;

  public TRCMonitorLoader()
  {
  }
  
  public TRCMonitorLoader(TRCMonitor monitor, Graph inputGraph)
  {
    TRCMonitorLoader loader = new TRCMonitorLoader();
    trcMonitor = monitor;
    graph = inputGraph;
  }
  
  public void setObjectAndGraph(Object mObject, Graph gr){
	trcMonitor = (TRCMonitor)mObject;
	graph = gr;
  }
  
  private void setMonitor(TRCMonitor monitor)
  {
    trcMonitor = monitor;
  }
  private TRCMonitor getMonitor()
  {
    return trcMonitor;
  }

  public void load()
  {
    if (trcMonitor != null)
    {
    	loadAllAgents(trcMonitor);
     	syncAgentTimes();
     	loadInvocationsIntoModel(trcMonitor,graph.getType());
    }
  }
}
