/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.cbe;

import java.util.Map;

import org.eclipse.hyades.loaders.util.GenericLookupService;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.cbe.CBEAssociationEngine;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.impl.CBEAssociationEngineImpl;
import org.eclipse.hyades.models.cbe.impl.CBECommonBaseEventImpl;
/**
 * @author slavescu
 */
public class CBELookupService extends GenericLookupService {
    //~ Constructors -------------------------------------------------------------------------------

    /**
     *
     */
    public CBELookupService() {
        super();
        types.add(CBECommonBaseEventImpl.class);
        types.add(CBEAssociationEngineImpl.class);
    }

    //~ Methods ------------------------------------------------------------------------------------

    protected boolean doProcessObject(Map typeMap, Class type, Object object, boolean remove) {
        if (object == null) {
            return false;
        }

        if (type == CBECommonBaseEventImpl.class) {
            if (((CBECommonBaseEvent) object).getGlobalInstanceId() != null) {
                addOrRemove(typeMap, LoadersUtils.getLookUpKey(((CBECommonBaseEvent) object).getGlobalInstanceId()), object, remove);

                return true;
            }
        } else if (type == CBEAssociationEngineImpl.class) {
            if (((CBEAssociationEngine) object).getId() != null) {
                addOrRemove(typeMap, LoadersUtils.getLookUpKey(((CBEAssociationEngine) object).getId()), object, remove);

                return true;
            }
        }

        return false;
    }
	/* (non-Javadoc)
	 * @see org.eclipse.hyades.loaders.util.GenericLookupService#useAssignableFrom(java.lang.Class)
	 */
	protected boolean useAssignableFrom(Class type) {
		return true;
	}

}
