/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.cbe.util;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.hyades.models.cbe.*;

import org.eclipse.hyades.models.cbe.CBEAssociatedEvent;
import org.eclipse.hyades.models.cbe.CBEAssociationEngine;
import org.eclipse.hyades.models.cbe.CBECommonBaseEvent;
import org.eclipse.hyades.models.cbe.CBEComponentIdentification;
import org.eclipse.hyades.models.cbe.CBEContextDataElement;
import org.eclipse.hyades.models.cbe.CBEDefaultElement;
import org.eclipse.hyades.models.cbe.CBEDefaultEvent;
import org.eclipse.hyades.models.cbe.CBEExtendedDataElement;
import org.eclipse.hyades.models.cbe.CBEMsgDataElement;
import org.eclipse.hyades.models.cbe.CBEPackage;
import org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.cbe.CBEPackage
 * @generated
 */
public class CBESwitch {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "";

	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static CBEPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CBESwitch() {
		if (modelPackage == null) {
			modelPackage = CBEPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public Object doSwitch(EObject theEObject) {
		EClass theEClass = theEObject.eClass();
		if (theEClass.eContainer() == modelPackage) {
			switch (theEClass.getClassifierID()) {
				case CBEPackage.CBE_COMMON_BASE_EVENT: {
					CBECommonBaseEvent cbeCommonBaseEvent = (CBECommonBaseEvent)theEObject;
					Object result = caseCBECommonBaseEvent(cbeCommonBaseEvent);
					if (result == null) result = caseCBEDefaultEvent(cbeCommonBaseEvent);
					if (result == null) result = caseAbstractDefaultEvent(cbeCommonBaseEvent);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_EXTENDED_DATA_ELEMENT: {
					CBEExtendedDataElement cbeExtendedDataElement = (CBEExtendedDataElement)theEObject;
					Object result = caseCBEExtendedDataElement(cbeExtendedDataElement);
					if (result == null) result = caseCBEDefaultElement(cbeExtendedDataElement);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_CONTEXT_DATA_ELEMENT: {
					CBEContextDataElement cbeContextDataElement = (CBEContextDataElement)theEObject;
					Object result = caseCBEContextDataElement(cbeContextDataElement);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_ASSOCIATED_EVENT: {
					CBEAssociatedEvent cbeAssociatedEvent = (CBEAssociatedEvent)theEObject;
					Object result = caseCBEAssociatedEvent(cbeAssociatedEvent);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_COMPONENT_IDENTIFICATION: {
					CBEComponentIdentification cbeComponentIdentification = (CBEComponentIdentification)theEObject;
					Object result = caseCBEComponentIdentification(cbeComponentIdentification);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_MSG_DATA_ELEMENT: {
					CBEMsgDataElement cbeMsgDataElement = (CBEMsgDataElement)theEObject;
					Object result = caseCBEMsgDataElement(cbeMsgDataElement);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_ASSOCIATION_ENGINE: {
					CBEAssociationEngine cbeAssociationEngine = (CBEAssociationEngine)theEObject;
					Object result = caseCBEAssociationEngine(cbeAssociationEngine);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_DEFAULT_EVENT: {
					CBEDefaultEvent cbeDefaultEvent = (CBEDefaultEvent)theEObject;
					Object result = caseCBEDefaultEvent(cbeDefaultEvent);
					if (result == null) result = caseAbstractDefaultEvent(cbeDefaultEvent);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				case CBEPackage.CBE_DEFAULT_ELEMENT: {
					CBEDefaultElement cbeDefaultElement = (CBEDefaultElement)theEObject;
					Object result = caseCBEDefaultElement(cbeDefaultElement);
					if (result == null) result = defaultCase(theEObject);
					return result;
				}
				default: return defaultCase(theEObject);
			}
		}
		return defaultCase(theEObject);
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Common Base Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Common Base Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBECommonBaseEvent(CBECommonBaseEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Extended Data Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Extended Data Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEExtendedDataElement(CBEExtendedDataElement object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Context Data Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Context Data Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEContextDataElement(CBEContextDataElement object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Associated Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Associated Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEAssociatedEvent(CBEAssociatedEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Component Identification</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Component Identification</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEComponentIdentification(CBEComponentIdentification object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Msg Data Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Msg Data Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEMsgDataElement(CBEMsgDataElement object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Association Engine</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Association Engine</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEAssociationEngine(CBEAssociationEngine object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Default Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Default Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEDefaultEvent(CBEDefaultEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Default Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Default Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseCBEDefaultElement(CBEDefaultElement object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>Abstract Default Event</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>Abstract Default Event</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public Object caseAbstractDefaultEvent(AbstractDefaultEvent object) {
		return null;
	}

	/**
	 * Returns the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpretting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public Object defaultCase(EObject object) {
		return null;
	}

} //CBESwitch
