/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.collection.correlation;

/**
 * This is a context handler capable of handling six distinct events.  This interface only suggests the semantics of
 * the events, and implementors can choose which events to use and their precise semantics.
 * 
 * @author Qiyan Li
 */
public interface IContextHandler {

    /**
     * Handles an entry event which occurs before a local method invocation.
     * 
     * @param context   the context data related to this event
     */
	public void handleEntry(CorrelatorAssociation context);
	
    /**
     * Handles an exit event which occurs after a local method invocation has returned.
     * 
     * @param context   the context data related to this event
     */
	public void handleExit(CorrelatorAssociation context);

    /**
     * Handles a send event which occurs before a remote invocation request is sent.
     * 
     * @param context   the context data related to this event
     */
	public void handleSend(CorrelatorAssociation context);
	
    /**
     * Handles a receive event which occurs after a remote invocation request has been received.
     * 
     * @param context   the context data related to this event
     */
    public void handleReceive(CorrelatorAssociation context);

    /**
     * Handles a reply event which occurs before a remote invocation replies.
     * 
     * @param context   the context data related to this event
     */
    public void handleReply(CorrelatorAssociation context);
    
    /**
     * Handles a return event which occurs after the reply of a remote invocation has been received.
     * 
     * @param context   the context data related to this event
     */
	public void handleReturn(CorrelatorAssociation contex);
}
