/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.jface.dialogs.MessageDialog;


public class DetachActionDelegate extends AbstractListenerActionDelegate {
 
    /**
     * @see AbstractProfileActionDelegate#doAction(Object)
     */
    public void doAction(Object object) throws Exception {
        if ((object == null) || !(object instanceof TRCAgentProxy)) {
            return;
        }

        PDProjectExplorer fViewer = UIPlugin.getDefault().getViewer();

        if (fViewer == null) {
            MessageDialog.openInformation(UIPlugin.getActiveWorkbenchShell(), "Title", "Action not available in current context");

            return;
        }

        run((TRCAgentProxy) object, fViewer);
    }

    public void run(TRCAgentProxy agent, PDProjectExplorer fViewer) {		
//		if (agent.isMonitored() && UIPlugin.getDefault().getPreferenceStore().getBoolean(TraceConstants.PROFILE_TIPS))
//		{
//			DetachWarningDialog infodialog = new DetachWarningDialog(UIPlugin.getDefault().getViewer().getShell(), UIPlugin.getResourceString("PROFILING_TIP_TITLE"));
//			if (infodialog.open()==Window.CANCEL) return;		
//		}

        try {
			PDCoreUtil.detachAgent(agent);

            ProfileEvent event = UIPlugin.getDefault().getProfileEvent();

            event.setSource(agent);
            event.setType(ProfileEvent.DETACH);

            UIPlugin.getDefault().notifyProfileEventListener(event);
        } catch (Exception exc) {
            exc.printStackTrace();
        }
    }


    /**
     * @see AbstractProfileActionDelegate#isEnabledFor(Object)
     */
    protected boolean isEnabledFor(Object element) {
        if ((element != null) && (element instanceof TRCAgentProxy) && ((TRCAgentProxy) element).isAttached()) {
            return true;
        }

        return false;
    }

    /**
     * @see AbstractProfileActionDelegate#enableForMultiSelection()
     */
    protected boolean enableForMultiSelection() {
        return false;
    }
}
