/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.trace.ui.internal.actions;

import org.eclipse.hyades.internal.execution.local.control.Agent;
import org.eclipse.hyades.internal.execution.local.control.Node;
import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.ProfileEvent;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.AttachInfoDialog;
import org.eclipse.hyades.trace.ui.internal.util.PDCoreUtil;
import org.eclipse.hyades.trace.ui.internal.util.WarningDialog;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;


/**
 * @author slavescu
 */
public class NewSnapshotActionDelegate extends AbstractListenerActionDelegate {
    //~ Methods ------------------------------------------------------------------------------------

    /**
     * @see AbstractProfileActionDelegate#doAction(Object)
     */
    public void doAction(Object object) throws Exception {
        if ((object == null) || !(object instanceof TRCAgentProxy)) {
            return;
        }

        PDProjectExplorer fViewer = UIPlugin.getDefault().getViewer();

        if (fViewer == null) {
            MessageDialog.openInformation(UIPlugin.getActiveWorkbenchShell(), "title", "Action not available in current context");

            return;
        }

        run((TRCAgentProxy) object, fViewer);
    }

    public void run(TRCAgentProxy fAgent, PDProjectExplorer fViewer) {
        if (fAgent.isActive() && fAgent.isAttached() && UIPlugin.getDefault().getPreferenceStore().getBoolean(TraceConstants.NEW_SNAPSHOT_TIPS)) {
            WarningDialog infodialog = new WarningDialog(UIPlugin.getDefault().getViewer().getShell(), UIPlugin.getResourceString("NEW_SNAPSHOT_TIP_TITLE"), UIPlugin.getResourceString("NEW_SNAPSHOT_WARNING_MESSAGE"), UIPlugin.getResourceString("NEW_SNAPSHOT_WARNING_TEXT"), TraceConstants.NEW_SNAPSHOT_TIPS);

            if (infodialog.open() == Window.CANCEL) {
                return;
            }
        }

        if (UIPlugin.getDefault().getPreferenceStore().getBoolean(TraceConstants.PROFILE_TIPS)) {
            AttachInfoDialog infodialog = new AttachInfoDialog(UIPlugin.getDefault().getViewer().getShell(), UIPlugin.getResourceString("PROFILING_TIP_TITLE"));

            infodialog.open();
        }

        try {
            PDCoreUtil.detachAgent(fAgent);

            ProfileEvent event = UIPlugin.getDefault().getProfileEvent();

            event.setSource(fAgent);
            event.setType(ProfileEvent.DETACH);

            UIPlugin.getDefault().notifyProfileEventListener(event);

            TRCProcessProxy process = fAgent.getProcessProxy();
            String hostName = process.getNode().getName();
            Node node = PDCoreUtil.profileConnect(hostName, String.valueOf(process.getNode().getPort()));

            if (node == null) {
                return;
            }

            Object instance = LoadersUtils.locateAgentInstance(fAgent);

            if ((instance != null) && instance instanceof Agent) {
                Agent a = (Agent) instance;

                if (a.isActive()) {
                    if (fAgent.isActive()) {
                        PDCoreUtil.detachAgent(fAgent);
                        fAgent.setActive(false);
                    }

					TRCAgentProxy fAgentOld = fAgent;
					
                    fAgent = PDCoreUtil.createUniqueAgent(process, a);
					
					PDCoreUtil.copyAgentProperties(fAgentOld,fAgent);
				
                    PDCoreUtil.doAttach(a, fAgent);

                    PDCoreUtil.activate(fAgent);
                }
            }

            event = UIPlugin.getDefault().getProfileEvent();
            event.setSource(fAgent);
            event.setType(ProfileEvent.ATTACH);
            UIPlugin.getDefault().notifyProfileEventListener(event);
        } catch (Exception exc) {
            exc.printStackTrace();
        }
    }

    /**
     * @see AbstractProfileActionDelegate#isEnabledFor(Object)
     */
    protected boolean isEnabledFor(Object element) {
        if ((element != null) && (element instanceof TRCAgentProxy) && ((TRCAgentProxy) element).isActive() && ((TRCAgentProxy) element).isAttached()) {
            return true;
        }

        return false;
    }

    /**
     * @see AbstractProfileActionDelegate#enableForMultiSelection()
     */
    protected boolean enableForMultiSelection() {
        return false;
    }
}
