/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.util.HierarchyResourceSetImpl;
import org.eclipse.hyades.trace.internal.ui.PDContentProvider;
import org.eclipse.hyades.trace.internal.ui.PDProjectExplorer;
import org.eclipse.hyades.trace.ui.IDeleteListener;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.SelectionProviderAction;

/*
* CONTEXT_ID refl0000 for refresh from local action
*/

public class RefreshFromLocalAction extends SelectionProviderAction
									implements ISelectionChangedListener
{
  private PDProjectExplorer fViewer;

  public RefreshFromLocalAction(PDProjectExplorer viewer)
  {
	super(viewer.getViewer(), UIPlugin.getResourceString("RELOAD"));
	setDescription(UIPlugin.getResourceString("RELOAD_LOCAL_FILE"));
	fViewer = viewer;

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		this,
		UIPlugin.getPluginId()+".refl0000");
	
	setToolTipText(UIPlugin.getResourceString("RELOAD_LOCAL_FILE_TOOLTIP"));	
  }    
  public void run()
  {
	String title = UIPlugin.getResourceString("TRACE_MSG");	
	String msg = UIPlugin.getResourceString("RELOAD_QUESTION");
	
	if(! MessageDialog.openQuestion(fViewer.getShell(), title, msg))
		return;
	  	  
	PDContentProvider.resetMonitors();

	//unload resources
//	Hashtable list = SaveUtil.getDocuments();
	Resource[] resources = (Resource[]) HierarchyResourceSetImpl.getInstance().getResources().toArray(new Resource[HierarchyResourceSetImpl.getInstance().getResources().size()]);
	for (int k=resources.length-1; k>0;k-- )
	{			  
	    Resource r = resources[k];
		Iterator i = r.getContents().iterator();
		while (i.hasNext())
		{
			Object obj = i.next();
			if (obj instanceof TRCProcessProxy)
			{
				UIPlugin.getDefault().getTraceManager().deregisterTrace((TRCProcessProxy)obj);
				UIPlugin.getDefault().deregisterLaunchProcess((TRCProcessProxy)obj);									
			}
			if (obj instanceof TRCAgentProxy)
				UIPlugin.getDefault().getTraceManager().deregisterTrace((TRCAgentProxy)obj);

			ArrayList deletelist = UIPlugin.getDefault().getDeleteListeners();
			for(int j=0; j<deletelist.size();j++)
			{
				((IDeleteListener)deletelist.get(j)).deregister(obj);
			}									
	    						    
//			SaveUtil.removeDocument(r);
	    }
	    r.unload();
	}
	fViewer.getViewer().refresh(); 	
  }  
  public void selectionChanged(IStructuredSelection selection)
  {
	setEnabled(true);
  }
  
  public void dispose() {
		
	  super.dispose();
		
	  fViewer = null;
  }

}
