/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.actions;

import java.util.*;

import org.eclipse.core.runtime.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.ui.internal.launcher.*;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.jface.action.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.swt.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.*;

/**
 * Parent of run & debug pulldown actions.
 */
public class TraceDropDownAction implements IWorkbenchWindowPulldownDelegate
{	
	private TraceAction _traceAction;
	private Vector pullDownButtonActionMap;
	/**
	 *	Create a new instance of this class
	 */
	public TraceDropDownAction()
	{
		super();
		getToolBarButtonActionsExtentionPoint();
		_traceAction = new TraceAction();
	}
	private void createMenuForAction(Menu parent, Action action) {
		ActionContributionItem item= new ActionContributionItem(action);
		item.fill(parent, -1);
	}
	/**
	 * @see IWorkbenchWindowActionDelegate
	 */
	public void dispose() {
	}

	protected void getToolBarButtonActionsExtentionPoint()
	{
		IPluginRegistry reg = Platform.getPluginRegistry();

		IConfigurationElement[] config =
			reg.getConfigurationElementsFor("com.ibm.etools.pd.core", "toolBarButtonActions");

		pullDownButtonActionMap = new Vector();
		for (int idx = 0; idx < config.length; idx++) {
			IConfigurationElement elem = config[idx];
			String id = elem.getAttribute("id");
			String clas = elem.getAttribute("class");
			
			try {
				Object buttonAction = elem.createExecutableExtension("class");
				if (buttonAction instanceof ToolBarAction) {
					pullDownButtonActionMap.add(buttonAction);
				} else {
					System.err.println(
						"pullDownButtonAction "
							+ clas
							+ " should inherit com.ibm.etools.pd.core.launcher.DropDownAction class ! ");
				}
			} 
			catch (CoreException exc) {
				exc.printStackTrace();
			}
		}		
	}
	/**
	 * @see IWorkbenchWindowPulldownDelegate
	 */
	public Menu getMenu(Control parent)
	{		
		
		Menu menu= new Menu(parent);

		ArrayList traces = UIPlugin.getDefault().getTraceManager().getTraces();
		for(int idx=0; idx<traces.size(); idx++)
		{
			TraceArguments trace = (TraceArguments) traces.get(idx);

			RelaunchTraceAction action = new RelaunchTraceAction(trace);
			createMenuForAction(menu, action);			
		}

		if(traces.size() > 0)
			new MenuItem(menu, SWT.SEPARATOR);
		
		createMenuForAction(menu, new LaunchTraceAction());
		createMenuForAction(menu, new AttachTraceAction());	
		
		if ((pullDownButtonActionMap!=null) && (pullDownButtonActionMap.size()>0))
		{
			for (int i=0;i<pullDownButtonActionMap.size();i++)
			{
				createMenuForAction(menu, (ToolBarAction)(pullDownButtonActionMap.get(i)));		
			}
		}

		return menu;
	}
	/**
	 * @see IWorkbenchWindowActionDelegate
	 */
	public void init(IWorkbenchWindow window){
	}
	/**
	 * @see IActionDelegate
	 */
	public void run(IAction action) {
		_traceAction.run();
	}
	/**
	 * @see IActionDelegate
	 */
	public void selectionChanged(IAction action, ISelection selection){
	}
}
