/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.launcher;

import org.eclipse.jface.resource.*;
import org.eclipse.swt.widgets.*;
import org.eclipse.jface.action.*;

public abstract class ToolBarAction extends Action
							   implements IMenuCreator
{

	protected ToolBarAction()
	{
		super();
	}
	
	protected ToolBarAction(String text)
	{
		super(text);
	}
	
	protected ToolBarAction(String text, ImageDescriptor image)
	{
		super(text, image);
	}
	
	public abstract void dispose(); 

	public Menu getMenu(Control parent)
	{
		return null;
	}

	public Menu getMenu(Menu parent)
	{
		return null;
	}

	public abstract void run();

}
