/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.preferences;

import org.eclipse.hyades.trace.ui.HyadesConstants;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.core.TraceHostUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
* CONTEXT_ID hstp0000 for Hosts prefernce page
*/
/*
 * The page for setting java plugin preferences.
 */
public class HostPreferencePage extends PreferencePage
									 implements IWorkbenchPreferencePage
{
	private TraceHostUI _options;

	public HostPreferencePage()
	{
		super();
		setPreferenceStore(UIPlugin.getDefault().getPreferenceStore());
	}
/**
 * Insert the method's description here.
 * Creation date: (4/30/2001 12:10:51 PM)
 * @param hosts java.lang.String
 */
private void addHosts(String hosts)
{
	if(hosts != null && !hosts.equals(""))
	{
	   int idx = 0;

	   while(idx != -1)
	   {
		   idx = hosts.indexOf(",");

		   if(idx != -1)
		   {
			   String host = hosts.substring(0, idx);
			   _options.addHost(host);

			   hosts = hosts.substring(idx+1);
			   
		   }
		   else
		   {
			   _options.addHost(hosts);			   
		   }
	   }
	}
	
}
	protected Control createContents(Composite parent)
	{
		Composite composite= new Composite(parent, SWT.NONE);	

		org.eclipse.ui.help.WorkbenchHelp.setHelp(
			parent,
			UIPlugin.getPluginId()+".hstp0000");
		
		GridLayout layout= new GridLayout();
		layout.marginWidth= 0;
		layout.marginHeight= 5;	
		layout.numColumns= 1;		
		composite.setLayout(layout);
		
		_options = new TraceHostUI();
		_options.createControl(composite);

		return composite;
	}
/**
 * Returns preference store that belongs to the our plugin.
 * This is important because we want to store
 * our preferences separately from the desktop.
 *
 * @return the preference store for this plugin
 */
protected IPreferenceStore doGetPreferenceStore() {
	return UIPlugin.getDefault().getPreferenceStore();
}
	public void init(IWorkbench workbench) {
	}
/**
 * Initializes states of the controls using default values
 * in the preference store.
 */
private void initializeDefaults()
{
	IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();

	_options.reset();	
	String hosts = store.getDefaultString(HyadesConstants.HOST_KEY);
	addHosts(hosts);

}
/**
 * Does anything necessary because the default button has been pressed.
 */
protected void performDefaults() {
	super.performDefaults();
	initializeDefaults();
}
/**
 * Do anything necessary because the OK button has been pressed.
 *
 * @return whether it is okay to close the preference page
 */
public boolean performOk() {
	storeValues();
	UIPlugin.getDefault().savePluginPreferences();
	return true;
}

/**
 * Stores the values of the controls back to the preference store.
 */
private void storeValues()
{
	IPreferenceStore store = UIPlugin.getDefault().getPreferenceStore();

	String hosts = "";
	
	TableItem[] items = _options.getHosts();
	for(int idx=0; idx<items.length; idx++)
	{
		hosts +=","+items[idx].getText().trim();		
	}

	if(hosts.startsWith(",") && hosts.length() > 1)
	  hosts = hosts.substring(1);

	store.setValue(HyadesConstants.HOST_KEY, hosts);
}
}
