/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.lang.reflect.InvocationTargetException;
import java.net.UnknownHostException;
import java.util.*;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.hyades.internal.execution.local.control.*;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.hyades.trace.internal.ui.PDPluginImages;
import org.eclipse.hyades.trace.internal.ui.TraceConstants;
import org.eclipse.hyades.trace.ui.HyadesUtil;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.hyades.trace.ui.internal.util.*;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.*;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.*;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;

/*
* CONTEXT_ID atlp0000 for refresh button in attach local wizard page
*/
/*
* CONTEXT_ID atlp0002 for attach agent wizard page
*/
public class AttachLocalPage  extends WizardPage
				  implements SelectionListener
				  , ModifyListener
				, IRunnableWithProgress 
{
	private DoubleCTree _list;
	private boolean _initialized = false;
	private Button _refresh;
	private boolean status = true;        
	private Button _showProcess;
	private boolean fShowAll = false;
	private boolean _validPort = false;
	
	private String _selectedProject;
	private String _sourceLabel = UIPlugin.getResourceString("STR_LIST_SOURCE");
	private String _targetLabel = UIPlugin.getResourceString("STR_LIST_TARGET");
	private String	_selectedMonitor;
	private String _profileFile;
	
  public AttachLocalPage(String name)     
  {
	super(name);
	setTitle(UIPlugin.getResourceString("AGENT_WIZARD_TITLE"));
	setDescription(UIPlugin.getResourceString("AGENT_WIZARD_DSCP"));
	setImageDescriptor(UIPlugin.getImageDescriptor(PDPluginImages.IMG_UI_WZ_ATTACH));
  }  
  
   public void setDoubleTreeLabel(String sourceLabel, String targetLabel)
  {
  	_sourceLabel = sourceLabel;
  	_targetLabel = targetLabel;
  }
  
  /**
  *
  */
  
  public DoubleCTree getList()
  {
 	return _list;
  }
  
  public void createControl(Composite parent)
  {
 
	GridLayout layout;
	
	Composite content = new Composite(parent, SWT.NONE);
	layout = new GridLayout();  
	layout.numColumns = 1;
	layout.verticalSpacing=10;      
	content.setLayout(layout);
	content.setLayoutData(GridUtil.createFill());

	_list = new DoubleCTree(content, SWT.NULL, UIPlugin.getResourceString("STR_LIST_AGENTS"),
					_sourceLabel, _targetLabel);
	_list.setWizardPage((WizardPage)this);
	
    _refresh = new Button(content, SWT.PUSH);
	_refresh.setText(UIPlugin.getResourceString("RESET_DATA"));
	_refresh.setToolTipText(UIPlugin.getResourceString("REINITIALIZE_AGNT_TOOLTIP"));
	_refresh.addSelectionListener(this);

	//_showProcess = new Button(content, SWT.CHECK);
	//_showProcess.setText(UIPlugin.getResourceString("STR_SHOW_ALL_PROC"));
	
	//_showProcess.setSelection(false);
	//_showProcess.addSelectionListener(this);
	_list.sourceList.getTree().addSelectionListener(this);
	_list.targetList.getTree().addSelectionListener(this);  
	
	setControl(content);

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_list.getControl(),
		UIPlugin.getPluginId()+".atlp0002");
	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		_refresh,
		UIPlugin.getPluginId()+".atlp0000");
    org.eclipse.ui.help.WorkbenchHelp.setHelp(
		parent,
		UIPlugin.getPluginId()+".atlp0002");
	
	setPageComplete(isComplete());

  }  
  
  public boolean finish(String selectedProject, String selectedMonitor, String profileFile)
  {
  	_selectedProject = selectedProject;
  	_selectedMonitor = selectedMonitor;
  	_profileFile = profileFile;
  	return finish(); 	
  }
  
  public boolean finish()
  {
		IRunnableWithProgress op= new WorkspaceModifyDelegatingOperation(this);
		try {
			getWizard().getContainer().run(false, true, op);
		} catch (InvocationTargetException e) {
			MessageDialog.openError(getShell(), "Error", e.getTargetException().getMessage());
			return false;
		} catch  (InterruptedException e) {
			return false;
		}

		return true;
  }  
public Enumeration getNodeConfiguration()
{
	String nodeName = ((AttachLocalWizard)getWizard()).getNodeSelected();
	((AttachLocalWizard)getWizard()).setNodeSelection(nodeName);
	
	int portNumber = ((AttachLocalWizard)getWizard()).getPortSelection();
	((AttachLocalWizard)getWizard()).setPortSelection(portNumber);
	
	return PDCoreUtil.getNodeConfiguration(nodeName,portNumber);
}
/**
 * Insert the method's description here.
 * Creation date: (11/01/2000 11:05:37 AM)
 */

public void initialize(Enumeration processList)
{
	_initialized = true;
	_list.initialize(processList, fShowAll); 
}

public void initialize()
{
	initialize(getNodeConfiguration()); 
}

public void updateComplete()
{
	this.isComplete();
}
  public boolean isComplete()
  {
	Vector selection = _list.getSelectedAgents();
	return ((selection.size() != 0) && _validPort);
  }  
/**
 * Sent when the text is modified.
 *
 * @param e an event containing information about the modify
 */
public void modifyText(ModifyEvent e)
{
	setPageComplete(isComplete());
}
/**
 * Insert the method's description here.
 * Creation date: (10/31/2000 4:01:27 PM)
 * @return java.lang.String
 */
public String pageDetails()
{
	String text="\n"+UIPlugin.getResourceString("AGENT_TXT")+":\n";

	Vector processes = _list.getTargetItems();

	if(processes.size() == 0)
	{
		text+= "\n"+UIPlugin.getResourceString("NO_AGENT");     
	}
	else
	{
		for(int idx=0; idx<processes.size(); idx++)
		{
			TreeItem item = (TreeItem)processes.elementAt(idx);     
						   
			TreeItem[] items = item.getItems();
			for(int i=0; i<items.length; i++)
			{
				TreeItem aitem = (TreeItem)items[i];                                                    
				text+="\t"+aitem.getText()+"( "+item.getText()+" )"+"\n";
			}

			text+="\n";
		}
	}

	return text;
}
/**
*
*/
public void run(IProgressMonitor mon)
{
   if(!isPageComplete())
	 return;
	/* get agent selected from the target tree */
	
	org.eclipse.swt.custom.BusyIndicator.showWhile(null, new Runnable() {
	public void run() {
		Vector aList=_list.getSelectedAgents();
	
		setProfileOptions(aList);
	
		PDCoreUtil.attach(((AttachLocalWizard)getWizard()).getNodeSelected()
					 , aList, _selectedProject, _selectedMonitor, 
					 String.valueOf(((AttachLocalWizard)getWizard()).getPortSelection()), _profileFile);
	}
	});
}
/**
 * Insert the method's description here.
 * Creation date: (8/30/2001 9:16:55 PM)
 * @param processes java.util.Vector
 */
private void setProfileOptions(Vector agents)
{
	if(!((AttachLocalWizard)getWizard()).isProfilingEnabled())
	{
		return;
	}
	
	ArrayList filterSet = ((AttachLocalWizard)getWizard()).getFilterSet();
	ArrayList filters = new ArrayList();
	for(int idx=0; idx<filterSet.size(); idx++)
	{
		FilterSetElement elems = (FilterSetElement)filterSet.get(idx);
		if(elems.getEnabled())
		{
			UIPlugin.getDefault().getPluginPreferences().setValue(TraceConstants.ACTIVE_FILTER_NAME, elems.getName());
			filters = elems.getChildren();
			break;
		}
	}
	
	Vector options = ((AttachLocalWizard)getWizard()).getOptions();
		
	for(int idx=0; idx< agents.size(); idx++)
	{
		Agent a = (Agent) agents.elementAt(idx);
		

		if(a.getType() != null && !a.getType().equals(TraceConstants.PROFILE_AGENT_TYPE)) {
			  continue;
		}

		AgentConfiguration config = a.getConfiguration();
		config.clear();
			

		//set options 
		for(int i=0; i<options.size(); i++) {
			config.addEntry((AgentConfigurationEntry)options.elementAt(i));
		}

		//set filters
		for(int i=0; i<filters.size(); i++)
		{
			FilterTableElement elem = (FilterTableElement)filters.get(i);
			AgentConfigurationEntry entry = new AgentConfigurationEntry();
			
			if(elem.getMethod().length()==0) 
			{
				entry.setName(elem.getText()); 
				entry.setType("SETFILTER");
			}
			else 
			{
				/* RKD:  The method filter criteria is specified by placing a space between the two strings */
				entry.setName(elem.getText()+' '+elem.getMethod()); 
				entry.setType("SETMETHODFILTER");	
			}
			entry.setValue(elem.getVisibility());
			entry.setEnabled(true);
			config.addEntry(entry);         
		}   
	} 
}

public void wizardPageSetVisible(boolean visible)
{
	super.setVisible(visible);
}

public void setVisible(boolean visible)
{
	super.setVisible(visible);


	if(visible)
			{

		org.eclipse.swt.custom.BusyIndicator.showWhile(null, new Runnable() {
		public void run() {
			
				String nodeName = ((AttachLocalWizard)getWizard()).getNodeName();
				try {
					  Node fnode = NodeFactory.createNode(nodeName);
					  nodeName = fnode.getInetAddress().getHostName();
				}
				catch(UnknownHostException exc)
				{         
				}
						
				String nodeSelected = ((AttachLocalWizard)getWizard()).getNodeSelected();
				try {
					  Node fnode = NodeFactory.createNode(nodeSelected);
					  nodeSelected = fnode.getInetAddress().getHostName();
				}
				catch(UnknownHostException exc)
				{         
				}			
			    int portSelected = ((AttachLocalWizard)getWizard()).getPortSelection();
				int status = HyadesUtil.testConnection(
					nodeSelected,String.valueOf(portSelected),false,getShell());
			
				if (status != HyadesUtil.CONNECTION_SUCCESS)
				{
					((AttachLocalWizard)getWizard()).setNodeSelection(((AttachLocalWizard)getWizard()).getNodeSelected());
					((AttachLocalWizard)getWizard()).setPortSelection(((AttachLocalWizard)getWizard()).getPortSelection());
					
					_list.initialize(null, fShowAll); 
					
					_validPort = false;
					setPageComplete(_validPort);
					
				}
				else
				{
					_validPort = true;
					if(!_initialized || !nodeName.equals(nodeSelected))
					{
						_list.initialize(getNodeConfiguration(), fShowAll); 
						_initialized = true;
		
						setPageComplete(isComplete());
					}
				}
			}
		});
	}
	
  }
  
public Button getRefreshButton()
{
	return _refresh;
}
  
public void widgetDefaultSelected(SelectionEvent e)
{
	setPageComplete(isComplete());
}
public void widgetSelected(SelectionEvent e)
{
	if(e.widget == _refresh)
	{
	   initialize();        
	}
	/*else if(e.widget == _showProcess)
	{
	   fShowAll = _showProcess.getSelection();
	   initialize();
	}*/

	setPageComplete(isComplete());
	
}
}
