/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.trace.ui.internal.wizard;

import java.util.ArrayList;

import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.EList;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.trace.ui.*;
import org.eclipse.hyades.trace.ui.internal.core.*;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

/*
* CONTEXT_ID opwp0000 for open process wizard page
*/

public class OpenProcessWizardPage  extends WizardPage
									implements ModifyListener
{
  private TraceProcessUI _processUI;
  private boolean _refresh=false;

  public OpenProcessWizardPage(String name)
  {
	super(name);
	setTitle(UIPlugin.getResourceString("OPENPROCESSWIZARDPAGE_PROCESS_PROPERTY"));
	setDescription(UIPlugin.getResourceString("OPENPROCESSWIZARDPAGE_PROCESS_DESC"));
  }
  public void createControl(Composite parent)
  {
	_processUI = new TraceProcessUI();
	Control content = _processUI.createControl(parent);

	_processUI.getLocationUI().setEnabled(false);		
	_processUI.getLaunchProcessUI().enable(false, true, false, false, false);
		
	_processUI.getLaunchProcessUI().getClassUI().setFocus();
	_processUI.getLaunchProcessUI().getClassUI().setEnabled(false);
	_processUI.getLaunchProcessUI().getParametersUI().setEditable(false);
	_processUI.getLaunchProcessUI().getClassPathUI().setEditable(false);
	_processUI.getLaunchProcessUI().getVMArgsUI().setEditable(false);
	_processUI.getProcessIdUI().setEnabled(false);
	_processUI.getNodeNameUI().setEnabled(false);
	_processUI.getLaunchProcessUI().getClassUI().addModifyListener(this);
	
	initData();
	
	setControl(content);

	org.eclipse.ui.help.WorkbenchHelp.setHelp(
		parent,
	UIPlugin.getPluginId()+".opwp0000");
  }
  public boolean finish()
  {
	TRCProcessProxy process = ((OpenProcessWizard)getWizard()).getProcess();

	if(process == null)
	  return false;
	
	process.setClasspath(_processUI.getLaunchProcessUI().getClassPath());
	process.setName(_processUI.getLaunchProcessUI().getClassName());

	String params = _processUI.getLaunchProcessUI().getParametersUI().getText().trim();
	String vmArgs = _processUI.getLaunchProcessUI().getVMArgs();
	
	process.setParameters(params);
	process.setVmArguments(vmArgs);	
 
 	if (_refresh)
	   	UIPlugin.getDefault().getViewer().getViewer().refresh();
	 
	return(true);
	
  }
/**
 * Insert the method's description here.
 * Creation date: (5/7/2001 12:30:07 PM)
 */
private void initData()
{	
	TRCProcessProxy process = ((OpenProcessWizard)getWizard()).getProcess();

	IResource sel = ((OpenProcessWizard)getWizard()).getViewer().getSelectionFolder();
	if(sel != null)
	   _processUI.getLocationUI().setLocation(sel.getFullPath().toOSString());

	_processUI.getLocationUI().setMonitor(process.getNode().getMonitor().getName());
	
	String name = process.getName();
	if(name != null)
	{
		_processUI.getLaunchProcessUI().getClassUI().setText(name);
		if (process.getLaunchMode()!=1)
		{
			_processUI.getLaunchProcessUI().getClassUI().setEnabled(true);
			_refresh=true;
		}
	}
	_processUI.getProcessIdUI().setText(String.valueOf(process.getPid()));
	_processUI.getNodeNameUI().setText(process.getNode().getName());

	if(process.getClasspath() != null)
		_processUI.getLaunchProcessUI().getClassPathUI().setText(process.getClasspath());
	if(process.getParameters() != null)
		_processUI.getLaunchProcessUI().getParametersUI().setText(process.getParameters());
	if(process.getVmArguments() != null)		
		_processUI.getLaunchProcessUI().getVMArgsUI().setText(process.getVmArguments());
	if(process.getEnvironmentVariables() != null)
		setEnvironment(_processUI.getLaunchProcessUI(),process);
}
/**
 * Sent when the text is modified.
 *
 * @param e an event containing information about the modify
 */
public void modifyText(ModifyEvent e)
{
	setPageComplete(!_processUI.getLaunchProcessUI().getClassUI().getText().trim().equals(""));
}

public void setEnvironment(LaunchProcessUI processUI, TRCProcessProxy process)
{
	ArrayList envData = new ArrayList();
	
	EList environments = process.getEnvironmentVariables();
	for (int i=0;i<environments.size();i++)
	{
		TRCEnvironmentVariable env = (TRCEnvironmentVariable)(environments.get(i));
		EnvTableElement envTblElement = new EnvTableElement(env.getName(),env.getValue());
		envData.add(envTblElement);
	}

	processUI.setEnvData(envData);
}
}
