package org.eclipse.hyades.logging.parsers;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.hyades.internal.logging.core.Constants;

public final class ParserUtilities {

	private static ResourceBundle resourceBundle = null;

	public static String getResourceString(String key) {

		//Load ResourceBundle:
		if (resourceBundle == null) {

			//Workbench ResourceBundle:
			try {
				resourceBundle = LoggingParsersPlugin.getResourceBundle();
			}
			catch (Throwable e) {
			}

			//logutil.jar ResourceBundle:
			if (resourceBundle == null) {
				try {
					resourceBundle = ResourceBundle.getBundle("org.eclipse.hyades.logging.parsers.properties.plugin", Locale.getDefault());
				}
				catch (MissingResourceException m) {
					return key;
				}
			}
		}

		try {
			return (resourceBundle.getString(key.trim()).trim());
		}
		catch (Exception e) {
		}

		return key;
	}

	public static String getResourceString(String key, String argument) {
		return (getResourceString(key, new String[] { argument }));
	}

	public static String getResourceString(String key, String argumentA, String argumentB) {
		return (getResourceString(key, new String[] { argumentA, argumentB }));
	}

	public static String getResourceString(String key, String argumentA, String argumentB, String argumentC) {
		return (getResourceString(key, new String[] { argumentA, argumentB, argumentC }));
	}

	public static String getResourceString(String key, String[] arguments) {
		try {
			return (MessageFormat.format(getResourceString(key), arguments));
		}
		catch (Exception e) {
			return key;
		}
	}
    
    
	/**
	 * Displays a detailed error message in the case of an exception while parsing
	 * a log file.  The error message dispalys the number and the content of the faulty
	 * line number as well as additional messages indicating as to why the exception 
	 * occurred.
	 * 
	 * @param 	throwable		- The throwable that occurred while parsing the file
	 * 			faultyLineNum	- The faulty line number causing the exception
	 * 			faultyLine		- The content of the faulty line causing the exception
	 * 			message			- A generic message printed to indicated the log parser being used
	 * 
	 * @throws	LogParserException	- Used for displaying the error message
	 */
	public static void exceptionHandler (Throwable throwable, long faultyLineNum, String faultyLine, String message) throws LogParserException
	{
		StringBuffer finalMsg = new StringBuffer(ParserUtilities.getResourceString("INVALID_LINE_NUMBER_ERROR_", String.valueOf(faultyLineNum)));
		String lineSep = Constants.LINE_SEPARATOR;
		finalMsg.append(':').append(lineSep).append(lineSep).append(faultyLine).append(lineSep);
		String errorMsg = null;
			
		if (throwable != null)
			errorMsg = throwable.getMessage();      			
		if (errorMsg != null && errorMsg.length() > 0)
			finalMsg.append(errorMsg).append(lineSep);
			
		finalMsg.append(message);
        		        	
		LogParserException lpe = new LogParserException(finalMsg.toString(), throwable);
		lpe.fillInStackTrace();
		throw lpe;
	}
    
    
    
	public static void exceptionHandler (Throwable throwable, String message) throws LogParserException
	{
		String lineSep = Constants.LINE_SEPARATOR;
		StringBuffer finalMsg = new StringBuffer(); 		
			
		if (throwable != null && throwable.getMessage() != null && throwable.getMessage().length() > 0)
			finalMsg.append(throwable.getMessage()).append(lineSep);
			
		finalMsg.append(message);
        		        	
		LogParserException lpe = new LogParserException(finalMsg.toString(), throwable);
		lpe.fillInStackTrace();
		throw lpe;
	}

}
