/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.event;

import org.eclipse.hyades.test.common.util.XMLUtil;

/**
 * This is a flat class packaged in the execution environment and
 * it mirrors the org.eclipse.hyades.models.common.testprofile.TPFExecutionEvent
 * 
 * @author kobylin
 * @author marcelop
 */
public class ExecutionEvent
{
	public final static int NOT_INITIALIZED_VALUE = -100;
	
	private String id;
	private String ownerId;
	private long timestamp;
	private String text;

	/**
	 * Returns the id of this event.
	 * @return String
	 */
	public String getId()
	{
		return id;
	}

	/**
	 * Sets the id of this event.
	 * @param value
	 */
	public void setId(String value)
	{
		id = value;
	}

	/**
	 * Returns the owner id of this event.
	 * @return String
	 */
	public String getOwnerId()
	{
		return ownerId;
	}

	/**
	 * Sets the owner id of this event.
	 * @param value
	 */
	public void setOwnerId(String value)
	{
		ownerId = value;
	}

	/**
	 * Returns the timestamp of this event.
	 * @return String
	 */
	public long getTimestamp()
	{
		return timestamp;
	}

	/**
	 * Sets the timestamp of this event.  The timestamp
	 * is set by the {@link #toString()} method if this
	 * {@link #getTimestamp()} returns 0.
	 * @param value
	 */
	public void setTimestamp(long value)
	{
		timestamp = value;
	}

	/**
	 * Returns the text of this event.
	 * @return String
	 */
	public String getText()
	{
		return text;
	}

	/**
	 * Sets the text of this event.
	 * @return String
	 */
	public void setText(String value)
	{
		text = value;
	}
	
	/**
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		sb.append("<").append(getXMLRoot());
		addXMLAttributes(sb);
		sb.append("/>");
		return sb.toString();
	}
	
	/**
	 * Returns the string that is used as the root of the
	 * xml fragment generated by the {@link #toString()} method.
	 * @return a not <code>null</code> String
	 */
	protected String getXMLRoot()
	{
		return "executionEvent";
	}
	
	/**
	 * Add the attributes to the xml <code>StringBuffer</code> that
	 * is used by the {@link #toString()} method. 
	 * @param xml
	 */
	protected void addXMLAttributes(StringBuffer xml)
	{
		xml.append(XMLUtil.createXMLAttribute("id", getId(), false));
		xml.append(XMLUtil.createXMLAttribute("ownerId", getOwnerId(), false));
		xml.append(XMLUtil.createXMLAttribute("text", getText(), false));
		
		long ts = getTimestamp();
		if(ts == 0)
			ts = System.currentTimeMillis();
		xml.append(XMLUtil.createXMLAttribute("timestamp", Long.toString(ts), false));
	}
}
