/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.event;

import org.eclipse.hyades.test.common.util.XMLUtil;

/**
 * This is a flat class packaged in the execution environment and
 * it mirrors the 
 * {@link org.eclipse.hyades.models.common.testprofile.TPFInvocationEvent}.
 * 
 * @author kobylin
 * @author marcelop
 */
public class InvocationEvent 
extends ExecutionEvent
{
	public static final int STATUS_UNATTEMPTED = 0;
	public static final int STATUS_SUCCESSFUL = 1;
	public static final int STATUS_UNSUCCESSFUL = 2;

	public static final int REASON_UNKNOWN = 0;
	public static final int REASON_NONE = 1;
	public static final int REASON_SEE_DESCRIPTION = 2;
	public static final int REASON_PRECONDITION_NOT_MET = 3;
	public static final int REASON_NO_MATCHING_CONFIGURATION = 4;
	public static final int REASON_NO_BEHAVIOR = 5;
	public static final int REASON_DID_NOT_START = 6;

	private int status = NOT_INITIALIZED_VALUE;
	private int reason = NOT_INITIALIZED_VALUE;
	private String invokedId;
	
	/**
	 * Sets the status of this event.
	 * @param value
	 */
	public void setStatus(int value)
	{
		status = value;
	}

	/**
	 * Returns the status of this event.
	 * @return int
	 */
	public int getStatus()
	{
		return status;
	}


	/**
	 * Sets the reason for the status of this event.
	 * @param value
	 */
	public void setReason(int value)
	{
		reason = value;
	}

	/**
	 * Returns the reason for the status of this event.
	 * @return int
	 */
	public int getReason()
	{
		return reason;
	}

	/**
	 * Sets the id of the invoked element.
	 * @param value
	 */
	public void setInvokedId(String value)
	{
		invokedId = value;
	}

	/**
	 * Returns the id of the invoked element.
	 * @return String
	 */
	public String getInvokedId()
	{
		return invokedId;
	}

	/**
	 * @see org.eclipse.hyades.test.java.event.ExecutionEvent#getXMLRoot()
	 */
	protected String getXMLRoot()
	{
		return "invocationEvent";
	}

	/**
	 * @see org.eclipse.hyades.test.java.event.ExecutionEvent#addXMLAttributes(java.lang.StringBuffer)
	 */
	protected void addXMLAttributes(StringBuffer xml)
	{
		super.addXMLAttributes(xml);
		
		if(getStatus() != NOT_INITIALIZED_VALUE)
			xml.append(XMLUtil.createXMLAttribute("status", Integer.toString(getStatus()), false));
		if(getReason() != NOT_INITIALIZED_VALUE)
			xml.append(XMLUtil.createXMLAttribute("reason", Integer.toString(getReason()), false));
		xml.append(XMLUtil.createXMLAttribute("invokedId", getInvokedId(), false));
	}
}
