/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.test.common.junit;

import java.util.Collection;

import junit.framework.TestSuite;

import org.eclipse.hyades.test.common.event.VerdictEvent;

/**
 * Default implementation of the 
 * {@link org.eclipse.hyades.test.java.junit.IHyadesTestArbiter}.
 * 
 * @author marcelop
 * @since 1.0.1
 */
public class DefaultTestArbiter 
implements IHyadesTestArbiter
{
	public final static DefaultTestArbiter INSTANCE = new DefaultTestArbiter();
	
	/**
	 * @see org.eclipse.hyades.test.java.junit.IHyadesTestArbiter#analyse(junit.framework.TestSuite, java.util.Collection, java.util.Collection, java.util.Collection)
	 */
	public VerdictEvent analyse(TestSuite testSuite, Collection successes, Collection errors, Collection failures)
	{
		VerdictEvent verdictEvent = new VerdictEvent();
		verdictEvent.setOwnerId(HyadesTestUtil.getHierarchyIds(testSuite));

		if(!errors.isEmpty())
			verdictEvent.setVerdict(VerdictEvent.VERDICT_ERROR);
		else if(!failures.isEmpty())
			verdictEvent.setVerdict(VerdictEvent.VERDICT_FAIL);
		else
			verdictEvent.setVerdict(VerdictEvent.VERDICT_PASS);
		
		return verdictEvent;
	}
}
