/*******************************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.hyades.test.ui.internal.wizard;

import org.eclipse.ui.model.IWorkbenchAdapter;

import org.eclipse.hyades.models.common.testprofile.Common_TestprofileFactory;
import org.eclipse.hyades.models.common.testprofile.TPFBehavior;
import org.eclipse.hyades.models.common.testprofile.TPFTestCase;
import org.eclipse.hyades.models.common.testprofile.TPFTestSuite;
import org.eclipse.hyades.test.ui.TestUIExtension;
import org.eclipse.hyades.test.ui.TestUIPlugin;
import org.eclipse.hyades.test.ui.wizard.INewTestCaseWizard;
import org.eclipse.hyades.ui.internal.wizard.AttributeWizardPage;
import org.eclipse.hyades.ui.internal.wizard.HyadesWizard;

/**
 * Wizard for the Hyades Generic Test Case
 * @author marcelop
 * @since 0.2.0
 */
public class TestCaseNewWizard
extends HyadesWizard implements INewTestCaseWizard
{
	private AttributeWizardPage attributeWizardPage;
	
	/**
	 * Constructor for TestCaseNewWizard
	 */
	public TestCaseNewWizard()
	{
		super();

		setWindowTitle(TestUIPlugin.getString("WIZ_TST_CASE_TTL"));
	}

	/**
	 * Returns the type for the test case created by this wizard.
	 * @return String
	 */
	protected String getType()
	{
		return TestUIExtension.GENERIC_TEST_CASE_TYPE;
	}
	
	/**
	 * Returns the "name and description page" used by this wizard.
	 * @return NameDescriptionWizardPage
	 */
	protected AttributeWizardPage getAttributeWizardPage()
	{
		return attributeWizardPage;
	}
	
	/**
	 * @see org.eclipse.hyades.ui.internal.wizard.HyadesWizard#initPages()
	 */
	protected void initPages()
	{
		attributeWizardPage = new AttributeWizardPage("nameDescription");
	}
	
	/**
	 * @see org.eclipse.jface.wizard.IWizard#addPages()
	 */
	public void addPages()
	{
		TPFTestSuite testSuite = (TPFTestSuite)getSelection().getFirstElement();
		String label = ((IWorkbenchAdapter)testSuite.getAdapter(IWorkbenchAdapter.class)).getLabel(testSuite);

		getAttributeWizardPage().setTitle(TestUIPlugin.getString("WIZ_TST_CASE_GEN_PG_TTL"));
		getAttributeWizardPage().setDescription(TestUIPlugin.getString("WIZ_TST_CASE_GEN_PG_ATT_DSC", label));
		addPage(getAttributeWizardPage());
	}

	/**
	 * @see org.eclipse.jface.wizard.IWizard#performFinish()
	 */
	public boolean performFinish()
	{
		TPFTestCase testCase = Common_TestprofileFactory.eINSTANCE.createTPFTestCase();
		testCase.setName(getAttributeWizardPage().getItemName());
		testCase.setDescription(getAttributeWizardPage().getItemDescription());
		testCase.setType(getType());
		
		if(testCase.getBehavior() == null)
		{
			TPFBehavior behavior = Common_TestprofileFactory.eINSTANCE.createTPFBehavior();
			testCase.setBehavior(behavior);
		} 
		
		TPFTestSuite testSuite = (TPFTestSuite)getSelection().getFirstElement();
		testSuite.getTestCases().add(testCase);
		
		return true;
	}
}
