/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.hyades.models.hierarchy.HierarchyFactory
 * @generated
 */
public interface HierarchyPackage extends EPackage{
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "hierarchy";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.eclipse.org/hyades/models/hierarchy.xmi";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "Hierarchy";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	HierarchyPackage eINSTANCE = org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.impl.TRCProcessProxyImpl <em>TRC Process Proxy</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.impl.TRCProcessProxyImpl
	 * @see org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl#getTRCProcessProxy()
	 * @generated
	 */
	int TRC_PROCESS_PROXY = 0;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS_PROXY__NAME = 0;

	/**
	 * The feature id for the '<em><b>Runtime Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS_PROXY__RUNTIME_ID = 1;

	/**
	 * The feature id for the '<em><b>Pid</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS_PROXY__PID = 2;

	/**
	 * The feature id for the '<em><b>Classpath</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS_PROXY__CLASSPATH = 3;

	/**
	 * The feature id for the '<em><b>Parameters</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS_PROXY__PARAMETERS = 4;

	/**
	 * The feature id for the '<em><b>Launch Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS_PROXY__LAUNCH_MODE = 5;

	/**
	 * The feature id for the '<em><b>Location</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS_PROXY__LOCATION = 6;

	/**
	 * The feature id for the '<em><b>Vm Arguments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS_PROXY__VM_ARGUMENTS = 7;

	/**
	 * The feature id for the '<em><b>Active</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS_PROXY__ACTIVE = 8;

	/**
	 * The feature id for the '<em><b>Exec Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS_PROXY__EXEC_PARAMETERS = 9;

	/**
	 * The feature id for the '<em><b>Environment Variables</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS_PROXY__ENVIRONMENT_VARIABLES = 10;

	/**
	 * The feature id for the '<em><b>Node</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS_PROXY__NODE = 11;

	/**
	 * The feature id for the '<em><b>Agent Proxies</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS_PROXY__AGENT_PROXIES = 12;

	/**
	 * The number of structural features of the the '<em>TRC Process Proxy</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_PROCESS_PROXY_FEATURE_COUNT = 13;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.impl.TRCOptionImpl <em>TRC Option</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.impl.TRCOptionImpl
	 * @see org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl#getTRCOption()
	 * @generated
	 */
	int TRC_OPTION = 1;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OPTION__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OPTION__VALUE = 1;

	/**
	 * The feature id for the '<em><b>Configuration</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OPTION__CONFIGURATION = 2;

	/**
	 * The number of structural features of the the '<em>TRC Option</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_OPTION_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentImpl <em>TRC Agent</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.impl.TRCAgentImpl
	 * @see org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl#getTRCAgent()
	 * @generated
	 */
	int TRC_AGENT = 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT__NAME = 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT__TYPE = 1;

	/**
	 * The feature id for the '<em><b>Runtime Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT__RUNTIME_ID = 2;

	/**
	 * The feature id for the '<em><b>Start Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT__START_TIME = 3;

	/**
	 * The feature id for the '<em><b>Stop Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT__STOP_TIME = 4;

	/**
	 * The feature id for the '<em><b>Collection Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT__COLLECTION_MODE = 5;

	/**
	 * The feature id for the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT__VERSION = 6;

	/**
	 * The feature id for the '<em><b>Default Events</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT__DEFAULT_EVENTS = 7;

	/**
	 * The feature id for the '<em><b>View</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT__VIEW = 8;

	/**
	 * The feature id for the '<em><b>Descriptor</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT__DESCRIPTOR = 9;

	/**
	 * The feature id for the '<em><b>Process</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT__PROCESS = 10;

	/**
	 * The feature id for the '<em><b>Agent Proxy</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT__AGENT_PROXY = 11;

	/**
	 * The feature id for the '<em><b>Unresolved Correlations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT__UNRESOLVED_CORRELATIONS = 12;

	/**
	 * The number of structural features of the the '<em>TRC Agent</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT_FEATURE_COUNT = 13;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.impl.TRCAgentProxyImpl <em>TRC Agent Proxy</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.impl.TRCAgentProxyImpl
	 * @see org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl#getTRCAgentProxy()
	 * @generated
	 */
	int TRC_AGENT_PROXY = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT_PROXY__NAME = 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT_PROXY__TYPE = 1;

	/**
	 * The feature id for the '<em><b>Runtime Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT_PROXY__RUNTIME_ID = 2;

	/**
	 * The feature id for the '<em><b>Start Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT_PROXY__START_TIME = 3;

	/**
	 * The feature id for the '<em><b>Stop Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT_PROXY__STOP_TIME = 4;

	/**
	 * The feature id for the '<em><b>Collection Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT_PROXY__COLLECTION_MODE = 5;

	/**
	 * The feature id for the '<em><b>Active</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT_PROXY__ACTIVE = 6;

	/**
	 * The feature id for the '<em><b>Attached</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT_PROXY__ATTACHED = 7;

	/**
	 * The feature id for the '<em><b>Collection Data</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT_PROXY__COLLECTION_DATA = 8;

	/**
	 * The feature id for the '<em><b>Monitored</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT_PROXY__MONITORED = 9;

	/**
	 * The feature id for the '<em><b>Profile File</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT_PROXY__PROFILE_FILE = 10;

	/**
	 * The feature id for the '<em><b>Process Proxy</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT_PROXY__PROCESS_PROXY = 11;

	/**
	 * The feature id for the '<em><b>Configurations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT_PROXY__CONFIGURATIONS = 12;

	/**
	 * The feature id for the '<em><b>Agent</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT_PROXY__AGENT = 13;

	/**
	 * The number of structural features of the the '<em>TRC Agent Proxy</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_AGENT_PROXY_FEATURE_COUNT = 14;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.impl.TRCConfigurationImpl <em>TRC Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.impl.TRCConfigurationImpl
	 * @see org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl#getTRCConfiguration()
	 * @generated
	 */
	int TRC_CONFIGURATION = 4;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CONFIGURATION__NAME = 0;

	/**
	 * The feature id for the '<em><b>Active</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CONFIGURATION__ACTIVE = 1;

	/**
	 * The feature id for the '<em><b>Options</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CONFIGURATION__OPTIONS = 2;

	/**
	 * The feature id for the '<em><b>Filters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CONFIGURATION__FILTERS = 3;

	/**
	 * The feature id for the '<em><b>Agent Proxy</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CONFIGURATION__AGENT_PROXY = 4;

	/**
	 * The number of structural features of the the '<em>TRC Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_CONFIGURATION_FEATURE_COUNT = 5;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.impl.TRCEnvironmentVariableImpl <em>TRC Environment Variable</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.impl.TRCEnvironmentVariableImpl
	 * @see org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl#getTRCEnvironmentVariable()
	 * @generated
	 */
	int TRC_ENVIRONMENT_VARIABLE = 5;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ENVIRONMENT_VARIABLE__NAME = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ENVIRONMENT_VARIABLE__VALUE = 1;

	/**
	 * The feature id for the '<em><b>Process Proxy</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ENVIRONMENT_VARIABLE__PROCESS_PROXY = 2;

	/**
	 * The number of structural features of the the '<em>TRC Environment Variable</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_ENVIRONMENT_VARIABLE_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.impl.TRCExecParameterImpl <em>TRC Exec Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.impl.TRCExecParameterImpl
	 * @see org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl#getTRCExecParameter()
	 * @generated
	 */
	int TRC_EXEC_PARAMETER = 6;

	/**
	 * The feature id for the '<em><b>Key</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_EXEC_PARAMETER__KEY = 0;

	/**
	 * The feature id for the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_EXEC_PARAMETER__VALUE = 1;

	/**
	 * The feature id for the '<em><b>Process Proxy</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_EXEC_PARAMETER__PROCESS_PROXY = 2;

	/**
	 * The number of structural features of the the '<em>TRC Exec Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_EXEC_PARAMETER_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.impl.TRCFilterImpl <em>TRC Filter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.impl.TRCFilterImpl
	 * @see org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl#getTRCFilter()
	 * @generated
	 */
	int TRC_FILTER = 7;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FILTER__TYPE = 0;

	/**
	 * The feature id for the '<em><b>Pattern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FILTER__PATTERN = 1;

	/**
	 * The feature id for the '<em><b>Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FILTER__MODE = 2;

	/**
	 * The feature id for the '<em><b>Active</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FILTER__ACTIVE = 3;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FILTER__OPERATION = 4;

	/**
	 * The feature id for the '<em><b>Configuration</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FILTER__CONFIGURATION = 5;

	/**
	 * The number of structural features of the the '<em>TRC Filter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_FILTER_FEATURE_COUNT = 6;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.impl.TRCNodeImpl <em>TRC Node</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.impl.TRCNodeImpl
	 * @see org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl#getTRCNode()
	 * @generated
	 */
	int TRC_NODE = 8;

	/**
	 * The feature id for the '<em><b>Runtime Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_NODE__RUNTIME_ID = 0;

	/**
	 * The feature id for the '<em><b>Timezone</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_NODE__TIMEZONE = 1;

	/**
	 * The feature id for the '<em><b>Port</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_NODE__PORT = 2;

	/**
	 * The feature id for the '<em><b>Delta Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_NODE__DELTA_TIME = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_NODE__NAME = 4;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_NODE__DESCRIPTION = 5;

	/**
	 * The feature id for the '<em><b>Ip Address</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_NODE__IP_ADDRESS = 6;

	/**
	 * The feature id for the '<em><b>Monitor</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_NODE__MONITOR = 7;

	/**
	 * The feature id for the '<em><b>Process Proxies</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_NODE__PROCESS_PROXIES = 8;

	/**
	 * The number of structural features of the the '<em>TRC Node</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_NODE_FEATURE_COUNT = 9;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.impl.TRCMonitorImpl <em>TRC Monitor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.impl.TRCMonitorImpl
	 * @see org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl#getTRCMonitor()
	 * @generated
	 */
	int TRC_MONITOR = 9;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_MONITOR__NAME = 0;

	/**
	 * The feature id for the '<em><b>Start Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_MONITOR__START_TIME = 1;

	/**
	 * The feature id for the '<em><b>Stop Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_MONITOR__STOP_TIME = 2;

	/**
	 * The feature id for the '<em><b>Nodes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_MONITOR__NODES = 3;

	/**
	 * The number of structural features of the the '<em>TRC Monitor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TRC_MONITOR_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.impl.AbstractDefaultEventImpl <em>Abstract Default Event</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.impl.AbstractDefaultEventImpl
	 * @see org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl#getAbstractDefaultEvent()
	 * @generated
	 */
	int ABSTRACT_DEFAULT_EVENT = 10;

	/**
	 * The feature id for the '<em><b>Agent</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DEFAULT_EVENT__AGENT = 0;

	/**
	 * The number of structural features of the the '<em>Abstract Default Event</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_DEFAULT_EVENT_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.impl.AbstractTRCViewImpl <em>Abstract TRC View</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.impl.AbstractTRCViewImpl
	 * @see org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl#getAbstractTRCView()
	 * @generated
	 */
	int ABSTRACT_TRC_VIEW = 11;

	/**
	 * The feature id for the '<em><b>Agent</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TRC_VIEW__AGENT = 0;

	/**
	 * The number of structural features of the the '<em>Abstract TRC View</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TRC_VIEW_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.impl.AbstractTRCDescriptionImpl <em>Abstract TRC Description</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.impl.AbstractTRCDescriptionImpl
	 * @see org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl#getAbstractTRCDescription()
	 * @generated
	 */
	int ABSTRACT_TRC_DESCRIPTION = 12;

	/**
	 * The feature id for the '<em><b>Agent</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TRC_DESCRIPTION__AGENT = 0;

	/**
	 * The number of structural features of the the '<em>Abstract TRC Description</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TRC_DESCRIPTION_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.impl.AbstractTRCProcessImpl <em>Abstract TRC Process</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.impl.AbstractTRCProcessImpl
	 * @see org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl#getAbstractTRCProcess()
	 * @generated
	 */
	int ABSTRACT_TRC_PROCESS = 13;

	/**
	 * The feature id for the '<em><b>Agent</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TRC_PROCESS__AGENT = 0;

	/**
	 * The number of structural features of the the '<em>Abstract TRC Process</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TRC_PROCESS_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.impl.AbstractTRCCollectionBoundaryImpl <em>Abstract TRC Collection Boundary</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.impl.AbstractTRCCollectionBoundaryImpl
	 * @see org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl#getAbstractTRCCollectionBoundary()
	 * @generated
	 */
	int ABSTRACT_TRC_COLLECTION_BOUNDARY = 14;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TRC_COLLECTION_BOUNDARY__NAME = 0;

	/**
	 * The feature id for the '<em><b>Start Time</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TRC_COLLECTION_BOUNDARY__START_TIME = 1;

	/**
	 * The feature id for the '<em><b>Collection Mode</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TRC_COLLECTION_BOUNDARY__COLLECTION_MODE = 2;

	/**
	 * The feature id for the '<em><b>Configuration</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TRC_COLLECTION_BOUNDARY__CONFIGURATION = 3;

	/**
	 * The number of structural features of the the '<em>Abstract TRC Collection Boundary</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ABSTRACT_TRC_COLLECTION_BOUNDARY_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.impl.UnresolvedCorrelationImpl <em>Unresolved Correlation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.impl.UnresolvedCorrelationImpl
	 * @see org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl#getUnresolvedCorrelation()
	 * @generated
	 */
	int UNRESOLVED_CORRELATION = 15;

	/**
	 * The feature id for the '<em><b>Context Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNRESOLVED_CORRELATION__CONTEXT_ID = 0;

	/**
	 * The feature id for the '<em><b>Agent</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNRESOLVED_CORRELATION__AGENT = 1;

	/**
	 * The feature id for the '<em><b>Source Infos</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNRESOLVED_CORRELATION__SOURCE_INFOS = 2;

	/**
	 * The number of structural features of the the '<em>Unresolved Correlation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int UNRESOLVED_CORRELATION_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.impl.CorrelationSourceInfoImpl <em>Correlation Source Info</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.impl.CorrelationSourceInfoImpl
	 * @see org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl#getCorrelationSourceInfo()
	 * @generated
	 */
	int CORRELATION_SOURCE_INFO = 16;

	/**
	 * The feature id for the '<em><b>Owner</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_SOURCE_INFO__OWNER = 0;

	/**
	 * The feature id for the '<em><b>Reference</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_SOURCE_INFO__REFERENCE = 1;

	/**
	 * The feature id for the '<em><b>Target Info</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_SOURCE_INFO__TARGET_INFO = 2;

	/**
	 * The number of structural features of the the '<em>Correlation Source Info</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CORRELATION_SOURCE_INFO_FEATURE_COUNT = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.hyades.models.hierarchy.TRCCollectionMode <em>TRC Collection Mode</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.hyades.models.hierarchy.TRCCollectionMode
	 * @see org.eclipse.hyades.models.hierarchy.impl.HierarchyPackageImpl#getTRCCollectionMode()
	 * @generated
	 */
	int TRC_COLLECTION_MODE = 17;


	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy <em>TRC Process Proxy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Process Proxy</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCProcessProxy
	 * @generated
	 */
	EClass getTRCProcessProxy();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getName()
	 * @see #getTRCProcessProxy()
	 * @generated
	 */
	EAttribute getTRCProcessProxy_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getRuntimeId <em>Runtime Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Runtime Id</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getRuntimeId()
	 * @see #getTRCProcessProxy()
	 * @generated
	 */
	EAttribute getTRCProcessProxy_RuntimeId();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getPid <em>Pid</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Pid</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getPid()
	 * @see #getTRCProcessProxy()
	 * @generated
	 */
	EAttribute getTRCProcessProxy_Pid();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getClasspath <em>Classpath</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Classpath</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getClasspath()
	 * @see #getTRCProcessProxy()
	 * @generated
	 */
	EAttribute getTRCProcessProxy_Classpath();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getParameters <em>Parameters</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Parameters</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getParameters()
	 * @see #getTRCProcessProxy()
	 * @generated
	 */
	EAttribute getTRCProcessProxy_Parameters();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getLaunchMode <em>Launch Mode</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Launch Mode</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getLaunchMode()
	 * @see #getTRCProcessProxy()
	 * @generated
	 */
	EAttribute getTRCProcessProxy_LaunchMode();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getLocation <em>Location</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Location</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getLocation()
	 * @see #getTRCProcessProxy()
	 * @generated
	 */
	EAttribute getTRCProcessProxy_Location();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getVmArguments <em>Vm Arguments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Vm Arguments</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getVmArguments()
	 * @see #getTRCProcessProxy()
	 * @generated
	 */
	EAttribute getTRCProcessProxy_VmArguments();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#isActive <em>Active</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Active</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCProcessProxy#isActive()
	 * @see #getTRCProcessProxy()
	 * @generated
	 */
	EAttribute getTRCProcessProxy_Active();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getExecParameters <em>Exec Parameters</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Exec Parameters</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getExecParameters()
	 * @see #getTRCProcessProxy()
	 * @generated
	 */
	EReference getTRCProcessProxy_ExecParameters();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getEnvironmentVariables <em>Environment Variables</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Environment Variables</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getEnvironmentVariables()
	 * @see #getTRCProcessProxy()
	 * @generated
	 */
	EReference getTRCProcessProxy_EnvironmentVariables();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getNode <em>Node</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Node</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getNode()
	 * @see #getTRCProcessProxy()
	 * @generated
	 */
	EReference getTRCProcessProxy_Node();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getAgentProxies <em>Agent Proxies</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Agent Proxies</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCProcessProxy#getAgentProxies()
	 * @see #getTRCProcessProxy()
	 * @generated
	 */
	EReference getTRCProcessProxy_AgentProxies();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.TRCOption <em>TRC Option</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Option</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCOption
	 * @generated
	 */
	EClass getTRCOption();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCOption#getKey <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Key</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCOption#getKey()
	 * @see #getTRCOption()
	 * @generated
	 */
	EAttribute getTRCOption_Key();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCOption#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCOption#getValue()
	 * @see #getTRCOption()
	 * @generated
	 */
	EAttribute getTRCOption_Value();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.hierarchy.TRCOption#getConfiguration <em>Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Configuration</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCOption#getConfiguration()
	 * @see #getTRCOption()
	 * @generated
	 */
	EReference getTRCOption_Configuration();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.TRCAgent <em>TRC Agent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Agent</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgent
	 * @generated
	 */
	EClass getTRCAgent();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgent#getName()
	 * @see #getTRCAgent()
	 * @generated
	 */
	EAttribute getTRCAgent_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgent#getType()
	 * @see #getTRCAgent()
	 * @generated
	 */
	EAttribute getTRCAgent_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getRuntimeId <em>Runtime Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Runtime Id</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgent#getRuntimeId()
	 * @see #getTRCAgent()
	 * @generated
	 */
	EAttribute getTRCAgent_RuntimeId();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getStartTime <em>Start Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start Time</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgent#getStartTime()
	 * @see #getTRCAgent()
	 * @generated
	 */
	EAttribute getTRCAgent_StartTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getStopTime <em>Stop Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Stop Time</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgent#getStopTime()
	 * @see #getTRCAgent()
	 * @generated
	 */
	EAttribute getTRCAgent_StopTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getCollectionMode <em>Collection Mode</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Collection Mode</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgent#getCollectionMode()
	 * @see #getTRCAgent()
	 * @generated
	 */
	EAttribute getTRCAgent_CollectionMode();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getVersion <em>Version</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Version</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgent#getVersion()
	 * @see #getTRCAgent()
	 * @generated
	 */
	EAttribute getTRCAgent_Version();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getDefaultEvents <em>Default Events</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Default Events</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgent#getDefaultEvents()
	 * @see #getTRCAgent()
	 * @generated
	 */
	EReference getTRCAgent_DefaultEvents();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getView <em>View</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>View</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgent#getView()
	 * @see #getTRCAgent()
	 * @generated
	 */
	EReference getTRCAgent_View();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getDescriptor <em>Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Descriptor</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgent#getDescriptor()
	 * @see #getTRCAgent()
	 * @generated
	 */
	EReference getTRCAgent_Descriptor();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getProcess <em>Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Process</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgent#getProcess()
	 * @see #getTRCAgent()
	 * @generated
	 */
	EReference getTRCAgent_Process();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getAgentProxy <em>Agent Proxy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Agent Proxy</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgent#getAgentProxy()
	 * @see #getTRCAgent()
	 * @generated
	 */
	EReference getTRCAgent_AgentProxy();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.TRCAgent#getUnresolvedCorrelations <em>Unresolved Correlations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Unresolved Correlations</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgent#getUnresolvedCorrelations()
	 * @see #getTRCAgent()
	 * @generated
	 */
	EReference getTRCAgent_UnresolvedCorrelations();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy <em>TRC Agent Proxy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Agent Proxy</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgentProxy
	 * @generated
	 */
	EClass getTRCAgentProxy();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getName()
	 * @see #getTRCAgentProxy()
	 * @generated
	 */
	EAttribute getTRCAgentProxy_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getType()
	 * @see #getTRCAgentProxy()
	 * @generated
	 */
	EAttribute getTRCAgentProxy_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getRuntimeId <em>Runtime Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Runtime Id</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getRuntimeId()
	 * @see #getTRCAgentProxy()
	 * @generated
	 */
	EAttribute getTRCAgentProxy_RuntimeId();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getStartTime <em>Start Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start Time</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getStartTime()
	 * @see #getTRCAgentProxy()
	 * @generated
	 */
	EAttribute getTRCAgentProxy_StartTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getStopTime <em>Stop Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Stop Time</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getStopTime()
	 * @see #getTRCAgentProxy()
	 * @generated
	 */
	EAttribute getTRCAgentProxy_StopTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getCollectionMode <em>Collection Mode</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Collection Mode</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getCollectionMode()
	 * @see #getTRCAgentProxy()
	 * @generated
	 */
	EAttribute getTRCAgentProxy_CollectionMode();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#isActive <em>Active</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Active</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgentProxy#isActive()
	 * @see #getTRCAgentProxy()
	 * @generated
	 */
	EAttribute getTRCAgentProxy_Active();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#isAttached <em>Attached</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Attached</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgentProxy#isAttached()
	 * @see #getTRCAgentProxy()
	 * @generated
	 */
	EAttribute getTRCAgentProxy_Attached();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#isCollectionData <em>Collection Data</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Collection Data</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgentProxy#isCollectionData()
	 * @see #getTRCAgentProxy()
	 * @generated
	 */
	EAttribute getTRCAgentProxy_CollectionData();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#isMonitored <em>Monitored</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Monitored</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgentProxy#isMonitored()
	 * @see #getTRCAgentProxy()
	 * @generated
	 */
	EAttribute getTRCAgentProxy_Monitored();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getProfileFile <em>Profile File</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Profile File</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getProfileFile()
	 * @see #getTRCAgentProxy()
	 * @generated
	 */
	EAttribute getTRCAgentProxy_ProfileFile();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getProcessProxy <em>Process Proxy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Process Proxy</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getProcessProxy()
	 * @see #getTRCAgentProxy()
	 * @generated
	 */
	EReference getTRCAgentProxy_ProcessProxy();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getConfigurations <em>Configurations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Configurations</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getConfigurations()
	 * @see #getTRCAgentProxy()
	 * @generated
	 */
	EReference getTRCAgentProxy_Configurations();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getAgent <em>Agent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Agent</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCAgentProxy#getAgent()
	 * @see #getTRCAgentProxy()
	 * @generated
	 */
	EReference getTRCAgentProxy_Agent();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.TRCConfiguration <em>TRC Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Configuration</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCConfiguration
	 * @generated
	 */
	EClass getTRCConfiguration();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCConfiguration#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCConfiguration#getName()
	 * @see #getTRCConfiguration()
	 * @generated
	 */
	EAttribute getTRCConfiguration_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCConfiguration#isActive <em>Active</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Active</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCConfiguration#isActive()
	 * @see #getTRCConfiguration()
	 * @generated
	 */
	EAttribute getTRCConfiguration_Active();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.TRCConfiguration#getOptions <em>Options</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Options</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCConfiguration#getOptions()
	 * @see #getTRCConfiguration()
	 * @generated
	 */
	EReference getTRCConfiguration_Options();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.TRCConfiguration#getFilters <em>Filters</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Filters</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCConfiguration#getFilters()
	 * @see #getTRCConfiguration()
	 * @generated
	 */
	EReference getTRCConfiguration_Filters();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.hierarchy.TRCConfiguration#getAgentProxy <em>Agent Proxy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Agent Proxy</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCConfiguration#getAgentProxy()
	 * @see #getTRCConfiguration()
	 * @generated
	 */
	EReference getTRCConfiguration_AgentProxy();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable <em>TRC Environment Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Environment Variable</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable
	 * @generated
	 */
	EClass getTRCEnvironmentVariable();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable#getName()
	 * @see #getTRCEnvironmentVariable()
	 * @generated
	 */
	EAttribute getTRCEnvironmentVariable_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable#getValue()
	 * @see #getTRCEnvironmentVariable()
	 * @generated
	 */
	EAttribute getTRCEnvironmentVariable_Value();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable#getProcessProxy <em>Process Proxy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Process Proxy</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable#getProcessProxy()
	 * @see #getTRCEnvironmentVariable()
	 * @generated
	 */
	EReference getTRCEnvironmentVariable_ProcessProxy();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.TRCExecParameter <em>TRC Exec Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Exec Parameter</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCExecParameter
	 * @generated
	 */
	EClass getTRCExecParameter();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCExecParameter#getKey <em>Key</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Key</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCExecParameter#getKey()
	 * @see #getTRCExecParameter()
	 * @generated
	 */
	EAttribute getTRCExecParameter_Key();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCExecParameter#getValue <em>Value</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Value</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCExecParameter#getValue()
	 * @see #getTRCExecParameter()
	 * @generated
	 */
	EAttribute getTRCExecParameter_Value();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.hierarchy.TRCExecParameter#getProcessProxy <em>Process Proxy</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Process Proxy</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCExecParameter#getProcessProxy()
	 * @see #getTRCExecParameter()
	 * @generated
	 */
	EReference getTRCExecParameter_ProcessProxy();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.TRCFilter <em>TRC Filter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Filter</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCFilter
	 * @generated
	 */
	EClass getTRCFilter();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCFilter#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCFilter#getType()
	 * @see #getTRCFilter()
	 * @generated
	 */
	EAttribute getTRCFilter_Type();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCFilter#getPattern <em>Pattern</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Pattern</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCFilter#getPattern()
	 * @see #getTRCFilter()
	 * @generated
	 */
	EAttribute getTRCFilter_Pattern();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCFilter#getMode <em>Mode</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Mode</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCFilter#getMode()
	 * @see #getTRCFilter()
	 * @generated
	 */
	EAttribute getTRCFilter_Mode();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCFilter#getActive <em>Active</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Active</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCFilter#getActive()
	 * @see #getTRCFilter()
	 * @generated
	 */
	EAttribute getTRCFilter_Active();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCFilter#getOperation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Operation</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCFilter#getOperation()
	 * @see #getTRCFilter()
	 * @generated
	 */
	EAttribute getTRCFilter_Operation();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.hierarchy.TRCFilter#getConfiguration <em>Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Configuration</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCFilter#getConfiguration()
	 * @see #getTRCFilter()
	 * @generated
	 */
	EReference getTRCFilter_Configuration();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.TRCNode <em>TRC Node</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Node</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCNode
	 * @generated
	 */
	EClass getTRCNode();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCNode#getRuntimeId <em>Runtime Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Runtime Id</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCNode#getRuntimeId()
	 * @see #getTRCNode()
	 * @generated
	 */
	EAttribute getTRCNode_RuntimeId();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCNode#getTimezone <em>Timezone</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Timezone</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCNode#getTimezone()
	 * @see #getTRCNode()
	 * @generated
	 */
	EAttribute getTRCNode_Timezone();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCNode#getPort <em>Port</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Port</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCNode#getPort()
	 * @see #getTRCNode()
	 * @generated
	 */
	EAttribute getTRCNode_Port();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCNode#getDeltaTime <em>Delta Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Delta Time</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCNode#getDeltaTime()
	 * @see #getTRCNode()
	 * @generated
	 */
	EAttribute getTRCNode_DeltaTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCNode#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCNode#getName()
	 * @see #getTRCNode()
	 * @generated
	 */
	EAttribute getTRCNode_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCNode#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCNode#getDescription()
	 * @see #getTRCNode()
	 * @generated
	 */
	EAttribute getTRCNode_Description();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCNode#getIpAddress <em>Ip Address</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Ip Address</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCNode#getIpAddress()
	 * @see #getTRCNode()
	 * @generated
	 */
	EAttribute getTRCNode_IpAddress();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.hierarchy.TRCNode#getMonitor <em>Monitor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Monitor</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCNode#getMonitor()
	 * @see #getTRCNode()
	 * @generated
	 */
	EReference getTRCNode_Monitor();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.hierarchy.TRCNode#getProcessProxies <em>Process Proxies</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Process Proxies</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCNode#getProcessProxies()
	 * @see #getTRCNode()
	 * @generated
	 */
	EReference getTRCNode_ProcessProxies();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.TRCMonitor <em>TRC Monitor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TRC Monitor</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCMonitor
	 * @generated
	 */
	EClass getTRCMonitor();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCMonitor#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCMonitor#getName()
	 * @see #getTRCMonitor()
	 * @generated
	 */
	EAttribute getTRCMonitor_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCMonitor#getStartTime <em>Start Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start Time</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCMonitor#getStartTime()
	 * @see #getTRCMonitor()
	 * @generated
	 */
	EAttribute getTRCMonitor_StartTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.TRCMonitor#getStopTime <em>Stop Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Stop Time</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCMonitor#getStopTime()
	 * @see #getTRCMonitor()
	 * @generated
	 */
	EAttribute getTRCMonitor_StopTime();

	/**
	 * Returns the meta object for the reference list '{@link org.eclipse.hyades.models.hierarchy.TRCMonitor#getNodes <em>Nodes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Nodes</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCMonitor#getNodes()
	 * @see #getTRCMonitor()
	 * @generated
	 */
	EReference getTRCMonitor_Nodes();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent <em>Abstract Default Event</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract Default Event</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent
	 * @generated
	 */
	EClass getAbstractDefaultEvent();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent#getAgent <em>Agent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Agent</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent#getAgent()
	 * @see #getAbstractDefaultEvent()
	 * @generated
	 */
	EReference getAbstractDefaultEvent_Agent();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCView <em>Abstract TRC View</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract TRC View</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCView
	 * @generated
	 */
	EClass getAbstractTRCView();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCView#getAgent <em>Agent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Agent</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCView#getAgent()
	 * @see #getAbstractTRCView()
	 * @generated
	 */
	EReference getAbstractTRCView_Agent();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCDescription <em>Abstract TRC Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract TRC Description</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCDescription
	 * @generated
	 */
	EClass getAbstractTRCDescription();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCDescription#getAgent <em>Agent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Agent</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCDescription#getAgent()
	 * @see #getAbstractTRCDescription()
	 * @generated
	 */
	EReference getAbstractTRCDescription_Agent();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCProcess <em>Abstract TRC Process</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract TRC Process</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCProcess
	 * @generated
	 */
	EClass getAbstractTRCProcess();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCProcess#getAgent <em>Agent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Agent</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCProcess#getAgent()
	 * @see #getAbstractTRCProcess()
	 * @generated
	 */
	EReference getAbstractTRCProcess_Agent();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary <em>Abstract TRC Collection Boundary</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Abstract TRC Collection Boundary</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary
	 * @generated
	 */
	EClass getAbstractTRCCollectionBoundary();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary#getName()
	 * @see #getAbstractTRCCollectionBoundary()
	 * @generated
	 */
	EAttribute getAbstractTRCCollectionBoundary_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary#getStartTime <em>Start Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Start Time</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary#getStartTime()
	 * @see #getAbstractTRCCollectionBoundary()
	 * @generated
	 */
	EAttribute getAbstractTRCCollectionBoundary_StartTime();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary#getCollectionMode <em>Collection Mode</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Collection Mode</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary#getCollectionMode()
	 * @see #getAbstractTRCCollectionBoundary()
	 * @generated
	 */
	EAttribute getAbstractTRCCollectionBoundary_CollectionMode();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary#getConfiguration <em>Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Configuration</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary#getConfiguration()
	 * @see #getAbstractTRCCollectionBoundary()
	 * @generated
	 */
	EReference getAbstractTRCCollectionBoundary_Configuration();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation <em>Unresolved Correlation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Unresolved Correlation</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation
	 * @generated
	 */
	EClass getUnresolvedCorrelation();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation#getContextId <em>Context Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Context Id</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation#getContextId()
	 * @see #getUnresolvedCorrelation()
	 * @generated
	 */
	EAttribute getUnresolvedCorrelation_ContextId();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation#getAgent <em>Agent</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Agent</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation#getAgent()
	 * @see #getUnresolvedCorrelation()
	 * @generated
	 */
	EReference getUnresolvedCorrelation_Agent();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation#getSourceInfos <em>Source Infos</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Source Infos</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation#getSourceInfos()
	 * @see #getUnresolvedCorrelation()
	 * @generated
	 */
	EReference getUnresolvedCorrelation_SourceInfos();

	/**
	 * Returns the meta object for class '{@link org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo <em>Correlation Source Info</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Correlation Source Info</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo
	 * @generated
	 */
	EClass getCorrelationSourceInfo();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo#getOwner <em>Owner</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Owner</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo#getOwner()
	 * @see #getCorrelationSourceInfo()
	 * @generated
	 */
	EReference getCorrelationSourceInfo_Owner();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo#getReference <em>Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Reference</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo#getReference()
	 * @see #getCorrelationSourceInfo()
	 * @generated
	 */
	EReference getCorrelationSourceInfo_Reference();

	/**
	 * Returns the meta object for the container reference '{@link org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo#getTargetInfo <em>Target Info</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Target Info</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo#getTargetInfo()
	 * @see #getCorrelationSourceInfo()
	 * @generated
	 */
	EReference getCorrelationSourceInfo_TargetInfo();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.hyades.models.hierarchy.TRCCollectionMode <em>TRC Collection Mode</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>TRC Collection Mode</em>'.
	 * @see org.eclipse.hyades.models.hierarchy.TRCCollectionMode
	 * @generated
	 */
	EEnum getTRCCollectionMode();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	HierarchyFactory getHierarchyFactory();

} //HierarchyPackage
