/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.hyades.models.hierarchy.*;

import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable;
import org.eclipse.hyades.models.hierarchy.TRCExecParameter;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class HierarchyFactoryImpl extends EFactoryImpl implements HierarchyFactory {
	/**
	 * Creates and instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public HierarchyFactoryImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject create(EClass eClass)
	{
		switch (eClass.getClassifierID()) {
			case HierarchyPackage.TRC_PROCESS_PROXY: return createTRCProcessProxy();
			case HierarchyPackage.TRC_OPTION: return createTRCOption();
			case HierarchyPackage.TRC_AGENT: return createTRCAgent();
			case HierarchyPackage.TRC_AGENT_PROXY: return createTRCAgentProxy();
			case HierarchyPackage.TRC_CONFIGURATION: return createTRCConfiguration();
			case HierarchyPackage.TRC_ENVIRONMENT_VARIABLE: return createTRCEnvironmentVariable();
			case HierarchyPackage.TRC_EXEC_PARAMETER: return createTRCExecParameter();
			case HierarchyPackage.TRC_FILTER: return createTRCFilter();
			case HierarchyPackage.TRC_NODE: return createTRCNode();
			case HierarchyPackage.TRC_MONITOR: return createTRCMonitor();
			case HierarchyPackage.UNRESOLVED_CORRELATION: return createUnresolvedCorrelation();
			case HierarchyPackage.CORRELATION_SOURCE_INFO: return createCorrelationSourceInfo();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object createFromString(EDataType eDataType, String initialValue)
	{
		switch (eDataType.getClassifierID()) {
			case HierarchyPackage.TRC_COLLECTION_MODE:
				return TRCCollectionMode.get(initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertToString(EDataType eDataType, Object instanceValue)
	{
		switch (eDataType.getClassifierID()) {
			case HierarchyPackage.TRC_COLLECTION_MODE:
				return instanceValue == null ? null : instanceValue.toString();
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCProcessProxy createTRCProcessProxy()
	{
		TRCProcessProxyImpl trcProcessProxy = new TRCProcessProxyImpl();
		return trcProcessProxy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCOption createTRCOption()
	{
		TRCOptionImpl trcOption = new TRCOptionImpl();
		return trcOption;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCAgent createTRCAgent()
	{
		TRCAgentImpl trcAgent = new TRCAgentImpl();
		return trcAgent;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCAgentProxy createTRCAgentProxy()
	{
		TRCAgentProxyImpl trcAgentProxy = new TRCAgentProxyImpl();
		return trcAgentProxy;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCConfiguration createTRCConfiguration()
	{
		TRCConfigurationImpl trcConfiguration = new TRCConfigurationImpl();
		return trcConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCEnvironmentVariable createTRCEnvironmentVariable()
	{
		TRCEnvironmentVariableImpl trcEnvironmentVariable = new TRCEnvironmentVariableImpl();
		return trcEnvironmentVariable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCExecParameter createTRCExecParameter()
	{
		TRCExecParameterImpl trcExecParameter = new TRCExecParameterImpl();
		return trcExecParameter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCFilter createTRCFilter()
	{
		TRCFilterImpl trcFilter = new TRCFilterImpl();
		return trcFilter;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCNode createTRCNode()
	{
		TRCNodeImpl trcNode = new TRCNodeImpl();
		return trcNode;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TRCMonitor createTRCMonitor()
	{
		TRCMonitorImpl trcMonitor = new TRCMonitorImpl();
		return trcMonitor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UnresolvedCorrelation createUnresolvedCorrelation()
	{
		UnresolvedCorrelationImpl unresolvedCorrelation = new UnresolvedCorrelationImpl();
		return unresolvedCorrelation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public CorrelationSourceInfo createCorrelationSourceInfo() {
		CorrelationSourceInfoImpl correlationSourceInfo = new CorrelationSourceInfoImpl();
		return correlationSourceInfo;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public HierarchyPackage getHierarchyPackage()
	{
		return (HierarchyPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static HierarchyPackage getPackage()
	{
		return HierarchyPackage.eINSTANCE;
	}

} //HierarchyFactoryImpl
