/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
 
/*
 * generated using Hyades customized JET templates
 */

package org.eclipse.hyades.models.hierarchy.impl;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;
import org.eclipse.emf.ecore.impl.EcorePackageImpl;
import org.eclipse.hyades.models.hierarchy.AbstractDefaultEvent;
import org.eclipse.hyades.models.hierarchy.AbstractTRCCollectionBoundary;
import org.eclipse.hyades.models.hierarchy.AbstractTRCDescription;
import org.eclipse.hyades.models.hierarchy.AbstractTRCProcess;
import org.eclipse.hyades.models.hierarchy.AbstractTRCView;
import org.eclipse.hyades.models.hierarchy.CorrelationSourceInfo;
import org.eclipse.hyades.models.hierarchy.HierarchyFactory;
import org.eclipse.hyades.models.hierarchy.HierarchyPackage;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCCollectionMode;
import org.eclipse.hyades.models.hierarchy.TRCConfiguration;
import org.eclipse.hyades.models.hierarchy.TRCEnvironmentVariable;
import org.eclipse.hyades.models.hierarchy.TRCExecParameter;
import org.eclipse.hyades.models.hierarchy.TRCFilter;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCOption;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;
import org.eclipse.hyades.models.hierarchy.UnresolvedCorrelation;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Package</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class HierarchyPackageImpl extends EPackageImpl implements HierarchyPackage {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass trcProcessProxyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass trcOptionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass trcAgentEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass trcAgentProxyEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass trcConfigurationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass trcEnvironmentVariableEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass trcExecParameterEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass trcFilterEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass trcNodeEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass trcMonitorEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass abstractDefaultEventEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass abstractTRCViewEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass abstractTRCDescriptionEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass abstractTRCProcessEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass abstractTRCCollectionBoundaryEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass unresolvedCorrelationEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EClass correlationSourceInfoEClass = null;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private EEnum trcCollectionModeEEnum = null;

	/**
	 * Creates an instance of the model <b>Package</b>, registered with
	 * {@link org.eclipse.emf.ecore.EPackage.Registry EPackage.Registry} by the package
	 * package URI value.
	 * <p>Note: the correct way to create the package is via the static
	 * factory method {@link #init init()}, which also performs
	 * initialization of the package, or returns the registered package,
	 * if one already exists.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.ecore.EPackage.Registry
	 * @see org.eclipse.hyades.models.hierarchy.HierarchyPackage#eNS_URI
	 * @see #init()
	 * @generated
	 */
	private HierarchyPackageImpl()
	{
		super(eNS_URI, HierarchyFactory.eINSTANCE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static boolean isInited = false;

	/**
	 * Creates, registers, and initializes the <b>Package</b> for this
	 * model, and for any others upon which it depends.  Simple
	 * dependencies are satisfied by calling this method on all
	 * dependent packages before doing anything else.  This method drives
	 * initialization for interdependent packages directly, in parallel
	 * with this package, itself.
	 * <p>Of this package and its interdependencies, all packages which
	 * have not yet been registered by their URI values are first created
	 * and registered.  The packages are then initialized in two steps:
	 * meta-model objects for all of the packages are created before any
	 * are initialized, since one package's meta-model objects may refer to
	 * those of another.
	 * <p>Invocation of this method will not affect any packages that have
	 * already been initialized.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #eNS_URI
	 * @see #createPackageContents()
	 * @see #initializePackageContents()
	 * @generated
	 */
	public static HierarchyPackage init()
	{
		if (isInited) return (HierarchyPackage)EPackage.Registry.INSTANCE.get(HierarchyPackage.eNS_URI);

		// Obtain or create and register package.
		HierarchyPackageImpl theHierarchyPackage = (HierarchyPackageImpl)(EPackage.Registry.INSTANCE.get(eNS_URI) instanceof EPackage ? EPackage.Registry.INSTANCE.get(eNS_URI) : new HierarchyPackageImpl());

		isInited = true;

		// Initialize simple dependencies
		EcorePackageImpl.init();

		// Obtain or create and register interdependencies

		// Step 1: create meta-model objects
		theHierarchyPackage.createPackageContents();

		// Step 2: complete initialization
		theHierarchyPackage.initializePackageContents();

		return theHierarchyPackage;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTRCProcessProxy()
	{
		return trcProcessProxyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCProcessProxy_Name()
	{
		return (EAttribute)trcProcessProxyEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCProcessProxy_RuntimeId()
	{
		return (EAttribute)trcProcessProxyEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCProcessProxy_Pid()
	{
		return (EAttribute)trcProcessProxyEClass.getEAttributes().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCProcessProxy_Classpath()
	{
		return (EAttribute)trcProcessProxyEClass.getEAttributes().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCProcessProxy_Parameters()
	{
		return (EAttribute)trcProcessProxyEClass.getEAttributes().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCProcessProxy_LaunchMode()
	{
		return (EAttribute)trcProcessProxyEClass.getEAttributes().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCProcessProxy_Location()
	{
		return (EAttribute)trcProcessProxyEClass.getEAttributes().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCProcessProxy_VmArguments()
	{
		return (EAttribute)trcProcessProxyEClass.getEAttributes().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCProcessProxy_Active()
	{
		return (EAttribute)trcProcessProxyEClass.getEAttributes().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCProcessProxy_ExecParameters()
	{
		return (EReference)trcProcessProxyEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCProcessProxy_EnvironmentVariables()
	{
		return (EReference)trcProcessProxyEClass.getEReferences().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCProcessProxy_Node()
	{
		return (EReference)trcProcessProxyEClass.getEReferences().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCProcessProxy_AgentProxies()
	{
		return (EReference)trcProcessProxyEClass.getEReferences().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTRCOption()
	{
		return trcOptionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCOption_Key()
	{
		return (EAttribute)trcOptionEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCOption_Value()
	{
		return (EAttribute)trcOptionEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCOption_Configuration()
	{
		return (EReference)trcOptionEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTRCAgent()
	{
		return trcAgentEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCAgent_Name()
	{
		return (EAttribute)trcAgentEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCAgent_Type()
	{
		return (EAttribute)trcAgentEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCAgent_RuntimeId()
	{
		return (EAttribute)trcAgentEClass.getEAttributes().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCAgent_StartTime()
	{
		return (EAttribute)trcAgentEClass.getEAttributes().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCAgent_StopTime()
	{
		return (EAttribute)trcAgentEClass.getEAttributes().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCAgent_CollectionMode()
	{
		return (EAttribute)trcAgentEClass.getEAttributes().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCAgent_Version()
	{
		return (EAttribute)trcAgentEClass.getEAttributes().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCAgent_DefaultEvents()
	{
		return (EReference)trcAgentEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCAgent_View()
	{
		return (EReference)trcAgentEClass.getEReferences().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCAgent_Descriptor()
	{
		return (EReference)trcAgentEClass.getEReferences().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCAgent_Process()
	{
		return (EReference)trcAgentEClass.getEReferences().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCAgent_AgentProxy()
	{
		return (EReference)trcAgentEClass.getEReferences().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCAgent_UnresolvedCorrelations()
	{
		return (EReference)trcAgentEClass.getEReferences().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTRCAgentProxy()
	{
		return trcAgentProxyEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCAgentProxy_Name()
	{
		return (EAttribute)trcAgentProxyEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCAgentProxy_Type()
	{
		return (EAttribute)trcAgentProxyEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCAgentProxy_RuntimeId()
	{
		return (EAttribute)trcAgentProxyEClass.getEAttributes().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCAgentProxy_StartTime()
	{
		return (EAttribute)trcAgentProxyEClass.getEAttributes().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCAgentProxy_StopTime()
	{
		return (EAttribute)trcAgentProxyEClass.getEAttributes().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCAgentProxy_CollectionMode()
	{
		return (EAttribute)trcAgentProxyEClass.getEAttributes().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCAgentProxy_Active()
	{
		return (EAttribute)trcAgentProxyEClass.getEAttributes().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCAgentProxy_Attached()
	{
		return (EAttribute)trcAgentProxyEClass.getEAttributes().get(7);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCAgentProxy_CollectionData()
	{
		return (EAttribute)trcAgentProxyEClass.getEAttributes().get(8);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCAgentProxy_Monitored()
	{
		return (EAttribute)trcAgentProxyEClass.getEAttributes().get(9);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCAgentProxy_ProfileFile()
	{
		return (EAttribute)trcAgentProxyEClass.getEAttributes().get(10);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCAgentProxy_ProcessProxy()
	{
		return (EReference)trcAgentProxyEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCAgentProxy_Configurations()
	{
		return (EReference)trcAgentProxyEClass.getEReferences().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCAgentProxy_Agent()
	{
		return (EReference)trcAgentProxyEClass.getEReferences().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTRCConfiguration()
	{
		return trcConfigurationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCConfiguration_Name()
	{
		return (EAttribute)trcConfigurationEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCConfiguration_Active()
	{
		return (EAttribute)trcConfigurationEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCConfiguration_Options()
	{
		return (EReference)trcConfigurationEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCConfiguration_Filters()
	{
		return (EReference)trcConfigurationEClass.getEReferences().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCConfiguration_AgentProxy()
	{
		return (EReference)trcConfigurationEClass.getEReferences().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTRCEnvironmentVariable()
	{
		return trcEnvironmentVariableEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCEnvironmentVariable_Name()
	{
		return (EAttribute)trcEnvironmentVariableEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCEnvironmentVariable_Value()
	{
		return (EAttribute)trcEnvironmentVariableEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCEnvironmentVariable_ProcessProxy()
	{
		return (EReference)trcEnvironmentVariableEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTRCExecParameter()
	{
		return trcExecParameterEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCExecParameter_Key()
	{
		return (EAttribute)trcExecParameterEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCExecParameter_Value()
	{
		return (EAttribute)trcExecParameterEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCExecParameter_ProcessProxy()
	{
		return (EReference)trcExecParameterEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTRCFilter()
	{
		return trcFilterEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCFilter_Type()
	{
		return (EAttribute)trcFilterEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCFilter_Pattern()
	{
		return (EAttribute)trcFilterEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCFilter_Mode()
	{
		return (EAttribute)trcFilterEClass.getEAttributes().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCFilter_Active()
	{
		return (EAttribute)trcFilterEClass.getEAttributes().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCFilter_Operation()
	{
		return (EAttribute)trcFilterEClass.getEAttributes().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCFilter_Configuration()
	{
		return (EReference)trcFilterEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTRCNode()
	{
		return trcNodeEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCNode_RuntimeId()
	{
		return (EAttribute)trcNodeEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCNode_Timezone()
	{
		return (EAttribute)trcNodeEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCNode_Port()
	{
		return (EAttribute)trcNodeEClass.getEAttributes().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCNode_DeltaTime()
	{
		return (EAttribute)trcNodeEClass.getEAttributes().get(3);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCNode_Name()
	{
		return (EAttribute)trcNodeEClass.getEAttributes().get(4);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCNode_Description()
	{
		return (EAttribute)trcNodeEClass.getEAttributes().get(5);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCNode_IpAddress()
	{
		return (EAttribute)trcNodeEClass.getEAttributes().get(6);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCNode_Monitor()
	{
		return (EReference)trcNodeEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCNode_ProcessProxies()
	{
		return (EReference)trcNodeEClass.getEReferences().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getTRCMonitor()
	{
		return trcMonitorEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCMonitor_Name()
	{
		return (EAttribute)trcMonitorEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCMonitor_StartTime()
	{
		return (EAttribute)trcMonitorEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getTRCMonitor_StopTime()
	{
		return (EAttribute)trcMonitorEClass.getEAttributes().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getTRCMonitor_Nodes()
	{
		return (EReference)trcMonitorEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAbstractDefaultEvent()
	{
		return abstractDefaultEventEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAbstractDefaultEvent_Agent()
	{
		return (EReference)abstractDefaultEventEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAbstractTRCView()
	{
		return abstractTRCViewEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAbstractTRCView_Agent()
	{
		return (EReference)abstractTRCViewEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAbstractTRCDescription()
	{
		return abstractTRCDescriptionEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAbstractTRCDescription_Agent()
	{
		return (EReference)abstractTRCDescriptionEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAbstractTRCProcess()
	{
		return abstractTRCProcessEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAbstractTRCProcess_Agent()
	{
		return (EReference)abstractTRCProcessEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getAbstractTRCCollectionBoundary()
	{
		return abstractTRCCollectionBoundaryEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAbstractTRCCollectionBoundary_Name()
	{
		return (EAttribute)abstractTRCCollectionBoundaryEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAbstractTRCCollectionBoundary_StartTime()
	{
		return (EAttribute)abstractTRCCollectionBoundaryEClass.getEAttributes().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getAbstractTRCCollectionBoundary_CollectionMode()
	{
		return (EAttribute)abstractTRCCollectionBoundaryEClass.getEAttributes().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getAbstractTRCCollectionBoundary_Configuration()
	{
		return (EReference)abstractTRCCollectionBoundaryEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getUnresolvedCorrelation()
	{
		return unresolvedCorrelationEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EAttribute getUnresolvedCorrelation_ContextId()
	{
		return (EAttribute)unresolvedCorrelationEClass.getEAttributes().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getUnresolvedCorrelation_Agent()
	{
		return (EReference)unresolvedCorrelationEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getUnresolvedCorrelation_SourceInfos() {
		return (EReference)unresolvedCorrelationEClass.getEReferences().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EClass getCorrelationSourceInfo() {
		return correlationSourceInfoEClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCorrelationSourceInfo_Owner() {
		return (EReference)correlationSourceInfoEClass.getEReferences().get(0);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCorrelationSourceInfo_Reference() {
		return (EReference)correlationSourceInfoEClass.getEReferences().get(1);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EReference getCorrelationSourceInfo_TargetInfo() {
		return (EReference)correlationSourceInfoEClass.getEReferences().get(2);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EEnum getTRCCollectionMode()
	{
		return trcCollectionModeEEnum;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public HierarchyFactory getHierarchyFactory()
	{
		return (HierarchyFactory)getEFactoryInstance();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isCreated = false;

	/**
	 * Creates the meta-model objects for the package.  This method is
	 * guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void createPackageContents()
	{
		if (isCreated) return;
		isCreated = true;

		// Create classes and their features
		trcProcessProxyEClass = createEClass(TRC_PROCESS_PROXY);
		createEAttribute(trcProcessProxyEClass, TRC_PROCESS_PROXY__NAME);
		createEAttribute(trcProcessProxyEClass, TRC_PROCESS_PROXY__RUNTIME_ID);
		createEAttribute(trcProcessProxyEClass, TRC_PROCESS_PROXY__PID);
		createEAttribute(trcProcessProxyEClass, TRC_PROCESS_PROXY__CLASSPATH);
		createEAttribute(trcProcessProxyEClass, TRC_PROCESS_PROXY__PARAMETERS);
		createEAttribute(trcProcessProxyEClass, TRC_PROCESS_PROXY__LAUNCH_MODE);
		createEAttribute(trcProcessProxyEClass, TRC_PROCESS_PROXY__LOCATION);
		createEAttribute(trcProcessProxyEClass, TRC_PROCESS_PROXY__VM_ARGUMENTS);
		createEAttribute(trcProcessProxyEClass, TRC_PROCESS_PROXY__ACTIVE);
		createEReference(trcProcessProxyEClass, TRC_PROCESS_PROXY__EXEC_PARAMETERS);
		createEReference(trcProcessProxyEClass, TRC_PROCESS_PROXY__ENVIRONMENT_VARIABLES);
		createEReference(trcProcessProxyEClass, TRC_PROCESS_PROXY__NODE);
		createEReference(trcProcessProxyEClass, TRC_PROCESS_PROXY__AGENT_PROXIES);

		trcOptionEClass = createEClass(TRC_OPTION);
		createEAttribute(trcOptionEClass, TRC_OPTION__KEY);
		createEAttribute(trcOptionEClass, TRC_OPTION__VALUE);
		createEReference(trcOptionEClass, TRC_OPTION__CONFIGURATION);

		trcAgentEClass = createEClass(TRC_AGENT);
		createEAttribute(trcAgentEClass, TRC_AGENT__NAME);
		createEAttribute(trcAgentEClass, TRC_AGENT__TYPE);
		createEAttribute(trcAgentEClass, TRC_AGENT__RUNTIME_ID);
		createEAttribute(trcAgentEClass, TRC_AGENT__START_TIME);
		createEAttribute(trcAgentEClass, TRC_AGENT__STOP_TIME);
		createEAttribute(trcAgentEClass, TRC_AGENT__COLLECTION_MODE);
		createEAttribute(trcAgentEClass, TRC_AGENT__VERSION);
		createEReference(trcAgentEClass, TRC_AGENT__DEFAULT_EVENTS);
		createEReference(trcAgentEClass, TRC_AGENT__VIEW);
		createEReference(trcAgentEClass, TRC_AGENT__DESCRIPTOR);
		createEReference(trcAgentEClass, TRC_AGENT__PROCESS);
		createEReference(trcAgentEClass, TRC_AGENT__AGENT_PROXY);
		createEReference(trcAgentEClass, TRC_AGENT__UNRESOLVED_CORRELATIONS);

		trcAgentProxyEClass = createEClass(TRC_AGENT_PROXY);
		createEAttribute(trcAgentProxyEClass, TRC_AGENT_PROXY__NAME);
		createEAttribute(trcAgentProxyEClass, TRC_AGENT_PROXY__TYPE);
		createEAttribute(trcAgentProxyEClass, TRC_AGENT_PROXY__RUNTIME_ID);
		createEAttribute(trcAgentProxyEClass, TRC_AGENT_PROXY__START_TIME);
		createEAttribute(trcAgentProxyEClass, TRC_AGENT_PROXY__STOP_TIME);
		createEAttribute(trcAgentProxyEClass, TRC_AGENT_PROXY__COLLECTION_MODE);
		createEAttribute(trcAgentProxyEClass, TRC_AGENT_PROXY__ACTIVE);
		createEAttribute(trcAgentProxyEClass, TRC_AGENT_PROXY__ATTACHED);
		createEAttribute(trcAgentProxyEClass, TRC_AGENT_PROXY__COLLECTION_DATA);
		createEAttribute(trcAgentProxyEClass, TRC_AGENT_PROXY__MONITORED);
		createEAttribute(trcAgentProxyEClass, TRC_AGENT_PROXY__PROFILE_FILE);
		createEReference(trcAgentProxyEClass, TRC_AGENT_PROXY__PROCESS_PROXY);
		createEReference(trcAgentProxyEClass, TRC_AGENT_PROXY__CONFIGURATIONS);
		createEReference(trcAgentProxyEClass, TRC_AGENT_PROXY__AGENT);

		trcConfigurationEClass = createEClass(TRC_CONFIGURATION);
		createEAttribute(trcConfigurationEClass, TRC_CONFIGURATION__NAME);
		createEAttribute(trcConfigurationEClass, TRC_CONFIGURATION__ACTIVE);
		createEReference(trcConfigurationEClass, TRC_CONFIGURATION__OPTIONS);
		createEReference(trcConfigurationEClass, TRC_CONFIGURATION__FILTERS);
		createEReference(trcConfigurationEClass, TRC_CONFIGURATION__AGENT_PROXY);

		trcEnvironmentVariableEClass = createEClass(TRC_ENVIRONMENT_VARIABLE);
		createEAttribute(trcEnvironmentVariableEClass, TRC_ENVIRONMENT_VARIABLE__NAME);
		createEAttribute(trcEnvironmentVariableEClass, TRC_ENVIRONMENT_VARIABLE__VALUE);
		createEReference(trcEnvironmentVariableEClass, TRC_ENVIRONMENT_VARIABLE__PROCESS_PROXY);

		trcExecParameterEClass = createEClass(TRC_EXEC_PARAMETER);
		createEAttribute(trcExecParameterEClass, TRC_EXEC_PARAMETER__KEY);
		createEAttribute(trcExecParameterEClass, TRC_EXEC_PARAMETER__VALUE);
		createEReference(trcExecParameterEClass, TRC_EXEC_PARAMETER__PROCESS_PROXY);

		trcFilterEClass = createEClass(TRC_FILTER);
		createEAttribute(trcFilterEClass, TRC_FILTER__TYPE);
		createEAttribute(trcFilterEClass, TRC_FILTER__PATTERN);
		createEAttribute(trcFilterEClass, TRC_FILTER__MODE);
		createEAttribute(trcFilterEClass, TRC_FILTER__ACTIVE);
		createEAttribute(trcFilterEClass, TRC_FILTER__OPERATION);
		createEReference(trcFilterEClass, TRC_FILTER__CONFIGURATION);

		trcNodeEClass = createEClass(TRC_NODE);
		createEAttribute(trcNodeEClass, TRC_NODE__RUNTIME_ID);
		createEAttribute(trcNodeEClass, TRC_NODE__TIMEZONE);
		createEAttribute(trcNodeEClass, TRC_NODE__PORT);
		createEAttribute(trcNodeEClass, TRC_NODE__DELTA_TIME);
		createEAttribute(trcNodeEClass, TRC_NODE__NAME);
		createEAttribute(trcNodeEClass, TRC_NODE__DESCRIPTION);
		createEAttribute(trcNodeEClass, TRC_NODE__IP_ADDRESS);
		createEReference(trcNodeEClass, TRC_NODE__MONITOR);
		createEReference(trcNodeEClass, TRC_NODE__PROCESS_PROXIES);

		trcMonitorEClass = createEClass(TRC_MONITOR);
		createEAttribute(trcMonitorEClass, TRC_MONITOR__NAME);
		createEAttribute(trcMonitorEClass, TRC_MONITOR__START_TIME);
		createEAttribute(trcMonitorEClass, TRC_MONITOR__STOP_TIME);
		createEReference(trcMonitorEClass, TRC_MONITOR__NODES);

		abstractDefaultEventEClass = createEClass(ABSTRACT_DEFAULT_EVENT);
		createEReference(abstractDefaultEventEClass, ABSTRACT_DEFAULT_EVENT__AGENT);

		abstractTRCViewEClass = createEClass(ABSTRACT_TRC_VIEW);
		createEReference(abstractTRCViewEClass, ABSTRACT_TRC_VIEW__AGENT);

		abstractTRCDescriptionEClass = createEClass(ABSTRACT_TRC_DESCRIPTION);
		createEReference(abstractTRCDescriptionEClass, ABSTRACT_TRC_DESCRIPTION__AGENT);

		abstractTRCProcessEClass = createEClass(ABSTRACT_TRC_PROCESS);
		createEReference(abstractTRCProcessEClass, ABSTRACT_TRC_PROCESS__AGENT);

		abstractTRCCollectionBoundaryEClass = createEClass(ABSTRACT_TRC_COLLECTION_BOUNDARY);
		createEAttribute(abstractTRCCollectionBoundaryEClass, ABSTRACT_TRC_COLLECTION_BOUNDARY__NAME);
		createEAttribute(abstractTRCCollectionBoundaryEClass, ABSTRACT_TRC_COLLECTION_BOUNDARY__START_TIME);
		createEAttribute(abstractTRCCollectionBoundaryEClass, ABSTRACT_TRC_COLLECTION_BOUNDARY__COLLECTION_MODE);
		createEReference(abstractTRCCollectionBoundaryEClass, ABSTRACT_TRC_COLLECTION_BOUNDARY__CONFIGURATION);

		unresolvedCorrelationEClass = createEClass(UNRESOLVED_CORRELATION);
		createEAttribute(unresolvedCorrelationEClass, UNRESOLVED_CORRELATION__CONTEXT_ID);
		createEReference(unresolvedCorrelationEClass, UNRESOLVED_CORRELATION__AGENT);
		createEReference(unresolvedCorrelationEClass, UNRESOLVED_CORRELATION__SOURCE_INFOS);

		correlationSourceInfoEClass = createEClass(CORRELATION_SOURCE_INFO);
		createEReference(correlationSourceInfoEClass, CORRELATION_SOURCE_INFO__OWNER);
		createEReference(correlationSourceInfoEClass, CORRELATION_SOURCE_INFO__REFERENCE);
		createEReference(correlationSourceInfoEClass, CORRELATION_SOURCE_INFO__TARGET_INFO);

		// Create enums
		trcCollectionModeEEnum = createEEnum(TRC_COLLECTION_MODE);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private boolean isInitialized = false;

	/**
	 * Complete the initialization of the package and its meta-model.  This
	 * method is guarded to have no affect on any invocation but its first.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void initializePackageContents()
	{
		if (isInitialized) return;
		isInitialized = true;

		// Initialize package
		setName(eNAME);
		setNsPrefix(eNS_PREFIX);
		setNsURI(eNS_URI);

		// Obtain other dependent packages
		EcorePackageImpl theEcorePackage = (EcorePackageImpl)EPackage.Registry.INSTANCE.getEPackage(EcorePackage.eNS_URI);

		// Add supertypes to classes

		// Initialize classes and features; add operations and parameters
		initEClass(trcProcessProxyEClass, TRCProcessProxy.class, "TRCProcessProxy", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getTRCProcessProxy_Name(), ecorePackage.getEString(), "name", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCProcessProxy_RuntimeId(), ecorePackage.getEString(), "runtimeId", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCProcessProxy_Pid(), ecorePackage.getEInt(), "pid", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCProcessProxy_Classpath(), ecorePackage.getEString(), "classpath", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCProcessProxy_Parameters(), ecorePackage.getEString(), "parameters", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCProcessProxy_LaunchMode(), ecorePackage.getEInt(), "launchMode", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCProcessProxy_Location(), ecorePackage.getEString(), "location", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCProcessProxy_VmArguments(), ecorePackage.getEString(), "vmArguments", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCProcessProxy_Active(), ecorePackage.getEBoolean(), "active", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEReference(getTRCProcessProxy_ExecParameters(), this.getTRCExecParameter(), this.getTRCExecParameter_ProcessProxy(), "execParameters", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getTRCProcessProxy_EnvironmentVariables(), this.getTRCEnvironmentVariable(), this.getTRCEnvironmentVariable_ProcessProxy(), "environmentVariables", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getTRCProcessProxy_Node(), this.getTRCNode(), this.getTRCNode_ProcessProxies(), "node", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getTRCProcessProxy_AgentProxies(), this.getTRCAgentProxy(), this.getTRCAgentProxy_ProcessProxy(), "agentProxies", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		initEClass(trcOptionEClass, TRCOption.class, "TRCOption", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getTRCOption_Key(), ecorePackage.getEString(), "key", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCOption_Value(), ecorePackage.getEString(), "value", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEReference(getTRCOption_Configuration(), this.getTRCConfiguration(), this.getTRCConfiguration_Options(), "configuration", null, 1, 1, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		initEClass(trcAgentEClass, TRCAgent.class, "TRCAgent", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getTRCAgent_Name(), ecorePackage.getEString(), "name", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCAgent_Type(), ecorePackage.getEString(), "type", "_unknown", 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCAgent_RuntimeId(), ecorePackage.getEString(), "runtimeId", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCAgent_StartTime(), ecorePackage.getEDouble(), "startTime", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCAgent_StopTime(), ecorePackage.getEDouble(), "stopTime", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCAgent_CollectionMode(), this.getTRCCollectionMode(), "collectionMode", "0", 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCAgent_Version(), ecorePackage.getEString(), "version", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEReference(getTRCAgent_DefaultEvents(), this.getAbstractDefaultEvent(), this.getAbstractDefaultEvent_Agent(), "defaultEvents", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getTRCAgent_View(), this.getAbstractTRCView(), this.getAbstractTRCView_Agent(), "view", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getTRCAgent_Descriptor(), this.getAbstractTRCDescription(), this.getAbstractTRCDescription_Agent(), "descriptor", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getTRCAgent_Process(), this.getAbstractTRCProcess(), this.getAbstractTRCProcess_Agent(), "process", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getTRCAgent_AgentProxy(), this.getTRCAgentProxy(), this.getTRCAgentProxy_Agent(), "agentProxy", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getTRCAgent_UnresolvedCorrelations(), this.getUnresolvedCorrelation(), this.getUnresolvedCorrelation_Agent(), "unresolvedCorrelations", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		initEClass(trcAgentProxyEClass, TRCAgentProxy.class, "TRCAgentProxy", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getTRCAgentProxy_Name(), ecorePackage.getEString(), "name", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCAgentProxy_Type(), ecorePackage.getEString(), "type", "_unknown", 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCAgentProxy_RuntimeId(), ecorePackage.getEString(), "runtimeId", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCAgentProxy_StartTime(), ecorePackage.getEDouble(), "startTime", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCAgentProxy_StopTime(), ecorePackage.getEDouble(), "stopTime", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCAgentProxy_CollectionMode(), this.getTRCCollectionMode(), "collectionMode", "0", 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCAgentProxy_Active(), ecorePackage.getEBoolean(), "active", "false", 0, 1, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCAgentProxy_Attached(), ecorePackage.getEBoolean(), "attached", "false", 0, 1, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCAgentProxy_CollectionData(), ecorePackage.getEBoolean(), "collectionData", "false", 0, 1, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCAgentProxy_Monitored(), ecorePackage.getEBoolean(), "monitored", "false", 0, 1, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCAgentProxy_ProfileFile(), ecorePackage.getEString(), "profileFile", null, 0, 1, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEReference(getTRCAgentProxy_ProcessProxy(), this.getTRCProcessProxy(), this.getTRCProcessProxy_AgentProxies(), "processProxy", null, 0, 1, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getTRCAgentProxy_Configurations(), this.getTRCConfiguration(), this.getTRCConfiguration_AgentProxy(), "configurations", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getTRCAgentProxy_Agent(), this.getTRCAgent(), this.getTRCAgent_AgentProxy(), "agent", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		addEOperation(trcAgentProxyEClass, ecorePackage.getEBoolean(), "isToProfileFile");

		initEClass(trcConfigurationEClass, TRCConfiguration.class, "TRCConfiguration", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getTRCConfiguration_Name(), ecorePackage.getEString(), "name", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCConfiguration_Active(), ecorePackage.getEBoolean(), "active", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEReference(getTRCConfiguration_Options(), this.getTRCOption(), this.getTRCOption_Configuration(), "options", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getTRCConfiguration_Filters(), this.getTRCFilter(), this.getTRCFilter_Configuration(), "filters", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getTRCConfiguration_AgentProxy(), this.getTRCAgentProxy(), this.getTRCAgentProxy_Configurations(), "agentProxy", null, 1, 1, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		initEClass(trcEnvironmentVariableEClass, TRCEnvironmentVariable.class, "TRCEnvironmentVariable", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getTRCEnvironmentVariable_Name(), ecorePackage.getEString(), "name", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCEnvironmentVariable_Value(), ecorePackage.getEString(), "value", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEReference(getTRCEnvironmentVariable_ProcessProxy(), this.getTRCProcessProxy(), this.getTRCProcessProxy_EnvironmentVariables(), "processProxy", null, 1, 1, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		initEClass(trcExecParameterEClass, TRCExecParameter.class, "TRCExecParameter", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getTRCExecParameter_Key(), ecorePackage.getEString(), "key", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCExecParameter_Value(), ecorePackage.getEString(), "value", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEReference(getTRCExecParameter_ProcessProxy(), this.getTRCProcessProxy(), this.getTRCProcessProxy_ExecParameters(), "processProxy", null, 1, 1, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		initEClass(trcFilterEClass, TRCFilter.class, "TRCFilter", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getTRCFilter_Type(), ecorePackage.getEString(), "type", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCFilter_Pattern(), ecorePackage.getEString(), "pattern", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCFilter_Mode(), ecorePackage.getEString(), "mode", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCFilter_Active(), ecorePackage.getEBooleanObject(), "active", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCFilter_Operation(), ecorePackage.getEString(), "operation", "", 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEReference(getTRCFilter_Configuration(), this.getTRCConfiguration(), this.getTRCConfiguration_Filters(), "configuration", null, 1, 1, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		initEClass(trcNodeEClass, TRCNode.class, "TRCNode", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getTRCNode_RuntimeId(), ecorePackage.getEString(), "runtimeId", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCNode_Timezone(), ecorePackage.getEDouble(), "timezone", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCNode_Port(), ecorePackage.getEInt(), "port", "10002", 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCNode_DeltaTime(), ecorePackage.getEDouble(), "deltaTime", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCNode_Name(), ecorePackage.getEString(), "name", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCNode_Description(), ecorePackage.getEString(), "description", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCNode_IpAddress(), ecorePackage.getEString(), "ipAddress", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEReference(getTRCNode_Monitor(), this.getTRCMonitor(), this.getTRCMonitor_Nodes(), "monitor", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getTRCNode_ProcessProxies(), this.getTRCProcessProxy(), this.getTRCProcessProxy_Node(), "processProxies", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		initEClass(trcMonitorEClass, TRCMonitor.class, "TRCMonitor", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getTRCMonitor_Name(), ecorePackage.getEString(), "name", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCMonitor_StartTime(), ecorePackage.getEDouble(), "startTime", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getTRCMonitor_StopTime(), ecorePackage.getEDouble(), "stopTime", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEReference(getTRCMonitor_Nodes(), this.getTRCNode(), this.getTRCNode_Monitor(), "nodes", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		initEClass(abstractDefaultEventEClass, AbstractDefaultEvent.class, "AbstractDefaultEvent", IS_ABSTRACT, !IS_INTERFACE);
		initEReference(getAbstractDefaultEvent_Agent(), this.getTRCAgent(), this.getTRCAgent_DefaultEvents(), "agent", null, 1, 1, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		initEClass(abstractTRCViewEClass, AbstractTRCView.class, "AbstractTRCView", IS_ABSTRACT, !IS_INTERFACE);
		initEReference(getAbstractTRCView_Agent(), this.getTRCAgent(), this.getTRCAgent_View(), "agent", null, 0, 1, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		initEClass(abstractTRCDescriptionEClass, AbstractTRCDescription.class, "AbstractTRCDescription", IS_ABSTRACT, !IS_INTERFACE);
		initEReference(getAbstractTRCDescription_Agent(), this.getTRCAgent(), this.getTRCAgent_Descriptor(), "agent", null, 1, 1, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		initEClass(abstractTRCProcessEClass, AbstractTRCProcess.class, "AbstractTRCProcess", IS_ABSTRACT, !IS_INTERFACE);
		initEReference(getAbstractTRCProcess_Agent(), this.getTRCAgent(), this.getTRCAgent_Process(), "agent", null, 1, 1, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		initEClass(abstractTRCCollectionBoundaryEClass, AbstractTRCCollectionBoundary.class, "AbstractTRCCollectionBoundary", IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getAbstractTRCCollectionBoundary_Name(), ecorePackage.getEString(), "name", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getAbstractTRCCollectionBoundary_StartTime(), ecorePackage.getEDouble(), "startTime", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEAttribute(getAbstractTRCCollectionBoundary_CollectionMode(), this.getTRCCollectionMode(), "collectionMode", "0", 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEReference(getAbstractTRCCollectionBoundary_Configuration(), this.getTRCConfiguration(), null, "configuration", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		initEClass(unresolvedCorrelationEClass, UnresolvedCorrelation.class, "UnresolvedCorrelation", !IS_ABSTRACT, !IS_INTERFACE);
		initEAttribute(getUnresolvedCorrelation_ContextId(), ecorePackage.getEString(), "contextId", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_UNSETTABLE, !IS_ID, IS_UNIQUE);
		initEReference(getUnresolvedCorrelation_Agent(), this.getTRCAgent(), this.getTRCAgent_UnresolvedCorrelations(), "agent", null, 1, 1, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getUnresolvedCorrelation_SourceInfos(), this.getCorrelationSourceInfo(), this.getCorrelationSourceInfo_TargetInfo(), "sourceInfos", null, 0, -1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		initEClass(correlationSourceInfoEClass, CorrelationSourceInfo.class, "CorrelationSourceInfo", !IS_ABSTRACT, !IS_INTERFACE);
		initEReference(getCorrelationSourceInfo_Owner(), theEcorePackage.getEObject(), null, "owner", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getCorrelationSourceInfo_Reference(), theEcorePackage.getEReference(), null, "reference", null, 0, 1, !IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);
		initEReference(getCorrelationSourceInfo_TargetInfo(), this.getUnresolvedCorrelation(), this.getUnresolvedCorrelation_SourceInfos(), "targetInfo", null, 1, 1, IS_TRANSIENT, !IS_VOLATILE, IS_CHANGEABLE, !IS_COMPOSITE, !IS_RESOLVE_PROXIES, !IS_UNSETTABLE, IS_UNIQUE);

		// Initialize enums and add enum literals
		initEEnum(trcCollectionModeEEnum, TRCCollectionMode.class, "TRCCollectionMode");
		addEEnumLiteral(trcCollectionModeEEnum, TRCCollectionMode.HEAP_STATISTICS_ONLY_LITERAL);
		addEEnumLiteral(trcCollectionModeEEnum, TRCCollectionMode.HEAP_FULL_LITERAL);
		addEEnumLiteral(trcCollectionModeEEnum, TRCCollectionMode.HEAP_AND_EXECUTION_FULL_LITERAL);
		addEEnumLiteral(trcCollectionModeEEnum, TRCCollectionMode.HEAP_AND_EXECUTION_STATISTICS_ONLY_LITERAL);
		addEEnumLiteral(trcCollectionModeEEnum, TRCCollectionMode.EXECUTION_STATISTICS_ONLY_LITERAL);
		addEEnumLiteral(trcCollectionModeEEnum, TRCCollectionMode.EXECUTION_NO_INSTANCES_LITERAL);
		addEEnumLiteral(trcCollectionModeEEnum, TRCCollectionMode.EXECUTION_FULL_LITERAL);
		addEEnumLiteral(trcCollectionModeEEnum, TRCCollectionMode.HEAP_FULL_AND_EXECUTION_STATISTICS_ONLY_LITERAL);

		// Create resource
		createResource(eNS_URI);
	}
} //HierarchyPackageImpl
