/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.models.hierarchy.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMIResource;

import org.eclipse.hyades.loaders.util.RegistryReader;
import org.eclipse.hyades.models.hierarchy.TRCAgent;
import org.eclipse.hyades.models.hierarchy.TRCAgentProxy;
import org.eclipse.hyades.models.hierarchy.TRCMonitor;
import org.eclipse.hyades.models.hierarchy.TRCNode;
import org.eclipse.hyades.models.hierarchy.TRCProcessProxy;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;


public class SaveUtil {
    //~ Static fields/initializers -----------------------------------------------------------------

    protected static final boolean debugSystemOut = false;

    //~ Methods ------------------------------------------------------------------------------------

    //    private static Hashtable documentList = new Hashtable();
    //    public static void addDocument(Resource doc) {
    //        if (doc == null) {
    //            if (debugSystemOut) {
    //                System.out.println("EventLoader add doc is null!");
    //            }
    //
    //            return;
    //        }
    //
    //        //	System.out.println("File " + doc.getURI() + " is being listed");
    //        documentList.put(doc.getURI(), doc);
    //    }
    //    /**
    //     * Insert the method's description here.
    //     * Creation date: (6/1/2001 10:33:56 AM)
    //     * @return int
    //     */
    //    public static final int documentsSize() {
    //        return documentList.size();
    //    }
    //
    //    public static Hashtable getDocuments() {
    //        return documentList;
    //    }

    /**
     * Method createURI.
     * @param string
     * @return URI
     */
    public static URI createURI(String uri) {
        if (RegistryReader.isPlatformMode()) {
            if (uri.startsWith("platform:/resource")) {
                return URI.createURI(uri);
            }

            if (uri.startsWith("/")) {
                return URI.createURI("platform:/resource" + uri);
            } else {
                return URI.createURI("platform:/resource/" + uri);
            }
        } else {
            if (uri.startsWith("platform:/resource")) {
                return URI.createURI(uri.substring("platform:/resource".length()));
            }

            return URI.createURI(uri);
        }
    }

    //    public static void removeDocument(Resource doc) {
    //        if (doc == null) {
    //            if (debugSystemOut) {
    //                System.out.println("EventLoader remove doc is null!");
    //            }
    //
    //            return;
    //        }
    //
    //        documentList.remove(doc.getURI());
    //
    //        //	System.out.println("File " + doc.getURI() + " is being removed");
    //    }
    public static void save(TRCMonitor monitor, IProgressMonitor mon) throws Exception {
        try {
            saveResource(mon, monitor.eResource());
        } catch (Exception exc) {
            //System.out.println("Save exception.." + exc);
            //exc.printStackTrace();
			if (mon!= null)
				mon.done();
            throw exc;
        }

        EList nodes = monitor.getNodes();

        for (int idx = 0; idx < nodes.size(); idx++) {
            if (!((TRCNode) nodes.get(idx)).eIsProxy()) {
                save((TRCNode) nodes.get(idx), mon);
            }
        }
    }

    public static void saveDocuments() throws Exception {
        saveDocuments(null);
    }

    public static void saveDocuments(IProgressMonitor mon) throws Exception {
        EList documentList = HierarchyResourceSetImpl.getInstance().getResources();

        if (mon != null) {
            mon.beginTask("Saving...", documentList.size());
        }

        if (!documentList.isEmpty()) {
            Map options = new HashMap();

            options.put(XMIResource.OPTION_DECLARE_XML, Boolean.TRUE);

            //            if (Locale.getDefault().getLanguage().equals(Locale.ENGLISH)) {
            //                options.put(XMIResource.OPTION_ASCII_ONLY, Boolean.TRUE);
            //            }
            for (Iterator iter = documentList.iterator(); iter.hasNext();) {
                XMIResource res = ((XMIResource) iter.next());

                if (res.isModified() && res.isLoaded()) {
                    try {
                        res.save(options);
                    } catch (Exception exc) {
                        if (mon != null) {
                            mon.done();
                        }

                        throw exc;
                    }
                }
            }
        }

        if (mon != null) {
            mon.done();
        }
    }

    /**
     * Insert the method's description here.
     * Creation date: (5/30/2001 5:31:50 PM)
     * @param res org.eclipse.emf.ecore.resource.Resource
     */
    public static void saveResource(IProgressMonitor mon, Resource res) throws Exception {
        if (mon != null) {
            mon.setTaskName(res.getURI().path());
        }

        Map options = new HashMap();

        options.put(XMIResource.OPTION_DECLARE_XML, Boolean.TRUE);

        //        if (Locale.getDefault().getLanguage().equals(Locale.ENGLISH.getLanguage())) {
        //            options.put(XMIResource.OPTION_ASCII_ONLY, Boolean.TRUE);
        //        }
        res.save(options);

        if (mon != null) {
            mon.worked(1);
        }
    }

    private static final void save(TRCAgent agent, IProgressMonitor mon) throws Exception {
        if (mon!= null && mon.isCanceled()) {
            throw new OperationCanceledException();
        }

        try {
            saveResource(mon, agent.eResource());
        } catch (Exception exc) {
            //System.out.println("Save exception.." + exc);
            //exc.printStackTrace();
			if (mon!= null)
            	mon.done();
            throw exc;
        }
    }

    private static final void save(TRCNode node, IProgressMonitor mon) throws Exception {
        if (mon != null && mon.isCanceled()) {
            throw new OperationCanceledException();
        }

        try {
            saveResource(mon, node.eResource());
        } catch (Exception exc) {
            //System.out.println("Save exception.." + exc);
            //exc.printStackTrace();
			if (mon!= null)
				mon.done();
            throw exc;
        }

        EList processes = node.getProcessProxies();

        for (int idx = 0; idx < processes.size(); idx++) {
            TRCProcessProxy process = (TRCProcessProxy) processes.get(idx);

            if (!process.eIsProxy()) {
                save(process, mon);
            }
        }
    }

    private static final void save(TRCProcessProxy process, IProgressMonitor mon) throws Exception {
        if (mon != null && mon.isCanceled()) {
            throw new OperationCanceledException();
        }

        try {
            saveResource(mon, process.eResource());
        } catch (Exception exc) {
            //System.out.println("Save exception.." + exc);
            //exc.printStackTrace();
			if (mon!= null)
				mon.done();
            throw exc;
        }

        EList agents = process.getAgentProxies();

        for (int idx = 0; idx < agents.size(); idx++) {
            TRCAgent agent = ((TRCAgentProxy) agents.get(idx)).getAgent();

            if (!agent.eIsProxy()) {
                save(agent, mon);
            }
        }
    }
}
