/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.ui;

import java.util.*;

import org.eclipse.core.runtime.*;
import org.eclipse.hyades.sd.ui.internal.views.SDViewer;
import org.eclipse.hyades.trace.ui.UIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class SDPlugin extends AbstractUIPlugin
{

	private static SDPlugin inst;
	private static ResourceBundle bundle;
	private static Hashtable graphLoaderList = new Hashtable();
	private static Hashtable resouceLoaderList = new Hashtable();

	public SDPlugin(IPluginDescriptor descriptor) {
		super(descriptor);

		if (inst == null)
			inst = this;
		bundle = this.getDescriptor().getResourceBundle();
		
		initializeModelLoader();
		
	}
	public static SDPlugin getDefault() {
		return inst;
	}

	public static String getPluginId() {
		return getDefault().getDescriptor().getUniqueIdentifier();
	}

	public static ImageDescriptor getImageDescriptor(String name) {
		return SDPluginImages.getImageDescriptor(name);
	}
	
	public static ResourceBundle getResourceBundle() {
		return bundle;
	}
	
	public static String getString(String key) {
		ResourceBundle bundle = SDPlugin.getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}
	
	public void startup() throws CoreException {
		super.startup();
	}

	public void shutdown() throws CoreException {
		SDPluginImages.shutdown();
		super.shutdown();
	}

	protected void initializeDefaultPreferences(IPreferenceStore store) {
		store.setDefault(SDConstants.FILTER_SELF_CALL, true);		
	}
	
	/**
	 * find the SDViewer and show the view if specify.
	 * @param showView showing the view if found
	 * @return SDViewer
	 */
	public static SDViewer findSDViewer(boolean showView)
	{
		SDViewer sdViewer = null;
		IWorkbenchPage persp = UIPlugin.getActivePage();
		
		try {
			if (showView)
				sdViewer = (SDViewer)persp.showView("org.eclipse.hyades.sd.ui.internal.views.SDViewer");//$NON-NLS-1$
			else
				sdViewer = (SDViewer)persp.findView("org.eclipse.hyades.sd.ui.internal.views.SDViewer");//$NON-NLS-1$	
		
			return sdViewer;
		}
		catch (PartInitException e) {
			return null;
		}
	}

	public static Hashtable getGraphLoaderList() {
		return graphLoaderList;
	}
	
	public static Hashtable getResouceLoaderList() {
		return resouceLoaderList;
	}

	
	private void initializeModelLoader(){
		int graphType =-1;
		int resourceType = -1;
		IConfigurationElement modelLoader = null;
		IPluginRegistry registry = Platform.getPluginRegistry();
		IExtensionPoint point =	registry.getExtensionPoint("org.eclipse.hyades.sd.ui.SDGraphLoader");//$NON-NLS-1$
		if (point != null) 
		{
			IExtension[] extensions = point.getExtensions();

			for (int i = 0; i < extensions.length; i++) {
				 IConfigurationElement[] elements = extensions[i].getConfigurationElements();
				 for (int j = 0; j < elements.length; j++) {
					if ("graphLoader".equals(elements[j].getName())) {//$NON-NLS-1$
					   
						if (elements[j].getAttribute("types")!=null){//$NON-NLS-1$
							graphType = Integer.parseInt(elements[j].getAttribute("types"));//$NON-NLS-1$
						}
						else{
							graphType = -1;
						}
						if (elements[j].getAttribute("resource")!=null){//$NON-NLS-1$
							resourceType = Integer.parseInt(elements[j].getAttribute("resource"));//$NON-NLS-1$
						}else{
							resourceType = -1;
						}
						
					   
					   IConfigurationElement[] modelLoaders =elements[j].getChildren();
					   for (int k = 0;k < modelLoaders.length;k++) {
							if (modelLoaders[k].getName().equals("ModelLoader")) {//$NON-NLS-1$
									modelLoader = modelLoaders[k];

								if (graphType>-1)
									graphLoaderList.put(new Integer(graphType),modelLoader);
								if (resourceType>-1)
									resouceLoaderList.put(new Integer(resourceType),modelLoader);

							} 	
					   }
					}
				 }
			}
		}
	}
}
