/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.ui.internal.model;

import org.eclipse.core.runtime.*;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.sd.ui.*;
import org.eclipse.hyades.sd.ui.internal.loader.*;
/**
 * GraphFactory is used to create Graph objects. The factory itself is
 * a singleton. When a Graph is constructed, it has the type set, and the
 * loader is constructed and set based on the data model object passed in.
 */

public class GraphFactory
{
  private static GraphFactory singleton = null;
  /**
   * @since December 05, 2001
   */
  private GraphFactory()
  {
  }
  /**
   * @since December 05, 2001
   */
  public static GraphFactory getGraphFactory()
  {
    if (singleton == null)
      singleton = new GraphFactory();
    return singleton;
  }

  /**
   * @param graphType
   * @param data model root
   * @since December 05, 2001
   * Based on the data model Object type a loader is selected and added to a new
   * Graph object. the Graph object is then told to load.
   */
  public Graph createGraph(int graphType, Object dataModelObject)
  {
    return createGraph(graphType, dataModelObject, GraphContentFactory.getContentFactory());
  }
  public Graph createGraph(
    int graphType,
    Object dataModelObject,
    ContentFactory graphContentFactory)
  {
  	//System.out.println("GraphFactory.createGraph");
    Graph graph = new Graph(graphType);
    graph.setFiltered(false);
    graph.setContentFactory(graphContentFactory);
    resolveLoader(graph, dataModelObject, graphType);
    graph.load();
    return graph;
  }
 public Graph createFilteredGraph(
    int graphType,
    Object dataModelObject,
    ContentFactory graphContentFactory)
  {
  	//System.out.println("GraphFactory.createFilteredGraph");
  	Graph graph = new Graph(graphType);
    graph.setFiltered(true);
    graph.setContentFactory(graphContentFactory);
    resolveLoader(graph, dataModelObject, graphType);
    graph.load();
    return graph;
  }
  private void resolveLoader(Graph graph,Object dataModelObject, int graphType)
  {
  	IModelLoader modelLoader = null;
  	try {
  	if(graphType == Graph.LOGoverRECORD){
  		if (SDPlugin.getGraphLoaderList().get(new Integer(Graph.LOGoverRECORD))!=null)
  		{
			modelLoader = (IModelLoader) ((IConfigurationElement)(SDPlugin.getGraphLoaderList().get(new Integer(Graph.LOGoverRECORD)))).createExecutableExtension("class");
			modelLoader.setObjectAndGraph(dataModelObject,graph);
			graph.setModelLoader(modelLoader);
  		}
         return;
  	}

	if(graphType == Graph.THREADoverRECORD){
		if (SDPlugin.getGraphLoaderList().get(new Integer(Graph.THREADoverRECORD))!=null)
		{
			modelLoader = (IModelLoader) ((IConfigurationElement)(SDPlugin.getGraphLoaderList().get(new Integer(Graph.THREADoverRECORD)))).createExecutableExtension("class");
			modelLoader.setObjectAndGraph(dataModelObject,graph);
			graph.setModelLoader(modelLoader);
		}
		return;
	}
	
	if (dataModelObject instanceof TRCAgentProxy){
		if (SDPlugin.getResouceLoaderList().get(new Integer(SDConstants.AGENTLOADER))!=null)
		{
			  modelLoader = (IModelLoader) ((IConfigurationElement)(SDPlugin.getResouceLoaderList().get(new Integer(SDConstants.AGENTLOADER)))).createExecutableExtension("class");
			  modelLoader.setObjectAndGraph(dataModelObject,graph);
			  graph.setModelLoader(modelLoader);
		}
	  	return; 
	}
	
	if (dataModelObject instanceof TRCMonitor){
		if (SDPlugin.getResouceLoaderList().get(new Integer(SDConstants.MONITORLOADER))!=null)
		{
			modelLoader = (IModelLoader) ((IConfigurationElement)(SDPlugin.getResouceLoaderList().get(new Integer(SDConstants.MONITORLOADER)))).createExecutableExtension("class");
			modelLoader.setObjectAndGraph(dataModelObject,graph);
			graph.setModelLoader(modelLoader);
		}
		return;
	}
	
	if (dataModelObject instanceof TRCProcessProxy){
		if (SDPlugin.getResouceLoaderList().get(new Integer(SDConstants.PROCESSLOADER))!=null)
		{
			modelLoader = (IModelLoader) ((IConfigurationElement)(SDPlugin.getResouceLoaderList().get(new Integer(SDConstants.PROCESSLOADER)))).createExecutableExtension("class");
			modelLoader.setObjectAndGraph(dataModelObject,graph);
			graph.setModelLoader(modelLoader);
		}
		return;
	}
	
	if (dataModelObject instanceof TRCNode){
		if (SDPlugin.getResouceLoaderList().get(new Integer(SDConstants.NODELOADER))!=null)
		{
			modelLoader = (IModelLoader) ((IConfigurationElement)(SDPlugin.getResouceLoaderList().get(new Integer(SDConstants.NODELOADER)))).createExecutableExtension("class");
			modelLoader.setObjectAndGraph(dataModelObject,graph);
			graph.setModelLoader(modelLoader);
		}
		return;
	}
	
	
	}
  	catch (CoreException e)
  	{
  		e.printStackTrace();
  	}
  }

}
