/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.ui.internal.model;

/**
 * GraphNode is an object that can have things connected to it. It has the notion 
 * of a life span captured in a start and end time.
 * A GraphNode contains a set of connections it is the owner and source of. It can 
 * also be the target of connecitons. However these connections are optional.
 */
public interface GraphNode
{
  /**
  	* GraphNode provides a set of static .&q.type.&q. values that indicate the type of 
  	* graph node that has been populated. For example PROCESS is a graph node that
  	* represents a process object.
  	*/
  public static final int UNKNOWN = 0;
  public static final int CLUSTER = 1;
  public static final int NODE = 2;
  public static final int AGENT = 3;
  public static final int PROCESS = 4;
  public static final int THREAD = 5;
  public static final int OBJECT = 6;
  public static final int CLASS = 7;
  public static final int METHOD = 8;
  public static final int MONITOR = 9;
  public static final int RECORD = 10;
  public static final int LOG = 11;
  /**
   * The name of a node is intended to be used by a renderer. It is not in any 
   * namespace. This means it is not unique unless that was ensured by the data 
   * source used to populate the objects in the graph.
   */
  /*The following fields need to be part of an implementation
  public String name=null;
  public int type = 0;
  public double startTime = 0;
  public double endTime = 0;
  public Increment startIncrement = null;
  public Increment endIncrement = null;
  public int nextNewSourceConnection = 0;
  public int nextNewTargetConnection = 0;
  public int indexInContainer = 0;
  public String shortName = null;
  public String secondaryName = null;
  public Hashtable userArea = null;
  public NodeContainer container = null;
  public Graph graph = null;
  public NodeConnection lastReadTargetConnection = null;
  public NodeConnection targetConnections[] = new NodeConnection[3];
  public NodeConnection sourceConnections[] = new NodeConnection[3];
  */

  public String getName();
  public void setName(String inputName);
  
  public String getShortName();
  public void setShortName(String name);
  
  public String getSecondaryName();
  public void setSecondaryName(String name);
  
  public int getType();
  public void setType(int inputType);

  public Graph getGraph();
  public void setGraph(Graph inputGraph);

  public NodeContainer getContainer();
  public void setContainer(NodeContainer inputContainer);
  
  public double getStartTime();
  public void setStartTime(double time);

  public Increment getStartIncrement();
  public void setStartIncrement(Increment increment);

  public double getEndTime();
  public void setEndTime(double time);
  
  public void setEndIncrement(Increment increment);
  public Increment getEndIncrement();

  public int getStartIncrementValue();
  public int getEndIncrementValue();

  public void addSourceConnection(NodeConnection connection);
  public void addTargetConnection(NodeConnection connection);

  public NodeConnection[] getSourceConnections();
  public void setSourceConnections(NodeConnection[] connections);

  public NodeConnection[] getTargetConnections();
  public void setTargetConnections(NodeConnection[] connections);

  public int getSourceConnectionCount();
  public int getTargetConnectionCount();

  public NodeConnection getLastReadTargetConnection();
  public void setLastReadTargetConnection(NodeConnection connection);

  public void setUserArea(Object area);
  public Object getUserArea();

  public int getIndexInContainer();
  public void setIndexInContainer(int index);

  public int getXOffset();
  public void setXOffset(int xOffset);    
}
