/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.ui.internal.model;

public class MethodContainer extends ColumnNode implements NodeContainer{

	/**
	 * Constructor for MethodContainer.
	 */
	public MethodContainer() {
		super();
	}
	
	public GraphNode lastReadNode = null;
    public GraphNode internalNodes[] = new GraphNode[3];
    public int nextNewInternalNode = 0;
	
	/**
   * @return com.ibm.etools.pd.sd.model.GraphNode[]
   * @since November 23, 2001
   * @roseuid 3BFEC6B801BC
   */
  public GraphNode[] getInternalNodes()
  {
    return internalNodes;
  }

  /**
   * @param nodes
   * @since November 23, 2001
   * @roseuid 3BFEC6C100ED
   */
  public void setInternalNodes(GraphNode[] nodes)
  {
    internalNodes = nodes;
  }

  /**
   * @param nodes
   * @since November 23, 2001
   * @roseuid 3BFEC6CA014A
   */
  public void addInternalNode(GraphNode node)
  {
    try
      {
      internalNodes[nextNewInternalNode] = node;
    }
    catch (ArrayIndexOutOfBoundsException e)
      {
      GraphNode[] tempArray = new GraphNode[2 * internalNodes.length];
      System.arraycopy(internalNodes, 0, tempArray, 0, internalNodes.length);
      internalNodes = tempArray;
      internalNodes[nextNewInternalNode] = node;
    }
    node.setIndexInContainer(nextNewInternalNode);
    nextNewInternalNode++;
  }
  /**
   * @since December 06, 2001
   * 
   */
  public int getInternalNodeCount()
  {
  	return nextNewInternalNode;
  }
  
  
}
