/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.ui.internal.model;

/**
 * A NodeConnection links a source and target node.
 * A connection can have a life span that is refelcted in the start and end time 
 * properties.
 */
public interface NodeConnection
{
  /**
  * NodeContainer provides a set of static .&q.type.&q. values that indicate the type of 
  * connection that has been populated. For example CALL is a connection that
  * represents a call object, and RETURN represent the return.
  
  */

  public static final int UNKNOWN = 0;
  public static final int SIMPLE = 1;
  public static final int SYNCHRONOUS = 2;
  public static final int BALKING = 3;
  public static final int TIMEOUT = 4;
  public static final int CALL = 5;
  public static final int ASYNCHRONOUS = 6;
  public static final int RETURN = 7;

  /**
   * KK:The following fields need to be part of an implementation
   *
  private String name = null;
  private String shortName = null;
  private String secondaryName = null;
  private int type = 0;
  private double startTime = 0;
  private double endTime = 0;
  private Increment startIncrement = null;
  private Increment endIncrement = null;
  private Object userArea = null;
  private GraphNode source;
  private GraphNode target;

  /**
   * @return String
   * @since November 23, 2001
   * @roseuid 3BFEC43F0054
   */
  public String getName();
  /**
   * @param inputName
   * @since November 23, 2001
   * @roseuid 3BFEC4440173
   */
  public void setName(String inputName);
  /**
    * @return String
    * @since December 17, 2001
    */
  public String getShortName();
  public void setShortName(String name);
  /**
  * @return String
  * @since December 17, 2001
  */
  public String getSecondaryName();
  public void setSecondaryName(String name);
  /**
   * @return int
   * @since November 23, 2001
   * @roseuid 3BFEC44903DD
   */
  public int getType();
  /**
   * @param inputType
   * @since November 23, 2001
   * @roseuid 3BFEC44F01AB
   */
  public void setType(int inputType);
  /**
   * @return double
   * @since November 23, 2001
   * @roseuid 3BFEC4550178
   */
  public double getStartTime();
  /**
   * @param time
   * @since November 23, 2001
   * @roseuid 3BFEC45C004B
   */
  public void setStartTime(double time);
  public void setStartIncrement(Increment increment);
  /**
   * @return double
   * @since November 23, 2001
   * @roseuid 3BFEC4610279
   */
  public double getEndTime();
  /**
   * @param time
   * @since November 23, 2001
   * @roseuid 3BFEC4670368
   */
  public void setEndTime(double time);
  public void setEndIncrement(Increment increment);
  /**
  * @return long
  * @since December 13, 2001
  * 
  */
  public Increment getStartIncrement();
  public int getStartIncrementValue();
  /**
   * @return int
   * @since December 13, 2001
   * 
   */
  public Increment getEndIncrement();
  public int getEndIncrementValue();
  /**
   * @return com.ibm.etools.pd.sd.model.GraphNode
   * @since November 23, 2001
   * @roseuid 3BFEC46E01A6
   */
  public GraphNode getSource();
  /**
   * @param node
   * @since November 23, 2001
   * @roseuid 3BFEC47401C2
   */
  public void setSource(GraphNode node);
  /**
   * @return com.ibm.etools.pd.sd.model.GraphNode
   * @since November 23, 2001
   * @roseuid 3BFEC47B006E
   */
  public GraphNode getTarget();
  /**
   * @param node
   * @since November 23, 2001
   * @roseuid 3BFEC480035A
   */
  public void setTarget(GraphNode node);
  /**
   * @return Object
   * @since November 23, 2001
   * @roseuid 3BFED9700036
   */
  public Object getUserArea();
  /**
   * @param area
   * @since November 23, 2001
   * @roseuid 3BFED97F01FA
   */
  public void setUserArea(Object area);
  public void setSelected(boolean state);
  public boolean isSelected();
}
