/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.ui.internal.util;

import java.util.*;

import org.eclipse.core.runtime.*;
import org.eclipse.emf.common.util.*;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.sd.ui.*;
import org.eclipse.hyades.sd.ui.internal.views.*;
import org.eclipse.swt.*;
import org.eclipse.swt.graphics.*;
import org.eclipse.swt.widgets.*;

public class LogCDrawUtils {

	//variable are in pixel except specify in timeunits.
	static int timeUnit = 6;
	static int nodeWidth = 10;
	static int boxHeight = 40;
	static int upperSpace = 30;
	static int initBoxSpace = 60;
	static int startPosition = 0;//in timeUnits
	static int sideSpace = 5;
	static int minColumnWidth = 25;
	static int minColumnWidthExpanded = 65;
	static int bottomMax = 0;//in timeUnits
	static int overviewRatio = 1;
	static int weightScaleWidth = 15;
	static int selectedWeightIndex = -1;
	static Color weightColor = null;
	public static int SD_VIEWER = 1;
	public static int TABLE_VIEWER = 2;
	static int viewerType = 1;
	static int currentGraphType = 16;
	static SDViewerPage currentPage = null;
	
	static Color redEventFillColor = new Color(Display.getDefault(),255,0,0);
	static Color redEventStrokeColor = new Color(Display.getDefault(),255,0,0);
	static Color yellowEventFillColor = new Color(Display.getDefault(),255,237,147);
	static Color yellowEventStrokeColor = new Color(Display.getDefault(),255,191,63);
	static Color blueEventFillColor = new Color(Display.getDefault(),150,185,220);
	static Color blueEventStrokeColor = new Color(Display.getDefault(),63,127,191);
	static Color logConnectionColor = new Color(Display.getDefault(),159,159,159);
	static Color logHighLightColor = new Color(Display.getDefault(),0,0,0);

	public static void setTimeUnit(int unit) {
		timeUnit = unit;
	}
	
	public static void increaseTimeUnit(int delta){
		timeUnit+=delta;
	}
	
	public static void decreaseTimeUnit(int delta){
		timeUnit-=delta;
		if(timeUnit<1)
		   timeUnit=1;
	}

	public static int getTimeUnit() {
		return timeUnit;
	}
	
	
	public static void setNodeWidth(int width){
		nodeWidth = width;
	}
	
	public static int getNodeWidth(){
		return nodeWidth;
	}
	
	public static void setBoxHeight(int height){
		boxHeight = height;
	}
	
	public static int getBoxHeight(){
		return boxHeight;
	}
	
	public static void setUpperSpace(int space){
		upperSpace = space;
	}
	
	public static int getUpperSpace(){
		return upperSpace;
	}
	
	public static int getInitBoxSpace(){
		return initBoxSpace;
	}

	public static void setStartPosition(int pos) {
		startPosition = pos;
	}

	public static int getStartPosition() {
		return startPosition;
	}
	
	public static void adjustStartPosition(int d){
		
		//convert from time weight scale position to pixel.
		int delta = d*timeUnit;
		if(delta<=upperSpace){
		   upperSpace=30-delta;
		   boxHeight = 40;
		   startPosition = 0;//d;
		   return;
 	    }else if(delta<=boxHeight+upperSpace){
		   boxHeight=40-delta+upperSpace;
		   upperSpace = 0;
		   startPosition = 0;//d;
		   return;
		} else if(delta>boxHeight+upperSpace){
			upperSpace = 0;
			boxHeight = 0;
			startPosition = d;
			return;
		} else{
			upperSpace = 30;
			boxHeight = 40;
			startPosition = 0;
		}
		//if(selectedWeightIndex!=-1)
		   //selectedWeightIndex-=d;
		   
	}
	
	public static void setSideSpace(int space){
		sideSpace = space;
	}
	
	public static int getSideSpace(){
		return sideSpace;
	}

	public static int getMinColumnWidth() {
		return minColumnWidth;
	}
	
	public static int getMinColumnWidthExpanded() {
		return minColumnWidthExpanded;
	}
	
	public static void setBottomMax(int max){
		bottomMax = Math.max(max,bottomMax);
	}
	
	public static int getBottomMax(){
		return bottomMax;
	}

	public static Color getConnectionColor() {
		return Display.getDefault().getSystemColor(SWT.COLOR_BLUE);//connectionColor;
	}
	
	public static Color getConnectionColorOverview() {
		return Display.getDefault().getSystemColor(SWT.COLOR_BLACK);//connectionColorOverview;
	}
	
	public static Color getBackgroundColor() {
		return Display.getDefault().getSystemColor(SWT.COLOR_WHITE);//backgroundColor;
	}
	
	public static Color getForegroundColor() {
		return Display.getDefault().getSystemColor(SWT.COLOR_BLACK);//foregroundColor;
	}
	
	public static Color getForegroundSelectedColor() {
		return Display.getDefault().getSystemColor(SWT.COLOR_GREEN);//foregroundSelectedColor;
	}

	public static Color getRedEventFillColor(){
		return redEventFillColor;
	}
	public static Color getRedEventStrokeColor(){
		return redEventStrokeColor;
	}
	
	public static Color getYellowEventFillColor(){
		return yellowEventFillColor;
	}
	public static Color getYellowEventStrokeColor(){
		return yellowEventStrokeColor;
	}

	public static Color getBlueEventFillColor(){
		return blueEventFillColor;
	}
	public static Color getBlueEventStrokeColor(){
		return blueEventStrokeColor;
	}
	
	public static Color getLogConnectionColor(){
		return logConnectionColor;
	}
	
	public static Color getLogHighLightColor() {
		return logHighLightColor;
	}


	public static void dispose() {
		redEventFillColor.dispose();
		redEventStrokeColor.dispose();
		yellowEventFillColor.dispose();
		yellowEventStrokeColor.dispose();
		blueEventFillColor.dispose();
		blueEventStrokeColor.dispose();
		logConnectionColor.dispose();
		logHighLightColor.dispose();		
	}
	
	public static int getBoxSpace(){
		return upperSpace + boxHeight;
	}
	
	public static void setOverviewRatio(int rat){
		overviewRatio = rat;
	}
	
	public static int getOverviewRatio(){
		return overviewRatio;
	}
	
	public static int getWeightScaleWidth(){
		
	   return weightScaleWidth;	
	}
	
	public static void setWeightSelection(int index, Color color){
		
		if(weightColor != null)
		{		
		   weightColor.dispose();
		   weightColor = null;
		}
		
		selectedWeightIndex = index;
		weightColor = color;
	}
	
	public static int getSelectedWeightIndex(){
	   return selectedWeightIndex;	
	}
	
	public static Color getSelectedWeightColor(){
	   return weightColor;	
	}
	
	public static void setViewerType(int type){
		
	   viewerType = type;	
	}
	
	public static int getViewerType(){
		
	   return viewerType;	
	}
	
	public static void setCurrentGraphType(int type){
		currentGraphType = type;
	}
	
	public static int getCurrentGraphType(){
		return currentGraphType;
	} 

	public static void setCurrentPage(SDViewerPage page){
		currentPage = page;
	}
	
	public static SDViewerPage getCurrentPage(){
		return currentPage;
	} 
	
	public static void reset(){
	   timeUnit = 5;
	   nodeWidth = 10;
	   boxHeight = 40;
	   upperSpace = 30;
	   initBoxSpace = 60;
	   startPosition = 0;//in timeUnits
	   sideSpace = 5;
	   minColumnWidth = 25;
	   bottomMax = 0;//in timeUnits
	   overviewRatio = 1;
	   weightScaleWidth = 15;
	   selectedWeightIndex = -1;
	   
	   if(weightColor != null)
	     weightColor.dispose();
	     
	   weightColor = null;
	}

	public static String getCorrelationName(IConfigurationElement extension) {
		
		if(extension != null)
		{
			String name = extension.getAttribute("name");
			if(name != null)
			  return name;			
		}
		  
		return SDPlugin.getString("STR_NO_COR_SELECTED");
	}
	
	public static EList getAgentProxies(TRCNode node)
	{
		EList agentProxies = new BasicEList();
		Iterator processProxies = node.getProcessProxies().iterator();
		while (processProxies.hasNext())
		{
			TRCProcessProxy processProxy = (TRCProcessProxy)(processProxies.next());
			EList agents = processProxy.getAgentProxies();
			if (agents != null && agents.size()>0)
				agentProxies.addAll(agents);
		}
		return agentProxies;
	}

}
