/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.ui.internal.util;

import java.util.StringTokenizer;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.hyades.sd.ui.SDPlugin;
import org.eclipse.hyades.sd.ui.internal.views.SDViewerPage;
import org.eclipse.hyades.security.util.GridUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class LogCorrelationSelectionDialog extends Dialog implements SelectionListener {
	
	private IExtension[] extensions;
		
	private Table correlationNames;
	private Text correlationDescription;
	private Text logTypesArea;
	private SDViewerPage sdPage;
	private IConfigurationElement correlation;

	public LogCorrelationSelectionDialog(Shell parent, IExtension[] ext, SDViewerPage page){
		super(parent);
		extensions = ext;
		sdPage = page;
	}
	
	protected void configureShell(Shell shell) {
		super.configureShell(shell);
		shell.setText(SDPlugin.getString("STR_SELECT_CORRELATION"));
	}
	
	protected Control createDialogArea(Composite parent) {

		GridLayout layout;
		GridData data;
		int indent = 3;

	    Composite mainGroup = new Composite(parent, SWT.RESIZE);
	    data = GridUtil.createFill();
		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 0;
		layout.horizontalSpacing = 0;
		mainGroup.setLayout(layout);
	    mainGroup.setLayoutData(data);
			
		Label dialogLabel = new Label(mainGroup,SWT.NONE);
		dialogLabel.setText(SDPlugin.getString("STR_CHOOSE_CORRELATION"));
			
		Composite schemaGroup = new Composite(mainGroup, SWT.NONE);
		layout = new GridLayout();
		layout.numColumns = 1;
		layout.verticalSpacing = 5;
		schemaGroup.setLayout(layout);
		GridData gd =  new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalIndent = indent;
		schemaGroup.setLayoutData(gd);
	
		Label namesLabel = new Label(schemaGroup, SWT.NONE);
		namesLabel.setText(SDPlugin.getString("STR_CORRELATION_SCHEMAS"));
		
		gd = new GridData(GridData.HORIZONTAL_ALIGN_FILL | GridData.GRAB_HORIZONTAL);
		correlationNames = new Table(schemaGroup, SWT.SINGLE|SWT.H_SCROLL|SWT.V_SCROLL|SWT.BORDER);
		gd.heightHint = correlationNames.getItemHeight()* 4;		
		correlationNames.setLayoutData(gd);		
		correlationNames.addSelectionListener(this);
		
		Label logTypesLabel = new Label(schemaGroup, SWT.NONE);
		logTypesLabel.setText(SDPlugin.getString("STR_LOG_TYPES"));
		
		logTypesArea = new Text(schemaGroup, SWT.MULTI|SWT.READ_ONLY|SWT.H_SCROLL|SWT.V_SCROLL|SWT.BORDER);
		logTypesArea.setLayoutData(GridUtil.createFill());
		
		Composite describtionGroup = new Composite(mainGroup, SWT.NONE);
		layout = new GridLayout();
		layout.numColumns = 2;
		layout.verticalSpacing = 5;
		describtionGroup.setLayout(layout);
		gd =  new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalIndent = indent;
		describtionGroup.setLayoutData(gd);
				
		Label descriptionLabel = new Label(describtionGroup, SWT.NONE);
		descriptionLabel.setText(SDPlugin.getString("STR_CORRELATION_DESCRIPTION"));
		descriptionLabel.setLayoutData(new GridData(GridData.HORIZONTAL_ALIGN_BEGINNING|GridData.VERTICAL_ALIGN_BEGINNING));
		
		correlationDescription = new Text(describtionGroup, SWT.MULTI|SWT.READ_ONLY|SWT.WRAP);
		GridData d = GridUtil.createHorizontalFill();
		d.heightHint = correlationDescription.getLineHeight() * 3;
		correlationDescription.setLayoutData(d);
		
		initializeCorrelations();
				
		return mainGroup;
	}
	
	public void widgetSelected(SelectionEvent e)
	{
	   if(e.widget == correlationNames)
	      selectCorrelation(correlationNames.getSelectionIndex());
	}

	public void widgetDefaultSelected(SelectionEvent e)
	{
		okPressed();
	}
	
	public IConfigurationElement getSelectedCorrelation(){
		
	   return correlation;	
	}
	
	protected void okPressed() {
		
		correlation = (IConfigurationElement)correlationNames.getItem(correlationNames.getSelectionIndex()).getData();
		super.okPressed();
	}

    /**
     * Read correlations from plugins and initialize the dialog
     *
     */
    private void initializeCorrelations()
    {
		for (int i = 0; i < extensions.length; i++) {
			 IConfigurationElement[] elements = extensions[i].getConfigurationElements();
			 for (int j = 0; j < elements.length; j++) {
			 	
			 	IConfigurationElement elem = (IConfigurationElement) elements[j];
				if ("view".equals(elem.getName())) {
					
					TableItem item = new TableItem(correlationNames, SWT.NONE);
					item.setText(elem.getAttribute("name"));
					item.setData(elem);
				}
			 }
		}
		
		correlationNames.setSelection(0);
		selectCorrelation(0);		 	
    }
    
    /**
     * 
     * @param index
     */
    private void selectCorrelation(int index)
    {
    	String logtypes="";
    	if(index < 0 || index >= correlationNames.getItemCount())
    	  return;
    	
    	logTypesArea.setText("");
    	
		StringTokenizer tokenizer;
	    IConfigurationElement elem = (IConfigurationElement)correlationNames.getItem(index).getData();
	    if(elem != null)
	    {
			tokenizer = new StringTokenizer(elem.getAttribute("log_types"), ",", false);
			logTypesArea.setText("");
			logtypes="";
			while (tokenizer.hasMoreTokens()) {
			   logtypes=logtypes+tokenizer.nextToken()+"\n";
			}
			logTypesArea.setText(logtypes);
	    	
	    }
	    
	    correlationDescription.setText(elem.getAttribute("description"));
    }
     
}
