/**********************************************************************
Copyright (c) 2003 Hyades project.
All rights reserved.  This program and the accompanying materials
are made available under the terms of the Common Public License v1.0
which accompanies this distribution, and is available at
http://www.eclipse.org/legal/cpl-v10.html

Contributors:
 IBM Corporation - initial implementation
 IBM Rational - initial implementation
**********************************************************************/
package org.eclipse.hyades.execution.local;

import org.eclipse.hyades.execution.core.IExecutableObject;
import org.eclipse.hyades.execution.core.IExecutor;
import org.eclipse.hyades.execution.invocation.RemoteInvocationException;
import org.eclipse.hyades.execution.invocation.ReturnData;

/**
 * Instances of this type provide remote invocation semantics for
 * <code>IExecutableObject</code> instances. Executable objects are not
 * necessarily serializable; and it it is not desirable to pass these objects
 * between VMs, so we add remote semantics to executable objects. Executable
 * objects are created on the remote side and their methods are invoked via
 * the semantics provided by <code>ExecutableObjectStub</code>s.
 */
public class ExecutableObjectStub
	extends RemoteObjectStub
	implements IExecutableObject {
		
	public ExecutableObjectStub() {}

	public ExecutableObjectStub(IExecutableObject delegate) {
		this.delegate=delegate;
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutableObject#getName()
	 */
	public String getName() {
		return ((IExecutableObject)delegate).getName();
	}

	/**
	 * @see org.eclipse.hyades.execution.core.IExecutableObject#getExecutor()
	 */
	public IExecutor getExecutor() {
		return ((IExecutableObject)delegate).getExecutor();
	}

	/**
	 * Associate the delegate executable object with an executor.
	 * This operation is performed locally and remotely.
	 * 
	 * @see org.eclipse.hyades.execution.core.IExecutableObject#setExecutor(org.eclipse.hyades.execution.core.IExecutor)
	 */
	public void setExecutor(IExecutor executor) {
		// Set the value on the local side so the associated getter method
		// can be executed locally. 
		((IExecutableObject)delegate).setExecutor(executor);
		
		ReturnData rtnData = delegateRemoteCall(
			new Class[]{IExecutor.class},
			new Object[]{executor},
			"setExecutor");
		if ( rtnData.isError() )
			throw new RemoteInvocationException((Throwable)rtnData.getReturnValue());
	}

}
