package org.eclipse.hyades.logging.core;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/** 
 * Interface for serializing the content of implementing <code>java.lang.Object</code>s
 * to XML fragments .
 *  
 * 
 * @author		Richard Duggan
 * @author		Paul Slauenwhite
 * @version	March 7, 2003
 */
public interface IExternalizableToXml {

    /**
     *	Serializes the content of the implementing <code>java.lang.Object</code> to an XML fragment.
     *
     *	@return The resultant XML fragment of the serialized <code>java.lang.Object</code>.
     */
    public String externalizeCanonicalXmlString();

    /**
     *	Serializes the content of the implementing <code>java.lang.Object</code> to an XML document.
     *
     *	@return The resultant XML document of the serialized <code>java.lang.Object</code>.
     */
    public String externalizeCanonicalXmlDocString();
}
