/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.logc;

import java.util.*;

import org.eclipse.core.resources.*;
import org.eclipse.core.runtime.*;
import org.eclipse.ui.plugin.*;

/**
 * The main plugin class to be used in the desktop.
 */
public class SDLogcPlugin extends AbstractUIPlugin {
	/**
	 * The shared instance.
	 */
	private static SDLogcPlugin plugin;
	/**
	 * Resource bundle.
	 */
	private ResourceBundle resourceBundle;
	
	/**
	 * The constructor.
	 */
	public SDLogcPlugin(IPluginDescriptor descriptor) {
		super(descriptor);
		plugin = this;
		
		try {
			resourceBundle = getDescriptor().getResourceBundle();
		} catch (MissingResourceException e) {
			e.printStackTrace();
		}
	}

	/**
	 * Returns the shared instance.
	 */
	public static SDLogcPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns the workspace instance.
	 */
	public static IWorkspace getWorkspace() {
		return ResourcesPlugin.getWorkspace();
	}

	/**
	 * Returns the string from the plugin's resource bundle,
	 * or 'key' if not found.
	 */
	public static String getResourceString(String key) {
		ResourceBundle bundle= SDLogcPlugin.getDefault().getResourceBundle();
		try {
			return bundle.getString(key);
		} catch (MissingResourceException e) {
			return key;
		}
	}

	/**
	 * Returns the plugin's resource bundle,
	 */
	public ResourceBundle getResourceBundle() {
		return resourceBundle;
	}
	
	public static String getString(String key) {
		return getResourceString(key);
	}
}
