/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

package org.eclipse.hyades.sd.logc.internal.loader;

import java.util.*;

import org.eclipse.emf.common.util.*;
import org.eclipse.hyades.logc.extensions.*;
import org.eclipse.hyades.logs.correlators.*;
import org.eclipse.hyades.models.cbe.*;
import org.eclipse.hyades.models.hierarchy.*;
import org.eclipse.hyades.sd.ui.internal.model.*;

/**
 * 
 */
public class LogThreadLoader extends LogLoader {

	private HashMap threads = new HashMap();
	
	public LogThreadLoader()
	{	
	}
	/**
	 * Constructor for TRCLogThreadLoader.
	 * @param mObject
	 * @param gr
	 */
	public LogThreadLoader(Object mObject, Graph gr) {
		super(mObject, gr);
	}
	
	protected RecordList loadLog(TRCAgentProxy agent, ILogRecordFilter logFilter){
		
		EList artifacts_list = agent.getAgent().getDefaultEvents();
		 RecordList recList=null;
		 if(logFilter!=null)
			recList = new RecordList(cbeEventFilter(logFilter.filter(artifacts_list)),agent.getName());
		 else
			recList = new RecordList(cbeEventFilter(artifacts_list),agent.getName());
 		
		for (int i = 0; i < artifacts_list.size(); i++) {
			if (artifacts_list.get(i)!=null && artifacts_list.get(i) instanceof CBECommonBaseEvent) {
				CBECommonBaseEvent artifact = (CBECommonBaseEvent) artifacts_list.get(i);

				List thread =(List) threads.get(artifact.getSourceComponentId().getThreadId());

				if (thread == null) {
					List rec_list = new BasicEList();
					rec_list.add(artifact);
					threads.put(artifact.getSourceComponentId().getThreadId(),rec_list);
				} else {
					thread.add(artifact);
				}
			}
		}

		EList records = null;
		
		for (Iterator iter = threads.values().iterator(); iter.hasNext();) {
			records = (EList) iter.next();

			String thread = ((CBECommonBaseEvent)records.get(0)).getSourceComponentId().getThreadId();

			NodeContainer nodeContainer = graph.createNodeContainer();

			graph.addTopNode(nodeContainer);
			nodeContainer.setGraph(graph);
			nodeContainer.setType(GraphNode.LOG);
			
			nodeContainer.setShortName(agent.getName() + " - " + "TID:" + thread);
			addRecords(nodeContainer, records);
		}
							 
		 threads.clear();
		 return recList;
	}
	
}
 



