/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v0.5
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v05.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.hyades.loaders.trace;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.hyades.loaders.util.LoadersUtils;
import org.eclipse.hyades.loaders.util.XMLFragmentLoadersFactory;


public class TraceXMLLoadersFactory implements XMLFragmentLoadersFactory {
    //~ Methods ------------------------------------------------------------------------------------

    protected static final String methodEntry = "methodEntry";
	protected static final String methodExit = "methodExit";
	protected static final String objAlloc = "objAlloc";
	protected static final String objFree = "objFree";
	protected static final String methodDef = "methodDef";
	protected static final String classDef = "classDef";
	protected static final String threadStart = "threadStart";
	protected static final String threadEnd = "threadEnd";
	protected static final String gcStart = "gcStart";
	protected static final String gcFinish = "gcFinish";
	protected static final String traceStart = "traceStart";
	protected static final String traceEnd = "traceEnd";
	protected static final String runtimeShutdown = "runtimeShutdown";
	protected static final String runtimeInitDone = "runtimeInitDone";
	protected static final String heapDumpDef = "heapDumpDef";
	protected static final String objReference = "objReference";
	    
	public String getLoaderClassName(String elementName) {
		switch (LoadersUtils.getHashCode(elementName)) {
			case TraceConstants.methodEntry_int:
				return XMLmethodEntryLoader.class.getName();
			case TraceConstants.methodExit_int :
				return XMLmethodExitLoader.class.getName();
			case TraceConstants.objAlloc_int:
				return XMLobjAllocLoader.class.getName();
			case TraceConstants.objFree_int :
				return XMLobjFreeLoader.class.getName();
			case TraceConstants.methodDef_int :
				return XMLmethodDefLoader.class.getName();
			case TraceConstants.classDef_int :
				return XMLclassDefLoader.class.getName();
			case TraceConstants.threadStart_int :
				return XMLthreadStartLoader.class.getName();
			case TraceConstants.threadEnd_int :
				return XMLthreadEndLoader.class.getName();
			case TraceConstants.gcStart_int :
				return XMLgcStartLoader.class.getName();
			case TraceConstants.gcFinish_int :
				return XMLgcFinishLoader.class.getName();
			case TraceConstants.traceStart_int :
				return XMLtraceStartLoader.class.getName();
			case TraceConstants.traceEnd_int :
				return XMLtraceEndLoader.class.getName();
			case TraceConstants.runtimeShutdown_int :
				return XMLruntimeShutdownLoader.class.getName();
			case TraceConstants.runtimeInitDone_int :
				return XMLruntimeInitDoneLoader.class.getName();
			case TraceConstants.heapDumpDef_int :
				return XMLheapDumpDefLoader.class.getName();
			case TraceConstants.objReference_int :
				return XMLobjReferenceLoader.class.getName();
			default :
				return null;
		}
    }

    public Set getSupportedElements() {
        Set set = new HashSet();

        set.add(traceStart);
        set.add(traceEnd);
        set.add(threadStart);
        set.add(threadEnd);
        set.add(classDef);
        set.add(objAlloc);
		set.add(objFree);
		set.add(heapDumpDef);
		set.add(objReference);
        set.add(gcStart);
        set.add(gcFinish);
        set.add(methodDef);
        set.add(methodEntry);
        set.add(methodExit);
        set.add(runtimeShutdown);
        set.add(runtimeInitDone);

        return set;
    }
}
