package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * The OtherSituation category is to provide support for the situation that is 
 * product specific requirement other than the predefined categories.
 * 
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 * @see ISituationType
 */
public interface IOtherSituation extends ISituationType {

    /**
     * Returns the anyData.
     * 
     * Any other situation that is product specific requirement other than the 
     * predefined categories.
     * 
     * @return String The returned anyData.
     * @since 1.0.1
     */
    public String[] getAnyData();
    
    /**
     * Sets the anyData.
     * 
     * Any other situation that is product specific requirement other than the 
     * predefined categories.
     * 
     * @param anyData The anyData to be set.
     * @since 1.0.1
     */
    public void setAnyData(String[] anyData);
}
