package org.eclipse.hyades.logging.events;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * The situation specifies the type of the situation that caused the event 
 * to be reported. The situation is the data that describes the situation 
 * or event reported by the event.  The situation information includes a required 
 * set of properties or attributes that are common across products groups and platforms, 
 * yet architected and flexible to allow for adoption to product-specific requirements. 
 * 
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 */
public interface ISituation {

    public static final String AVAILABLE_SITUATION_CATEGORY = "AvailableSituation";
    public static final String CONFIGURE_SITUATION_CATEGORY = "ConfigureSituation";
    public static final String CONNECT_SITUATION_CATEGORY = "ConnectSituation";
    public static final String CREATE_SITUATION_CATEGORY = "CreateSituation";
    public static final String DEPENDENCY_SITUATION_CATEGORY = "DependencySituation";
    public static final String DESTROY_SITUATION_CATEGORY = "DestroySituation";
    public static final String FEATURE_SITUATION_CATEGORY = "FeatureSituation";
    public static final String OTHER_SITUATION_CATEGORY = "OtherSituation";
    public static final String REPORT_SITUATION_CATEGORY = "ReportSituation";
    public static final String REQUEST_SITUATION_CATEGORY = "RequestSituation";
    public static final String START_SITUATION_CATEGORY = "StartSituation";
    public static final String STOP_SITUATION_CATEGORY = "StopSituation";

    /**
     * Returns the situationType.
     * 
     * The situationType specifies the type of the situation that caused 
     * the event to be reported. See SituationType definition for details.
     * This is an REQUIRED property. 
     * 
     * @return String The returned situationType.
     * @since 1.0.1
     */
    public ISituationType getSituationType();

    /**
     * Returns the categoryName.
     * 
     * The categoryName specifies the type of the situation that caused the event to be reported.  
     * The categoryName is a string and has the following set of values: 
     * 
     * StartSituation
     * StopSituation
     * ConnectSituation
     * ConfigureSituation
     * RequestSituation
     * FeatureSituation
     * DependencySituation
     * CreateSituation
     * DestroySituation
     * ReportSituation
     * AvailableSituation
     * OtherSituation
     * 
     * This is a REQUIRED property. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @return String The returned categoryName.
     * @since 1.0.1
     */
    public String getCategoryName();

    /**
     * Sets the situationType.
     * 
     * The situationType specifies the type of the situation that caused 
     * the event to be reported. See SituationType definition for details.
     * This is an REQUIRED property. 
     * 
     * @param situationType The situationType to be set.
     * @since 1.0.1
     */
    public void setSituationType(ISituationType situationType);

    /**
     * Sets the categoryName.
     * 
     * The categoryName specifies the type of the situation that caused the event to be reported.  
     * The categoryName is a string and has the following set of values: 
     * 
     * StartSituation
     * StopSituation
     * ConnectSituation
     * ConfigureSituation
     * RequestSituation
     * FeatureSituation
     * DependencySituation
     * CreateSituation
     * DestroySituation
     * ReportSituation
     * AvailableSituation
     * OtherSituation
     * 
     * This is a REQUIRED property. 
     * The string length for this property MUST NOT exceed 64 characters.
     * 
     * @param categoryName The categoryName to be set.
     * @since 1.0.1
     */
    public void setCategoryName(String categoryName);

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     */
    public void init();

    /**
     * Helper method to set the specified situation.
     */
    public void setAvailableSituation(String reasoningScope, String availabilityDisposition, String operationDisposition, String processingDisposition);

    /**
     * Helper method to set the specified situation.
     */
    public void setConfigureSituation(String reasoningScope, String successDisposition);

    /**
     * Helper method to set the specified situation.
     */
    public void setConnectSituation(String reasoningScope, String situationDisposition, String successDisposition);

    /**
     * Helper method to set the specified situation.
     */
    public void setCreateSituation(String reasoningScope, String successDisposition);

    /**
     * Helper method to set the specified situation.
     */
    public void setDependencySituation(String reasoningScope, String dependencyDisposition);

    /**
     * Helper method to set the specified situation.
     */
    public void setDestroySituation(String reasoningScope, String successDisposition);

    /**
     * Helper method to set the specified situation.
     */
    public void setFeatureSituation(String reasoningScope, String featureDisposition);

    /**
     * Helper method to set the specified situation.
     */
    public void setOtherSituation(String reasoningScope, String any);

    /**
     * Helper method to set the specified situation.
     */
    public void setReportSituation(String reasoningScope, String reportCategory);

    /**
     * Helper method to set the specified situation.
     */
    public void setRequestSituation(String reasoningScope, String situationQualifier, String successDisposition);

    /**
     * Helper method to set the specified situation.
     */
    public void setStartSituation(String reasoningScope, String situationQualifier, String successDisposition);

    /**
     * Helper method to set the specified situation.
     */
    public void setStopSituation(String reasoningScope, String situationQualifier, String successDisposition);
}
