package org.eclipse.hyades.logging.events;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;

/**********************************************************************
 * Copyright (c) 2003 Hyades project.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/

/**
 * The OtherSituation category is to provide support for the situation that is 
 * product specific requirement other than the predefined categories.
 * 
 * 
 * @author Richard K. Duggan
 * @author Paul E. Slauenwhite
 * @version 1.0.1
 * @since 1.0.1
 * @see IStartSituation
 * @see IOtherSituation
 */
public class OtherSituationImpl extends SituationTypeImpl implements IOtherSituation, Serializable, Cloneable {

    //Define the serialiVersionUID for serialization:
    //NOTE: If this object is ever changed which breaks backward compatibility,
    //this value MUST be changed.  Every effort should be made not to break 
    //backward compatibility.
    static final long serialVersionUID = -3888096669772662967L;

    //Define the fields that will be serialized: 
    //NOTE: If any new variables are added to the class this table should be 
    //updated along with the readObject and writeObject methods.
    private static final ObjectStreamField[] serialPersistentFields = { new ObjectStreamField("anyData", String[].class)};

    //Class instance variable(s):
    protected String[] anyData = null;

    /**
     * No-argument protected constructor for OtherSituationImpl.
     */
    protected OtherSituationImpl() {
		super();
    }

    /**
     * Returns the anyData.
     * 
     * Any other situation that is product specific requirement other than the 
     * predefined categories.
     * 
     * @return String The returned anyData.
     * @since 1.0.1
     */
    public String[] getAnyData() {
        return anyData;
    }

    /**
     * Sets the anyData.
     * 
     * Any other situation that is product specific requirement other than the 
     * predefined categories.
     * 
     * @param anyData The anyData to be set.
     * @since 1.0.1
     */
    public void setAnyData(String[] anyData) {
        this.anyData = anyData;
    }

    /**
     * Overrides the <code>java.lang.Object</code>'s equals() API to 
     * determine if the parameter <code>object</code> is equal to this object.
     * 
     * @param object The <code>java.lang.Object</code> to be compared to this object.
     * @return true if this object is the same as the parameter <code>object</code>, false otherwise.
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object object) {

        //Check if the parameter object's super class is equal to the this object's super class:
        if (super.equals(object)) {

            //Compare the value(s) of all object properties:
            String[] thisObjectsProperty = getAnyData();
            String[] parameterObjectsProperty = ((OtherSituationImpl) (object)).getAnyData();

            if ((thisObjectsProperty == null) && (parameterObjectsProperty == null))
                return true;

            if ((thisObjectsProperty != null) && (parameterObjectsProperty != null) && (thisObjectsProperty.length == parameterObjectsProperty.length)) {

                for (int counter = 0; counter < thisObjectsProperty.length; counter++) {

                    if (!thisObjectsProperty[counter].equals(parameterObjectsProperty[counter]))
                        return false;
                }

                return true;
            }
        }

        return false;
    }
    private void writeObject(ObjectOutputStream out) throws IOException {

        //Set the values of the serializable field(s):
        ObjectOutputStream.PutField fields = out.putFields();

        fields.put("anyData", anyData);

        //Write the values of the serializable field(s):
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {

        //Prepare and read the alternate persistent field(s):
        ObjectInputStream.GetField fields = null;

        fields = in.readFields();

        //Retrieve the alternate persistent field(s):
        anyData = ((String[]) (fields.get("anyData", anyData)));
    }

    /**
     * Return a clone (copy by value) of this object. This is a deep copy version, 
     * in which all the objects within this object will be copied by value.
     *  
     * @return Object The clone of this object.
     */
    public Object clone() throws CloneNotSupportedException {

        OtherSituationImpl copy = ((OtherSituationImpl) (super.clone()));

		if (this.anyData != null)
			copy.anyData = ((String[]) (this.anyData.clone()));

        return copy;
    }

    /**
     * Resets the object's properties to their initial (e.g. null) state.
     * 
     * @see org.eclipse.hyades.logging.events.ISituationType#init()
     */
    public void init() {

        super.init();

        anyData = null;
    }
}